/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.callbacks.ICallbackWithListeners;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.editor.BaseEditor;
import org.python.pydev.shared_ui.outline.ContentOutlinePageWithFilter;
import org.python.pydev.shared_ui.outline.IOutlineModel;
import org.python.pydev.shared_ui.outline.IParsedItem;
import org.python.pydev.shared_ui.outline.OutlineLinkWithEditorAction;
import org.python.pydev.shared_ui.outline.OutlineSortByNameAction;
import org.python.pydev.shared_ui.outline.ParsedContentProvider;
import org.python.pydev.shared_ui.outline.ParsedLabelProvider;

public abstract class BaseOutlinePage
extends ContentOutlinePageWithFilter
implements IShowInTarget,
IAdaptable {
    protected IDocument document;
    protected final IOutlineModel model;
    protected final IImageCache imageCache;
    protected ISelectionChangedListener selectionListener;
    protected BaseEditor editorView;
    protected OutlineLinkWithEditorAction linkWithEditor;
    public final ICallbackWithListeners onControlCreated = new CallbackWithListeners();
    public final ICallbackWithListeners onControlDisposed = new CallbackWithListeners();
    protected List createdCallbacksForControls;
    protected final String pluginId;
    private int linkLevel = 1;
    private final Object linkLock = new Object();

    public abstract IPreferenceStore getStore();

    public BaseOutlinePage(BaseEditor editorView, IImageCache imageCache, String pluginId) {
        this.imageCache = imageCache;
        this.editorView = editorView;
        this.pluginId = pluginId;
        this.model = (IOutlineModel)editorView.getAdapter(IOutlineModel.class);
        this.model.setOutlinePage(this);
    }

    public IOutlineModel getOutlineModel() {
        return this.model;
    }

    public BaseEditor getEditor() {
        return this.editorView;
    }

    protected void createParsedOutline() {
        TreeViewer tree = this.getTreeViewer();
        IDocumentProvider provider = this.editorView.getDocumentProvider();
        this.document = provider.getDocument((Object)this.editorView.getEditorInput());
        tree.setAutoExpandLevel(2);
        tree.setContentProvider((IContentProvider)new ParsedContentProvider());
        tree.setLabelProvider((IBaseLabelProvider)new ParsedLabelProvider(this.imageCache));
        tree.setInput((Object)this.getOutlineModel().getRoot());
    }

    public boolean isDisconnectedFromTree() {
        TreeViewer treeViewer2 = this.getTreeViewer();
        if (treeViewer2 == null) {
            return true;
        }
        Tree tree = treeViewer2.getTree();
        if (tree == null) {
            return true;
        }
        return tree.isDisposed();
    }

    public void dispose() {
        this.onControlDisposed.call((Object)this.getTreeViewer());
        if (this.createdCallbacksForControls != null) {
            for (Object o : this.createdCallbacksForControls) {
                this.onControlDisposed.call(o);
            }
            this.createdCallbacksForControls = null;
        }
        if (this.selectionListener != null) {
            this.removeSelectionChangedListener(this.selectionListener);
        }
        if (this.linkWithEditor != null) {
            this.linkWithEditor.dispose();
            this.linkWithEditor = null;
        }
        super.dispose();
    }

    /*
     * Unable to fully structure code
     */
    public void refreshItems(Object[] items) {
        block14: {
            try {
                block15: {
                    this.unlinkAll();
                    viewer = this.getTreeViewer();
                    if (viewer == null) break block14;
                    treeWidget = viewer.getTree();
                    if (this.isDisconnectedFromTree()) {
                        return;
                    }
                    bar = treeWidget.getVerticalBar();
                    barPosition = 0;
                    if (bar != null) {
                        barPosition = bar.getSelection();
                    }
                    if (items != null) break block15;
                    if (this.isDisconnectedFromTree()) {
                        return;
                    }
                    viewer.refresh();
                    ** GOTO lbl26
                }
                if (this.isDisconnectedFromTree()) {
                    return;
                }
                try {
                    i = 0;
                    while (i < items.length) {
                        viewer.refresh(items[i]);
                        ++i;
                    }
lbl26:
                    // 2 sources

                    if (barPosition != 0) {
                        bar.setSelection(Math.min(bar.getMaximum(), barPosition));
                    }
                }
                catch (Throwable e) {
                    Log.log((Throwable)e);
                }
            }
            finally {
                this.relinkAll();
            }
        }
    }

    public void updateItems(Object[] items) {
        try {
            this.unlinkAll();
            if (this.isDisconnectedFromTree()) {
                return;
            }
            TreeViewer tree = this.getTreeViewer();
            if (tree != null) {
                tree.update(items, null);
            }
        }
        finally {
            this.relinkAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkAll() {
        Object object = this.linkLock;
        synchronized (object) {
            --this.linkLevel;
            if (this.linkLevel == 0) {
                this.removeSelectionChangedListener(this.selectionListener);
                if (this.linkWithEditor != null) {
                    this.linkWithEditor.unlink();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relinkAll() {
        Object object = this.linkLock;
        synchronized (object) {
            ++this.linkLevel;
            if (this.linkLevel == 1) {
                this.addSelectionChangedListener(this.selectionListener);
                if (this.linkWithEditor != null) {
                    this.linkWithEditor.relink();
                }
            } else if (this.linkLevel > 1) {
                throw new RuntimeException("Error: relinking without unlinking 1st");
            }
        }
    }

    protected void createActions() {
        this.linkWithEditor = new OutlineLinkWithEditorAction(this, this.imageCache, this.pluginId);
        Action collapseAll = new Action("Collapse all", 1){

            public void run() {
                TreeViewer treeViewer2 = BaseOutlinePage.this.getTreeViewer();
                Tree tree = treeViewer2.getTree();
                tree.setRedraw(false);
                try {
                    BaseOutlinePage.this.getTreeViewer().collapseAll();
                }
                finally {
                    tree.setRedraw(true);
                }
            }
        };
        Action expandAll = new Action("Expand all", 1){

            public void run() {
                TreeViewer treeViewer2 = BaseOutlinePage.this.getTreeViewer();
                Tree tree = treeViewer2.getTree();
                tree.setRedraw(false);
                try {
                    treeViewer2.expandAll();
                }
                finally {
                    tree.setRedraw(true);
                }
            }
        };
        collapseAll.setImageDescriptor(ImageCache.asImageDescriptor(this.imageCache.getDescriptor("icons/collapseall.gif")));
        collapseAll.setId("outline.page.collapse");
        expandAll.setImageDescriptor(ImageCache.asImageDescriptor(this.imageCache.getDescriptor("icons/expand.gif")));
        expandAll.setId("outline.page.expand");
        IActionBars actionBars = this.getSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        OutlineSortByNameAction action = new OutlineSortByNameAction(this, this.imageCache, this.pluginId);
        action.setId("outline.page.sort");
        toolbarManager.add((IAction)action);
        toolbarManager.add((IAction)collapseAll);
        toolbarManager.add((IAction)expandAll);
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IAction)this.linkWithEditor);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        try {
            this.createParsedOutline();
            this.selectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (BaseOutlinePage.this.linkWithEditor == null) {
                        return;
                    }
                    try {
                        IParsedItem firstElement;
                        ErrorDescription errorDesc;
                        BaseOutlinePage.this.unlinkAll();
                        StructuredSelection sel = (StructuredSelection)event.getSelection();
                        boolean alreadySelected = false;
                        if (sel.size() == 1 && (errorDesc = (firstElement = (IParsedItem)sel.getFirstElement()).getErrorDesc()) != null && errorDesc.message != null) {
                            int len = errorDesc.errorEnd - errorDesc.errorStart;
                            BaseOutlinePage.this.editorView.setSelection(errorDesc.errorStart, len);
                            alreadySelected = true;
                        }
                        if (!alreadySelected) {
                            ISimpleNode[] node = BaseOutlinePage.this.getOutlineModel().getSelectionPosition(sel);
                            BaseOutlinePage.this.editorView.revealModelNodes(node);
                        }
                    }
                    finally {
                        BaseOutlinePage.this.relinkAll();
                    }
                }
            };
            this.addSelectionChangedListener(this.selectionListener);
            this.createActions();
            TreeViewer treeViewer = this.getTreeViewer();
            treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            Tree tree = treeViewer.getTree();
            tree.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                    BaseOutlinePage.this.tryToMakeSelection();
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    BaseOutlinePage.this.tryToMakeSelection();
                }
            });
            tree.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                        BaseOutlinePage.this.tryToMakeSelection();
                    }
                }
            });
            this.onControlCreated.call((Object)this.getTreeViewer());
            this.createdCallbacksForControls = this.callRecursively(this.onControlCreated, (Composite)this.filter, new ArrayList());
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    private List callRecursively(ICallbackWithListeners callback, Composite c, ArrayList controls) {
        try {
            controls.add(c);
            callback.call((Object)c);
            Control[] controlArray = c.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Composite) {
                    this.callRecursively(callback, (Composite)child, controls);
                } else {
                    controls.add(child);
                    callback.call((Object)child);
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        return controls;
    }

    public boolean show(ShowInContext context) {
        this.linkWithEditor.doLinkOutlinePosition(this.editorView, this, EditorUtils.createTextSelectionUtils((ITextEditor)this.editorView));
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IShowInTarget.class) {
            return this;
        }
        return null;
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
    }

    private SelectionChangedEvent createSelectionEvent() {
        IStructuredSelection s;
        SelectionChangedEvent event = null;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && (s = (IStructuredSelection)selection).iterator().hasNext()) {
            event = new SelectionChangedEvent((ISelectionProvider)this.getTreeViewer(), selection);
        }
        return event;
    }

    private void tryToMakeSelection() {
        SelectionChangedEvent event = this.createSelectionEvent();
        if (event != null) {
            this.selectionChanged(event);
        }
    }

    public ICallbackWithListeners getOnControlCreated() {
        return this.onControlCreated;
    }

    public ICallbackWithListeners getOnControlDisposed() {
        return this.onControlDisposed;
    }
}

