/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.search;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_ui.search.AbstractSearchResultsViewerFilter;
import org.python.pydev.shared_ui.search.ICustomLineElement;
import org.python.pydev.shared_ui.search.ICustomMatch;
import org.python.pydev.shared_ui.search.ISearchIndexContentProvider;
import org.python.pydev.shared_ui.tree.TreeNodeContentProvider;

public abstract class AbstractSearchIndexTreeContentProvider
extends TreeNodeContentProvider
implements ITreeContentProvider,
ISearchIndexContentProvider {
    protected TreeNode<Object> root;
    protected Map<Object, TreeNode<?>> elementToTreeNode = new HashMap();
    protected TreeViewer viewer;
    protected AbstractTextSearchResult fResult;
    public int groupWith = 0;

    public AbstractSearchIndexTreeContentProvider(TreeViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void setGroupWith(int groupWith) {
        if (this.groupWith == groupWith) {
            return;
        }
        this.groupWith = groupWith;
        this.inputChanged((Viewer)this.viewer, null, this.fResult);
        this.clearFilterCaches();
        this.viewer.refresh();
    }

    protected void clearFilterCaches() {
        ViewerFilter[] filters = this.viewer.getFilters();
        if (filters != null) {
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter viewerFilter = viewerFilterArray[n2];
                if (viewerFilter instanceof AbstractSearchResultsViewerFilter) {
                    AbstractSearchResultsViewerFilter filter = (AbstractSearchResultsViewerFilter)viewerFilter;
                    filter.clearCache();
                }
                ++n2;
            }
        }
    }

    public int getGroupWith() {
        return this.groupWith;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.elementToTreeNode.clear();
        if (newInput instanceof AbstractTextSearchResult) {
            AbstractTextSearchResult abstractTextSearchResult;
            this.fResult = abstractTextSearchResult = (AbstractTextSearchResult)newInput;
            this.root = new TreeNode(null, newInput);
            Object[] elements = abstractTextSearchResult.getElements();
            int elementsLen = elements.length;
            int i = 0;
            while (i < elementsLen) {
                Object object = elements[i];
                Match[] matches = abstractTextSearchResult.getMatches(object);
                int matchesLen = matches.length;
                int j = 0;
                while (j < matchesLen) {
                    Match match = matches[j];
                    if (match instanceof ICustomMatch) {
                        ICustomMatch moduleMatch = (ICustomMatch)match;
                        this.obtainTeeNodeElement(moduleMatch.getLineElement());
                    } else {
                        Log.log((String)("Expecting ICustomMatch. Found:" + String.valueOf(match.getClass()) + " - " + String.valueOf(match)));
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.clear();
        }
    }

    @Override
    public Object[] getElements(Object inputElement) {
        return this.getChildren(this.root);
    }

    @Override
    public void elementsChanged(Object[] updatedElements) {
        int i = 0;
        while (i < updatedElements.length) {
            int matchCount;
            Object object = updatedElements[i];
            if (object instanceof ICustomLineElement) {
                ICustomLineElement iCustomLineElement = (ICustomLineElement)object;
                matchCount = iCustomLineElement.getNumberOfMatches(this.fResult);
            } else {
                matchCount = this.fResult.getMatchCount(updatedElements[i]);
            }
            if (matchCount > 0) {
                this.obtainTeeNodeElement(object);
            } else {
                TreeNode<?> treeNode = this.elementToTreeNode.get(object);
                if (treeNode != null) {
                    Object parent = treeNode.getParent();
                    treeNode.detachFromParent();
                    if (parent instanceof TreeNode) {
                        this.checkClearParentTree((TreeNode)parent);
                    }
                }
            }
            ++i;
        }
        this.viewer.refresh();
    }

    private void checkClearParentTree(TreeNode<?> treeNode) {
        if (!treeNode.hasChildren()) {
            Object parent = treeNode.getParent();
            treeNode.detachFromParent();
            if (parent instanceof TreeNode) {
                this.checkClearParentTree((TreeNode)parent);
            }
        }
    }

    @Override
    public void clear() {
        this.root = new TreeNode(null, null);
        this.elementToTreeNode.clear();
        this.clearFilterCaches();
        this.viewer.refresh();
    }

    protected abstract TreeNode<?> obtainTeeNodeElement(Object var1);
}

