/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.search;

import org.eclipse.jface.dialogs.IDialogSettings;

public class SearchIndexData {
    private static final String STORE_SCOPE_DATA = "scopeData";
    private static final String STORE_SCOPE = "scope";
    private static final String STORE_IS_CASE_SENSITIVE = "isCaseSensitive";
    private static final String STORE_IS_WHOLE_WORD = "isWholeWord";
    private static final String STORE_TEXT_PATTERN = "textPattern";
    private static final String STORE_FILENAME_PATTERN = "filenamePattern";
    public final String textPattern;
    public final String filenamePattern;
    public final boolean isCaseSensitive;
    public final boolean isWholeWord;
    public static final int SCOPE_MODULES = 0;
    public static final int SCOPE_PROJECTS = 1;
    public static final int SCOPE_WORKSPACE = 2;
    public static final int SCOPE_OPEN_EDITORS = 3;
    public static final int SCOPE_EXTERNAL_FOLDERS = 4;
    public static final int MAX_SCOPE = 4;
    public final int scope;
    public final String scopeData;

    public SearchIndexData(String textPattern, boolean isCaseSensitive, boolean isWholeWord, int scope, String scopeData, String filenamePattern) {
        if (textPattern == null) {
            textPattern = "";
        }
        this.textPattern = textPattern;
        this.filenamePattern = filenamePattern;
        this.isCaseSensitive = isCaseSensitive;
        this.isWholeWord = isWholeWord;
        this.scope = scope;
        if (scope < 0 || scope > 4) {
            scope = 0;
        }
        if (scopeData == null) {
            scopeData = "";
        }
        this.scopeData = scopeData;
    }

    public void store(IDialogSettings settings) {
        settings.put(STORE_TEXT_PATTERN, this.textPattern);
        settings.put(STORE_IS_CASE_SENSITIVE, this.isCaseSensitive);
        settings.put(STORE_IS_WHOLE_WORD, this.isWholeWord);
        settings.put(STORE_SCOPE, this.scope);
        settings.put(STORE_SCOPE_DATA, this.scopeData);
        settings.put(STORE_FILENAME_PATTERN, this.filenamePattern);
    }

    public static SearchIndexData create(IDialogSettings settings) {
        String textPattern = settings.get(STORE_TEXT_PATTERN);
        try {
            boolean hasStoredIsWholeWord = settings.get(STORE_IS_WHOLE_WORD) != null;
            boolean isWholeWord = true;
            if (hasStoredIsWholeWord) {
                isWholeWord = settings.getBoolean(STORE_IS_WHOLE_WORD);
            }
            boolean isCaseSensitive = settings.getBoolean(STORE_IS_CASE_SENSITIVE);
            int scope = settings.getInt(STORE_SCOPE);
            String scopeData = settings.get(STORE_SCOPE_DATA);
            String filenamePattern = settings.get(STORE_FILENAME_PATTERN);
            return new SearchIndexData(textPattern, isCaseSensitive, isWholeWord, scope, scopeData, filenamePattern);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isCaseSensitive ? 1231 : 1237);
        result = 31 * result + (this.isWholeWord ? 29 : 37);
        result = 31 * result + this.scope;
        result = 31 * result + (this.scopeData == null ? 0 : this.scopeData.hashCode());
        result = 31 * result + (this.textPattern == null ? 0 : this.textPattern.hashCode());
        result = 31 * result + (this.filenamePattern == null ? 0 : this.filenamePattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchIndexData other = (SearchIndexData)obj;
        if (this.isCaseSensitive != other.isCaseSensitive) {
            return false;
        }
        if (this.isWholeWord != other.isWholeWord) {
            return false;
        }
        if (this.scope != other.scope) {
            return false;
        }
        if (this.scopeData == null ? other.scopeData != null : !this.scopeData.equals(other.scopeData)) {
            return false;
        }
        if (this.textPattern == null ? other.textPattern != null : !this.textPattern.equals(other.textPattern)) {
            return false;
        }
        return !(this.filenamePattern == null ? other.filenamePattern != null : !this.filenamePattern.equals(other.filenamePattern));
    }
}

