/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.utils;

import org.eclipse.swt.widgets.Display;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.callbacks.ICallbackWithListeners;

public class RunInUiThread {
    public static final ICallbackWithListeners<RunInUiThreadInfo> listeners = new CallbackWithListeners();

    public static void sync(Runnable r) {
        listeners.call((Object)new RunInUiThreadInfo(r, false, true));
        if (SharedCorePlugin.inTestMode()) {
            r.run();
            return;
        }
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(r);
        } else {
            r.run();
        }
    }

    public static void async(Runnable r) {
        RunInUiThread.async(r, false);
    }

    public static void async(Runnable r, boolean runNowIfInUiThread) {
        listeners.call((Object)new RunInUiThreadInfo(r, true, runNowIfInUiThread));
        if (SharedCorePlugin.inTestMode()) {
            r.run();
            return;
        }
        Display current = Display.getCurrent();
        if (current == null) {
            Display.getDefault().asyncExec(r);
        } else if (runNowIfInUiThread) {
            r.run();
        } else {
            current.asyncExec(r);
        }
    }

    public static class RunInUiThreadInfo {
        public final Runnable runnable;
        public final boolean async;
        public final boolean runNowIfInUiThread;

        public RunInUiThreadInfo(Runnable r, boolean async, boolean runNowIfInUiThread) {
            this.runnable = r;
            this.async = async;
            this.runNowIfInUiThread = runNowIfInUiThread;
        }
    }
}

