/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.word_boundaries;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.shared_ui.word_boundaries.SequenceCharacterIterator;

public class CustomBreakIterator
extends BreakIterator {
    private static final Run WHITESPACE = new Whitespace();
    private static final Run DELIMITER = new LineDelimiter();
    private static final Run CAMELCASE = new CamelCaseIdentifier();
    private static final Run OTHER = new Other();
    protected final BreakIterator fIterator = BreakIterator.getWordInstance();
    protected CharSequence fText;
    private int fIndex = this.fIterator.current();

    @Override
    public int current() {
        return this.fIndex;
    }

    @Override
    public int first() {
        this.fIndex = this.fIterator.first();
        return this.fIndex;
    }

    @Override
    public int following(int offset) {
        if (offset == this.getText().getEndIndex()) {
            return -1;
        }
        int next = this.fIterator.following(offset);
        if (next == -1) {
            return -1;
        }
        Run run = this.consumeRun(offset);
        return offset + run.length;
    }

    private Run consumeRun(int offset) {
        char ch = this.fText.charAt(offset);
        int length = this.fText.length();
        Run run = this.getRun(ch);
        while (run.consume(ch) && offset < length - 1) {
            ch = this.fText.charAt(++offset);
        }
        return run;
    }

    private Run getRun(char ch) {
        Run run;
        if (WHITESPACE.isValid(ch)) {
            run = WHITESPACE;
        } else if (DELIMITER.isValid(ch)) {
            run = DELIMITER;
        } else if (CAMELCASE.isValid(ch)) {
            run = CAMELCASE;
        } else if (OTHER.isValid(ch)) {
            run = OTHER;
        } else {
            Assert.isTrue((boolean)false);
            return null;
        }
        run.init();
        return run;
    }

    @Override
    public CharacterIterator getText() {
        return this.fIterator.getText();
    }

    @Override
    public boolean isBoundary(int offset) {
        if (offset == this.getText().getBeginIndex()) {
            return true;
        }
        return this.following(offset - 1) == offset;
    }

    @Override
    public int last() {
        this.fIndex = this.fIterator.last();
        return this.fIndex;
    }

    @Override
    public int next() {
        this.fIndex = this.following(this.fIndex);
        return this.fIndex;
    }

    @Override
    public int next(int n) {
        return this.fIterator.next(n);
    }

    @Override
    public int preceding(int offset) {
        if (offset == this.getText().getBeginIndex()) {
            return -1;
        }
        if (this.isBoundary(offset - 1)) {
            return offset - 1;
        }
        int previous = offset - 1;
        while (!this.isBoundary(previous = this.fIterator.preceding(previous))) {
        }
        int last = -1;
        while (previous < offset) {
            last = previous;
            previous = this.following(previous);
        }
        return last;
    }

    @Override
    public int previous() {
        this.fIndex = this.preceding(this.fIndex);
        return this.fIndex;
    }

    @Override
    public void setText(String newText) {
        this.setText((CharSequence)newText);
    }

    public void setText(CharSequence newText) {
        this.fText = newText;
        this.fIterator.setText(new SequenceCharacterIterator(newText));
        this.first();
    }

    @Override
    public void setText(CharacterIterator newText) {
        if (!(newText instanceof CharSequence)) {
            throw new UnsupportedOperationException("CharacterIterator not supported");
        }
        this.fText = (CharSequence)((Object)newText);
        this.fIterator.setText(newText);
        this.first();
    }

    static final class CamelCaseIdentifier
    extends Run {
        private static final int S_INIT = 0;
        private static final int S_LOWER = 1;
        private static final int S_ONE_CAP = 2;
        private static final int S_ALL_CAPS = 3;
        private static final int S_UNDERLINE = 4;
        private static final int S_EXIT = 5;
        private static final int S_EXIT_MINUS_ONE = 6;
        private static final int K_INVALID = 0;
        private static final int K_LOWER = 1;
        private static final int K_UPPER = 2;
        private static final int K_OTHER = 3;
        private static final int K_UNDERLINE = 4;
        private int fState;
        private static final int[][] MATRIX = new int[][]{{5, 1, 2, 1, 4}, {5, 1, 5, 1, 5}, {5, 1, 3, 1, 5}, {5, 6, 3, 1, 5}, {5, 5, 5, 5, 4}};

        CamelCaseIdentifier() {
        }

        @Override
        protected void init() {
            super.init();
            this.fState = 0;
        }

        @Override
        protected boolean consume(char ch) {
            int kind = this.getKind(ch);
            this.fState = MATRIX[this.fState][kind];
            switch (this.fState) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    ++this.length;
                    return true;
                }
                case 5: {
                    return false;
                }
                case 6: {
                    --this.length;
                    return false;
                }
            }
            Assert.isTrue((boolean)false);
            return false;
        }

        private int getKind(char ch) {
            if (ch == '_') {
                return 4;
            }
            if (Character.isUpperCase(ch)) {
                return 2;
            }
            if (Character.isLowerCase(ch)) {
                return 1;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                return 3;
            }
            return 0;
        }

        @Override
        protected boolean isValid(char ch) {
            return Character.isJavaIdentifierPart(ch);
        }
    }

    static final class Identifier
    extends Run {
        Identifier() {
        }

        @Override
        protected boolean isValid(char ch) {
            return Character.isJavaIdentifierPart(ch);
        }
    }

    static final class LineDelimiter
    extends Run {
        private char fState;
        private static final char INIT = '\u0000';
        private static final char EXIT = '\u0001';

        LineDelimiter() {
        }

        @Override
        protected void init() {
            super.init();
            this.fState = '\u0000';
        }

        @Override
        protected boolean consume(char ch) {
            if (!this.isValid(ch) || this.fState == '\u0001') {
                return false;
            }
            if (this.fState == '\u0000') {
                this.fState = ch;
                ++this.length;
                return true;
            }
            if (this.fState != ch) {
                this.fState = '\u0001';
                ++this.length;
                return true;
            }
            return false;
        }

        @Override
        protected boolean isValid(char ch) {
            return ch == '\n' || ch == '\r';
        }
    }

    static final class Other
    extends Run {
        Other() {
        }

        @Override
        protected boolean isValid(char ch) {
            return !Character.isWhitespace(ch) && !Character.isJavaIdentifierPart(ch);
        }
    }

    protected static abstract class Run {
        protected int length;

        public Run() {
            this.init();
        }

        protected boolean consume(char ch) {
            if (this.isValid(ch)) {
                ++this.length;
                return true;
            }
            return false;
        }

        protected abstract boolean isValid(char var1);

        protected void init() {
            this.length = 0;
        }
    }

    static final class Whitespace
    extends Run {
        Whitespace() {
        }

        @Override
        protected boolean isValid(char ch) {
            return Character.isWhitespace(ch) && ch != '\n' && ch != '\r';
        }
    }
}

