/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.cache;

import com.kenai.jffi.ArrayFlags;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Equivalence;
import org.python.google.common.base.Stopwatch;
import org.python.google.common.base.Ticker;
import org.python.google.common.cache.AbstractCache$StatsCounter;
import org.python.google.common.cache.CacheBuilder;
import org.python.google.common.cache.CacheLoader;
import org.python.google.common.cache.LoadingCache;
import org.python.google.common.cache.RemovalCause;
import org.python.google.common.cache.RemovalListener;
import org.python.google.common.cache.RemovalNotification;
import org.python.google.common.cache.Weigher;
import org.python.google.common.collect.AbstractSequentialIterator;
import org.python.google.common.collect.Iterators;
import org.python.google.common.util.concurrent.AsyncFunction;
import org.python.google.common.util.concurrent.ExecutionError;
import org.python.google.common.util.concurrent.Futures;
import org.python.google.common.util.concurrent.ListenableFuture;
import org.python.google.common.util.concurrent.ListeningExecutorService;
import org.python.google.common.util.concurrent.SettableFuture;
import org.python.google.common.util.concurrent.UncheckedExecutionException;

class LocalCache<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final Logger logger = Logger.getLogger(LocalCache.class.getName());
    static final ListeningExecutorService sameThreadExecutor = AsyncFunction.sameThreadExecutor();
    private int segmentMask;
    private int segmentShift;
    final Segment<K, V>[] segments;
    private int concurrencyLevel;
    final Equivalence<Object> keyEquivalence;
    final Equivalence<Object> valueEquivalence;
    private Strength keyStrength;
    final Strength valueStrength;
    private long maxWeight;
    final Weigher<K, V> weigher;
    private long expireAfterAccessNanos;
    private long expireAfterWriteNanos;
    final long refreshNanos;
    final Queue<RemovalNotification<K, V>> removalNotificationQueue;
    final RemovalListener<K, V> removalListener;
    final Ticker ticker;
    final EntryFactory entryFactory;
    @Nullable
    final CacheLoader<? super K, V> defaultLoader;
    static final ValueReference<Object, Object> UNSET = new ValueReference<Object, Object>(){

        @Override
        public final Object get() {
            return null;
        }

        @Override
        public final int getWeight() {
            return 0;
        }

        @Override
        public final ReferenceEntry<Object, Object> getEntry() {
            return null;
        }

        @Override
        public final ValueReference<Object, Object> copyFor(ReferenceQueue<Object> queue, @Nullable Object value, ReferenceEntry<Object, Object> entry) {
            return this;
        }

        @Override
        public final boolean isLoading() {
            return false;
        }

        @Override
        public final boolean isActive() {
            return false;
        }

        @Override
        public final Object waitForValue() {
            return null;
        }

        @Override
        public final void notifyNewValue(Object newValue) {
        }
    };
    static final Queue<? extends Object> DISCARDING_QUEUE = new AbstractQueue<Object>(){

        @Override
        public final boolean offer(Object o) {
            return true;
        }

        @Override
        public final Object peek() {
            return null;
        }

        @Override
        public final Object poll() {
            return null;
        }

        @Override
        public final int size() {
            return 0;
        }

        @Override
        public final Iterator<Object> iterator() {
            return Iterators.emptyIterator();
        }
    };
    private Set<K> keySet;
    private Collection<V> values;
    private Set<Map.Entry<K, V>> entrySet;

    LocalCache(CacheBuilder<? super K, ? super V> builder, @Nullable CacheLoader<? super K, V> loader) {
        int segmentSize;
        int segmentCount;
        CacheBuilder<K, V> cacheBuilder;
        CacheBuilder<K, V> cacheBuilder2 = builder;
        this.concurrencyLevel = Math.min(cacheBuilder2.concurrencyLevel == -1 ? 4 : cacheBuilder2.concurrencyLevel, 65536);
        this.keyStrength = builder.getKeyStrength();
        this.valueStrength = builder.getValueStrength();
        cacheBuilder2 = builder;
        this.keyEquivalence = CharMatcher.LookupTable.firstNonNull(null, cacheBuilder2.getKeyStrength().defaultEquivalence());
        cacheBuilder2 = builder;
        this.valueEquivalence = CharMatcher.LookupTable.firstNonNull(null, cacheBuilder2.getValueStrength().defaultEquivalence());
        cacheBuilder2 = builder;
        this.maxWeight = cacheBuilder2.expireAfterWriteNanos == 0L || cacheBuilder2.expireAfterAccessNanos == 0L ? 0L : (cacheBuilder2.weigher == null ? cacheBuilder2.maximumSize : cacheBuilder2.maximumWeight);
        cacheBuilder2 = builder;
        this.weigher = CharMatcher.LookupTable.firstNonNull(cacheBuilder2.weigher, CacheBuilder.OneWeigher.INSTANCE);
        cacheBuilder2 = builder;
        this.expireAfterAccessNanos = cacheBuilder2.expireAfterAccessNanos == -1L ? 0L : cacheBuilder2.expireAfterAccessNanos;
        cacheBuilder2 = builder;
        this.expireAfterWriteNanos = cacheBuilder2.expireAfterWriteNanos == -1L ? 0L : cacheBuilder2.expireAfterWriteNanos;
        cacheBuilder2 = builder;
        this.refreshNanos = cacheBuilder2.refreshNanos == -1L ? 0L : cacheBuilder2.refreshNanos;
        cacheBuilder2 = builder;
        this.removalListener = CharMatcher.LookupTable.firstNonNull(null, CacheBuilder.NullListener.INSTANCE);
        this.removalNotificationQueue = this.removalListener == CacheBuilder.NullListener.INSTANCE ? DISCARDING_QUEUE : new ConcurrentLinkedQueue();
        cacheBuilder2 = this;
        boolean bl = ((LocalCache)((Object)cacheBuilder2)).recordsWrite() || ((LocalCache)((Object)(cacheBuilder = cacheBuilder2))).expiresAfterAccess();
        cacheBuilder2 = builder;
        this.ticker = bl ? Ticker.systemTicker() : CacheBuilder.NULL_TICKER;
        cacheBuilder2 = this;
        boolean bl2 = ((LocalCache)((Object)cacheBuilder2)).usesAccessQueue() || ((LocalCache)((Object)(cacheBuilder = cacheBuilder2))).expiresAfterAccess();
        cacheBuilder = cacheBuilder2 = this;
        this.entryFactory = EntryFactory.getFactory(this.keyStrength, bl2, ((LocalCache)((Object)cacheBuilder2)).expiresAfterWrite() || ((LocalCache)((Object)cacheBuilder2)).recordsWrite());
        cacheBuilder = builder;
        cacheBuilder.statsCounterSupplier.get();
        this.defaultLoader = loader;
        cacheBuilder2 = builder;
        int initialCapacity = Math.min(cacheBuilder2.initialCapacity == -1 ? 16 : cacheBuilder2.initialCapacity, 0x40000000);
        if (this.evictsBySize() && !this.customWeigher()) {
            initialCapacity = Math.min(initialCapacity, (int)this.maxWeight);
        }
        int segmentShift = 0;
        for (segmentCount = 1; !(segmentCount >= this.concurrencyLevel || this.evictsBySize() && (long)(segmentCount * 20) > this.maxWeight); segmentCount <<= 1) {
            ++segmentShift;
        }
        this.segmentShift = 32 - segmentShift;
        this.segmentMask = segmentCount - 1;
        int n = segmentCount;
        this.segments = new Segment[n];
        int segmentCapacity = initialCapacity / segmentCount;
        if (segmentCapacity * segmentCount < initialCapacity) {
            ++segmentCapacity;
        }
        for (segmentSize = 1; segmentSize < segmentCapacity; segmentSize <<= 1) {
        }
        if (this.evictsBySize()) {
            long maxSegmentWeight = this.maxWeight / (long)segmentCount + 1L;
            long remainder = this.maxWeight % (long)segmentCount;
            for (int i = 0; i < this.segments.length; ++i) {
                if ((long)i == remainder) {
                    --maxSegmentWeight;
                }
                cacheBuilder = builder;
                this.segments[i] = this.createSegment(segmentSize, maxSegmentWeight, cacheBuilder.statsCounterSupplier.get());
            }
            return;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            cacheBuilder = builder;
            this.segments[i] = this.createSegment(segmentSize, -1L, cacheBuilder.statsCounterSupplier.get());
        }
    }

    final boolean evictsBySize() {
        return this.maxWeight >= 0L;
    }

    final boolean customWeigher() {
        return this.weigher != CacheBuilder.OneWeigher.INSTANCE;
    }

    final boolean expiresAfterWrite() {
        return this.expireAfterWriteNanos > 0L;
    }

    final boolean expiresAfterAccess() {
        return this.expireAfterAccessNanos > 0L;
    }

    final boolean refreshes() {
        return this.refreshNanos > 0L;
    }

    final boolean usesAccessQueue() {
        return this.expiresAfterAccess() || this.evictsBySize();
    }

    final boolean recordsWrite() {
        return this.expiresAfterWrite() || this.refreshes();
    }

    final boolean usesKeyReferences() {
        return this.keyStrength != Strength.STRONG;
    }

    final boolean usesValueReferences() {
        return this.valueStrength != Strength.STRONG;
    }

    static <K, V> ValueReference<K, V> unset() {
        return UNSET;
    }

    static <K, V> ReferenceEntry<K, V> nullEntry() {
        return NullEntry.INSTANCE;
    }

    static <E> Queue<E> discardingQueue() {
        return DISCARDING_QUEUE;
    }

    final int hash(Object key) {
        int h;
        int n = h = this.keyEquivalence.hash(key);
        n = h + (n << 15 ^ 0xFFFFCD7D);
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    final Segment<K, V> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    private Segment<K, V> createSegment(int initialCapacity, long maxSegmentWeight, AbstractCache$StatsCounter statsCounter) {
        return new Segment(this, initialCapacity, maxSegmentWeight, statsCounter);
    }

    final boolean isExpired(ReferenceEntry<K, V> entry, long now) {
        if (this.expiresAfterAccess() && now - entry.getAccessTime() > this.expireAfterAccessNanos) {
            return true;
        }
        return this.expiresAfterWrite() && now - entry.getWriteTime() > this.expireAfterWriteNanos;
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void connectAccessOrder(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        previous.setNextInAccessQueue(next);
        next.setPreviousInAccessQueue(previous);
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void nullifyAccessOrder(ReferenceEntry<K, V> nulled) {
        NullEntry nullEntry = NullEntry.INSTANCE;
        nulled.setNextInAccessQueue(nullEntry);
        nulled.setPreviousInAccessQueue(nullEntry);
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void connectWriteOrder(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        previous.setNextInWriteQueue(next);
        next.setPreviousInWriteQueue(previous);
    }

    @GuardedBy(value="Segment.this")
    static <K, V> void nullifyWriteOrder(ReferenceEntry<K, V> nulled) {
        NullEntry nullEntry = NullEntry.INSTANCE;
        nulled.setNextInWriteQueue(nullEntry);
        nulled.setPreviousInWriteQueue(nullEntry);
    }

    @Override
    public boolean isEmpty() {
        int i;
        long sum = 0L;
        Segment<K, V>[] segments = this.segments;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            sum += (long)segments[i].modCount;
        }
        if (sum != 0L) {
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count != 0) {
                    return false;
                }
                sum -= (long)segments[i].modCount;
            }
            if (sum != 0L) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        LocalCache localCache = this;
        Segment<K, V>[] segmentArray = localCache.segments;
        long l = 0L;
        for (int i = 0; i < segmentArray.length; ++i) {
            l += (long)segmentArray[i].count;
        }
        return ArrayFlags.saturatedCast(l);
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).get(key, hash);
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (key == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).containsKey(key, hash);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        long now = this.ticker.read();
        Segment<K, V>[] segments = this.segments;
        long last = -1L;
        for (int i = 0; i < 3; ++i) {
            long sum = 0L;
            Segment<K, V>[] arr$ = segments;
            int len$ = segments.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Segment segment = arr$[i$];
                int cfr_ignored_0 = segment.count;
                AtomicReferenceArray table = segment.table;
                for (int j = 0; j < table.length(); ++j) {
                    for (ReferenceEntry e = table.get(j); e != null; e = e.getNext()) {
                        V v = segment.getLiveValue(e, now);
                        if (v == null || !this.valueEquivalence.equivalent(value, v)) continue;
                        return true;
                    }
                }
                sum += (long)segment.modCount;
            }
            if (sum == last) break;
            last = sum;
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        CharMatcher.LookupTable.checkNotNull(key);
        CharMatcher.LookupTable.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(key, hash, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        CharMatcher.LookupTable.checkNotNull(key);
        CharMatcher.LookupTable.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(key, hash, value, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(key, hash);
    }

    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        if (key == null || value == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(key, hash, value);
    }

    @Override
    public boolean replace(K key, @Nullable V oldValue, V newValue) {
        CharMatcher.LookupTable.checkNotNull(key);
        CharMatcher.LookupTable.checkNotNull(newValue);
        if (oldValue == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(key, hash, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        CharMatcher.LookupTable.checkNotNull(key);
        CharMatcher.LookupTable.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(key, hash, value);
    }

    @Override
    public void clear() {
        Segment<K, V>[] arr$ = this.segments;
        int len$ = this.segments.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Segment segment;
            Segment segment2 = segment = arr$[i$];
            if (segment.count == 0) continue;
            segment2.lock();
            try {
                Segment segment3;
                int n;
                AtomicReferenceArray atomicReferenceArray = segment2.table;
                for (n = 0; n < atomicReferenceArray.length(); ++n) {
                    for (ReferenceEntry referenceEntry = atomicReferenceArray.get(n); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                        if (!referenceEntry.getValueReference().isActive()) continue;
                        segment2.enqueueNotification(referenceEntry, RemovalCause.EXPLICIT);
                    }
                }
                for (n = 0; n < atomicReferenceArray.length(); ++n) {
                    atomicReferenceArray.set(n, null);
                }
                Segment segment4 = segment2;
                if (segment4.map.usesKeyReferences()) {
                    segment3 = segment4;
                    while (segment3.keyReferenceQueue.poll() != null) {
                    }
                }
                if (segment4.map.usesValueReferences()) {
                    segment3 = segment4;
                    while (segment3.valueReferenceQueue.poll() != null) {
                    }
                }
                segment2.writeQueue.clear();
                segment2.accessQueue.clear();
                segment2.readCount.set(0);
                ++segment2.modCount;
                segment2.count = 0;
                continue;
            }
            finally {
                segment2.unlock();
                Segment segment5 = segment2;
                segment5.runUnlockedCleanup();
            }
        }
    }

    @Override
    public Set<K> keySet() {
        Set<K> ks = this.keySet;
        if (ks != null) {
            return ks;
        }
        this.keySet = new KeySet(this);
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        Collection<V> vs = this.values;
        if (vs != null) {
            return vs;
        }
        this.values = new Values(this);
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        if (es != null) {
            return es;
        }
        this.entrySet = new EntrySet(this);
        return this.entrySet;
    }

    static final class LocalLoadingCache<K, V>
    extends LocalManualCache<K, V>
    implements LoadingCache<K, V> {
        LocalLoadingCache(CacheBuilder<? super K, ? super V> builder, CacheLoader<? super K, V> loader) {
            super(new LocalCache<K, V>(builder, CharMatcher.LookupTable.checkNotNull(loader)), (byte)0);
        }

        @Override
        public final V getUnchecked(K key) {
            try {
                K k = key;
                LocalLoadingCache localLoadingCache = this;
                K k2 = k;
                LocalCache localCache = localLoadingCache.localCache;
                CacheLoader cacheLoader = localCache.defaultLoader;
                K k3 = k2;
                LocalCache localCache2 = localCache;
                int n = localCache.hash(CharMatcher.LookupTable.checkNotNull(k3));
                return localCache2.segmentFor(n).get(k3, n, cacheLoader);
            }
            catch (ExecutionException e) {
                throw new UncheckedExecutionException(e.getCause());
            }
        }

        public final V apply(K key) {
            return this.getUnchecked(key);
        }
    }

    static class LocalManualCache
    implements Serializable {
        final LocalCache<K, V> localCache;

        private LocalManualCache(LocalCache<K, V> localCache) {
            this.localCache = localCache;
        }

        /* synthetic */ LocalManualCache(LocalCache x0, byte by) {
            this(x0);
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private /* synthetic */ LocalCache this$0;

        EntrySet(LocalCache localCache) {
            this.this$0 = localCache;
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.this$0);
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = this.this$0.get(key);
            return v != null && this.this$0.valueEquivalence.equivalent(e.getValue(), v);
        }

        @Override
        public final boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            return key != null && this.this$0.remove(key, e.getValue());
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        private /* synthetic */ LocalCache this$0;

        Values(LocalCache localCache) {
            this.this$0 = localCache;
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(this.this$0);
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        @Override
        public final boolean contains(Object o) {
            return this.this$0.containsValue(o);
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        private /* synthetic */ LocalCache this$0;

        KeySet(LocalCache localCache) {
            this.this$0 = localCache;
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator(this.this$0);
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        @Override
        public final boolean contains(Object o) {
            return this.this$0.containsKey(o);
        }

        @Override
        public final boolean remove(Object o) {
            return this.this$0.remove(o) != null;
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(LocalCache localCache) {
            super(localCache);
        }
    }

    final class WriteThroughEntry
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        WriteThroughEntry(LocalCache localCache, K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final boolean equals(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)object;
                return this.key.equals(that.getKey()) && this.value.equals(that.getValue());
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public final V setValue(V newValue) {
            throw new UnsupportedOperationException();
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator(LocalCache localCache) {
            super(localCache);
        }

        @Override
        public final V next() {
            return this.nextEntry().getValue();
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator(LocalCache localCache) {
            super(localCache);
        }

        @Override
        public final K next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class HashIterator {
        private int nextSegmentIndex;
        private int nextTableIndex;
        private Segment<K, V> currentSegment;
        private AtomicReferenceArray<ReferenceEntry<K, V>> currentTable;
        private ReferenceEntry<K, V> nextEntry;
        private WriteThroughEntry nextExternal;
        private WriteThroughEntry lastReturned;
        private /* synthetic */ LocalCache this$0;

        HashIterator(LocalCache localCache) {
            this.this$0 = localCache;
            this.nextSegmentIndex = localCache.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        private void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                this.currentSegment = this.this$0.segments[this.nextSegmentIndex--];
                if (this.currentSegment.count == 0) continue;
                this.currentTable = this.currentSegment.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
                return;
            }
        }

        private boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    if (this.advanceTo(this.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        private boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable.get(this.nextTableIndex--)) == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        private boolean advanceTo(ReferenceEntry<K, V> entry) {
            try {
                Object value;
                Object v;
                long now = this.this$0.ticker.read();
                Object key = entry.getKey();
                long l = now;
                ReferenceEntry referenceEntry = entry;
                LocalCache localCache = this.this$0;
                if ((referenceEntry.getKey() == null ? null : ((v = referenceEntry.getValueReference().get()) == null ? null : (value = localCache.isExpired(referenceEntry, l) ? null : (Object)v))) != null) {
                    this.nextExternal = new WriteThroughEntry(this.this$0, key, value);
                    return true;
                }
                return false;
            }
            finally {
                this.currentSegment.postReadCleanup();
            }
        }

        public boolean hasNext() {
            return this.nextExternal != null;
        }

        final WriteThroughEntry nextEntry() {
            if (this.nextExternal == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextExternal;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            CharMatcher.LookupTable.checkState(this.lastReturned != null);
            this.this$0.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    static final class AccessQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head = new AbstractReferenceEntry<K, V>(this){
            private ReferenceEntry<K, V> nextAccess = this;
            private ReferenceEntry<K, V> previousAccess = this;

            @Override
            public final long getAccessTime() {
                return Long.MAX_VALUE;
            }

            @Override
            public final void setAccessTime(long time) {
            }

            @Override
            public final ReferenceEntry<K, V> getNextInAccessQueue() {
                return this.nextAccess;
            }

            @Override
            public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
                this.nextAccess = next;
            }

            @Override
            public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
                return this.previousAccess;
            }

            @Override
            public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
                this.previousAccess = previous;
            }
        };

        AccessQueue() {
        }

        @Override
        private ReferenceEntry<K, V> peek() {
            ReferenceEntry<K, V> next = this.head.getNextInAccessQueue();
            if (next == this.head) {
                return null;
            }
            return next;
        }

        @Override
        public final boolean remove(Object o) {
            ReferenceEntry e = (ReferenceEntry)o;
            ReferenceEntry previous = e.getPreviousInAccessQueue();
            ReferenceEntry next = e.getNextInAccessQueue();
            LocalCache.connectAccessOrder(previous, next);
            LocalCache.nullifyAccessOrder(e);
            return next != NullEntry.INSTANCE;
        }

        @Override
        public final boolean contains(Object o) {
            ReferenceEntry e = (ReferenceEntry)o;
            return e.getNextInAccessQueue() != NullEntry.INSTANCE;
        }

        @Override
        public final boolean isEmpty() {
            return this.head.getNextInAccessQueue() == this.head;
        }

        @Override
        public final int size() {
            int size = 0;
            for (ReferenceEntry<K, V> e = this.head.getNextInAccessQueue(); e != this.head; e = e.getNextInAccessQueue()) {
                ++size;
            }
            return size;
        }

        @Override
        public final void clear() {
            ReferenceEntry<K, V> e = this.head.getNextInAccessQueue();
            while (e != this.head) {
                ReferenceEntry<K, V> next = e.getNextInAccessQueue();
                LocalCache.nullifyAccessOrder(e);
                e = next;
            }
            this.head.setNextInAccessQueue(this.head);
            this.head.setPreviousInAccessQueue(this.head);
        }

        @Override
        public final Iterator<ReferenceEntry<K, V>> iterator() {
            return new AbstractSequentialIterator<ReferenceEntry<K, V>>(this, (ReferenceEntry)this.peek()){
                private /* synthetic */ AccessQueue this$0;
                {
                    this.this$0 = accessQueue;
                    super(x0);
                }
            };
        }
    }

    static final class WriteQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head = new AbstractReferenceEntry<K, V>(this){
            private ReferenceEntry<K, V> nextWrite = this;
            private ReferenceEntry<K, V> previousWrite = this;

            @Override
            public final long getWriteTime() {
                return Long.MAX_VALUE;
            }

            @Override
            public final void setWriteTime(long time) {
            }

            @Override
            public final ReferenceEntry<K, V> getNextInWriteQueue() {
                return this.nextWrite;
            }

            @Override
            public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
                this.nextWrite = next;
            }

            @Override
            public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
                return this.previousWrite;
            }

            @Override
            public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
                this.previousWrite = previous;
            }
        };

        WriteQueue() {
        }

        @Override
        private ReferenceEntry<K, V> peek() {
            ReferenceEntry<K, V> next = this.head.getNextInWriteQueue();
            if (next == this.head) {
                return null;
            }
            return next;
        }

        @Override
        public final boolean remove(Object o) {
            ReferenceEntry e = (ReferenceEntry)o;
            ReferenceEntry previous = e.getPreviousInWriteQueue();
            ReferenceEntry next = e.getNextInWriteQueue();
            LocalCache.connectWriteOrder(previous, next);
            LocalCache.nullifyWriteOrder(e);
            return next != NullEntry.INSTANCE;
        }

        @Override
        public final boolean contains(Object o) {
            ReferenceEntry e = (ReferenceEntry)o;
            return e.getNextInWriteQueue() != NullEntry.INSTANCE;
        }

        @Override
        public final boolean isEmpty() {
            return this.head.getNextInWriteQueue() == this.head;
        }

        @Override
        public final int size() {
            int size = 0;
            for (ReferenceEntry<K, V> e = this.head.getNextInWriteQueue(); e != this.head; e = e.getNextInWriteQueue()) {
                ++size;
            }
            return size;
        }

        @Override
        public final void clear() {
            ReferenceEntry<K, V> e = this.head.getNextInWriteQueue();
            while (e != this.head) {
                ReferenceEntry<K, V> next = e.getNextInWriteQueue();
                LocalCache.nullifyWriteOrder(e);
                e = next;
            }
            this.head.setNextInWriteQueue(this.head);
            this.head.setPreviousInWriteQueue(this.head);
        }

        @Override
        public final Iterator<ReferenceEntry<K, V>> iterator() {
            return new AbstractSequentialIterator<ReferenceEntry<K, V>>(this, (ReferenceEntry)this.peek()){
                private /* synthetic */ WriteQueue this$0;
                {
                    this.this$0 = writeQueue;
                    super(x0);
                }
            };
        }
    }

    static final class LoadingValueReference<K, V>
    implements ValueReference<K, V> {
        volatile ValueReference<K, V> oldValue;
        private SettableFuture<V> futureValue = SettableFuture.create();
        private Stopwatch stopwatch = new Stopwatch();

        public LoadingValueReference() {
            this(LocalCache.unset());
        }

        public LoadingValueReference(ValueReference<K, V> oldValue) {
            this.oldValue = oldValue;
        }

        @Override
        public final boolean isLoading() {
            return true;
        }

        @Override
        public final boolean isActive() {
            return this.oldValue.isActive();
        }

        @Override
        public final int getWeight() {
            return this.oldValue.getWeight();
        }

        public final boolean set(@Nullable V newValue) {
            return this.futureValue.set(newValue);
        }

        public final boolean setException(Throwable t) {
            return LoadingValueReference.setException(this.futureValue, t);
        }

        private static boolean setException(SettableFuture<?> future, Throwable t) {
            try {
                return future.setException(t);
            }
            catch (Error error) {
                return false;
            }
        }

        @Override
        public final void notifyNewValue(@Nullable V newValue) {
            if (newValue != null) {
                this.set(newValue);
                return;
            }
            this.oldValue = LocalCache.unset();
        }

        public final ListenableFuture<V> loadFuture(K key, CacheLoader<? super K, V> loader) {
            this.stopwatch.start();
            V previousValue = this.oldValue.get();
            try {
                if (previousValue == null) {
                    V newValue = loader.load(key);
                    if (this.set(newValue)) {
                        return this.futureValue;
                    }
                    return Futures.immediateFuture(newValue);
                }
                ListenableFuture<V> newValue = loader.reload(key, previousValue);
                if (newValue != null) {
                    return newValue;
                }
                return Futures.immediateFuture(null);
            }
            catch (Throwable throwable) {
                Throwable t = throwable;
                if (throwable instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (this.setException(t)) {
                    return this.futureValue;
                }
                Throwable throwable2 = t;
                SettableFuture settableFuture = SettableFuture.create();
                LoadingValueReference.setException(settableFuture, throwable2);
                return settableFuture;
            }
        }

        public final long elapsedNanos() {
            return this.stopwatch.elapsedTime(TimeUnit.NANOSECONDS);
        }

        @Override
        public final V waitForValue() throws ExecutionException {
            return ArrayFlags.getUninterruptibly(this.futureValue);
        }

        @Override
        public final V get() {
            return this.oldValue.get();
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, @Nullable V value, ReferenceEntry<K, V> entry) {
            return this;
        }
    }

    static final class Segment<K, V>
    extends ReentrantLock {
        final LocalCache<K, V> map;
        volatile int count;
        @GuardedBy(value="Segment.this")
        private int totalWeight;
        int modCount;
        private int threshold;
        volatile AtomicReferenceArray<ReferenceEntry<K, V>> table;
        private long maxSegmentWeight;
        final ReferenceQueue<K> keyReferenceQueue;
        final ReferenceQueue<V> valueReferenceQueue;
        private Queue<ReferenceEntry<K, V>> recencyQueue;
        final AtomicInteger readCount = new AtomicInteger();
        @GuardedBy(value="Segment.this")
        final Queue<ReferenceEntry<K, V>> writeQueue;
        @GuardedBy(value="Segment.this")
        final Queue<ReferenceEntry<K, V>> accessQueue;
        private AbstractCache$StatsCounter statsCounter;

        Segment(LocalCache<K, V> map, int initialCapacity, long maxSegmentWeight, AbstractCache$StatsCounter statsCounter) {
            this.map = map;
            this.maxSegmentWeight = maxSegmentWeight;
            this.statsCounter = statsCounter;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = Segment.newEntryArray(initialCapacity);
            Segment segment = this;
            this.threshold = atomicReferenceArray.length() * 3 / 4;
            if (!segment.map.customWeigher() && (long)segment.threshold == segment.maxSegmentWeight) {
                ++segment.threshold;
            }
            segment.table = atomicReferenceArray;
            this.keyReferenceQueue = map.usesKeyReferences() ? new ReferenceQueue() : null;
            this.valueReferenceQueue = map.usesValueReferences() ? new ReferenceQueue() : null;
            this.recencyQueue = map.usesAccessQueue() ? new ConcurrentLinkedQueue() : LocalCache.discardingQueue();
            LocalCache<K, V> localCache = map;
            this.writeQueue = localCache.expiresAfterWrite() ? new WriteQueue() : LocalCache.discardingQueue();
            this.accessQueue = map.usesAccessQueue() ? new AccessQueue() : LocalCache.discardingQueue();
        }

        private static AtomicReferenceArray<ReferenceEntry<K, V>> newEntryArray(int size) {
            return new AtomicReferenceArray(size);
        }

        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> newEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            return this.map.entryFactory.newEntry(this, key, hash, next);
        }

        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            if (original.getKey() == null) {
                return null;
            }
            ValueReference<K, V> valueReference = original.getValueReference();
            V value = valueReference.get();
            if (value == null && valueReference.isActive()) {
                return null;
            }
            ReferenceEntry<K, V> newEntry = this.map.entryFactory.copyEntry(this, original, newNext);
            newEntry.setValueReference(valueReference.copyFor(this.valueReferenceQueue, value, newEntry));
            return newEntry;
        }

        @GuardedBy(value="Segment.this")
        private void setValue(ReferenceEntry<K, V> entry, K key, V value, long now) {
            ValueReference<K, V> previous = entry.getValueReference();
            int weight = this.map.weigher.weigh(key, value);
            CharMatcher.LookupTable.checkState(weight >= 0, "Weights must be non-negative");
            ValueReference<K, V> valueReference = this.map.valueStrength.referenceValue(this, entry, value, weight);
            entry.setValueReference(valueReference);
            long l = now;
            int n = weight;
            ReferenceEntry<K, V> referenceEntry = entry;
            Segment segment = this;
            segment.drainRecencyQueue();
            segment.totalWeight += n;
            LocalCache<K, V> localCache = segment.map;
            if (localCache.expiresAfterAccess()) {
                referenceEntry.setAccessTime(l);
            }
            if (segment.map.recordsWrite()) {
                referenceEntry.setWriteTime(l);
            }
            segment.accessQueue.add(referenceEntry);
            segment.writeQueue.add(referenceEntry);
            previous.notifyNewValue(value);
        }

        final V get(K key, int hash, CacheLoader<? super K, V> loader) throws ExecutionException {
            try {
                ReferenceEntry<K, V> e;
                if (this.count != 0 && (e = this.getEntry(key, hash)) != null) {
                    long now = this.map.ticker.read();
                    V value = this.getLiveValue(e, now);
                    if (value != null) {
                        this.recordRead(e, now);
                        this.statsCounter.recordHits(1);
                        V v = this.scheduleRefresh(e, key, hash, value, now, loader);
                        return v;
                    }
                    ValueReference<K, V> valueReference = e.getValueReference();
                    if (valueReference.isLoading()) {
                        V v = this.waitForLoadingValue(e, key, valueReference);
                        return v;
                    }
                }
                e = this.lockedGetOrLoad(key, hash, loader);
                return (V)e;
            }
            catch (ExecutionException executionException) {
                ExecutionException ee = executionException;
                Throwable cause = executionException.getCause();
                if (cause instanceof Error) {
                    throw new ExecutionError((Error)cause);
                }
                if (cause instanceof RuntimeException) {
                    throw new UncheckedExecutionException(cause);
                }
                throw ee;
            }
            finally {
                this.postReadCleanup();
            }
        }

        private V lockedGetOrLoad(K key, int hash, CacheLoader<? super K, V> loader) throws ExecutionException {
            ReferenceEntry e;
            Segment segment;
            ValueReference<K, V> valueReference = null;
            LoadingValueReference<? super K, V> loadingValueReference = null;
            boolean createNewEntry = true;
            this.lock();
            try {
                ReferenceEntry first;
                long now;
                long l = now = this.map.ticker.read();
                segment = this;
                segment.runLockedCleanup(l);
                int newCount = this.count - 1;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    valueReference = e.getValueReference();
                    if (valueReference.isLoading()) {
                        createNewEntry = false;
                        break;
                    }
                    V value = valueReference.get();
                    if (value == null) {
                        this.enqueueNotification$2a26c7c4(entryKey, valueReference, RemovalCause.COLLECTED);
                    } else if (this.map.isExpired(e, now)) {
                        this.enqueueNotification$2a26c7c4(entryKey, valueReference, RemovalCause.EXPIRED);
                    } else {
                        this.recordLockedRead(e, now);
                        this.statsCounter.recordHits(1);
                        V v = value;
                        return v;
                    }
                    this.writeQueue.remove(e);
                    this.accessQueue.remove(e);
                    this.count = newCount;
                    break;
                }
                if (createNewEntry) {
                    loadingValueReference = new LoadingValueReference<K, V>();
                    if (e == null) {
                        e = this.newEntry(key, hash, first);
                        e.setValueReference(loadingValueReference);
                        table.set(index, e);
                    } else {
                        e.setValueReference(loadingValueReference);
                    }
                }
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
            if (createNewEntry) {
                try {
                    ReferenceEntry referenceEntry = e;
                    synchronized (referenceEntry) {
                        CacheLoader<? super K, V> cacheLoader = loader;
                        LoadingValueReference<? super K, V> loadingValueReference2 = loadingValueReference;
                        int n = hash;
                        K k = key;
                        Segment segment2 = this;
                        ListenableFuture listenableFuture = loadingValueReference2.loadFuture((K)k, cacheLoader);
                        Object v = segment2.getAndRecordStats(k, n, loadingValueReference2, listenableFuture);
                        return v;
                    }
                }
                finally {
                    this.statsCounter.recordMisses(1);
                }
            }
            return this.waitForLoadingValue(e, key, valueReference);
        }

        private V waitForLoadingValue(ReferenceEntry<K, V> e, K key, ValueReference<K, V> valueReference) throws ExecutionException {
            if (!valueReference.isLoading()) {
                throw new AssertionError();
            }
            CharMatcher.LookupTable.checkState(!Thread.holdsLock(e), "Recursive load");
            try {
                V value = valueReference.waitForValue();
                if (value == null) {
                    throw new UncheckedExecutionException("CacheLoader returned null for key " + key + ".");
                }
                long now = this.map.ticker.read();
                this.recordRead(e, now);
                V v = value;
                return v;
            }
            finally {
                this.statsCounter.recordMisses(1);
            }
        }

        final V getAndRecordStats(K key, int hash, LoadingValueReference<K, V> loadingValueReference, ListenableFuture<V> newValue) throws ExecutionException {
            V value = null;
            try {
                V v = ArrayFlags.getUninterruptibly(newValue);
                value = v;
                if (v == null) {
                    throw new UncheckedExecutionException("CacheLoader returned null for key " + key + ".");
                }
                this.statsCounter.recordLoadSuccess(loadingValueReference.elapsedNanos());
                this.storeLoadedValue(key, hash, loadingValueReference, value);
                V v2 = value;
                return v2;
            }
            finally {
                if (value == null) {
                    this.statsCounter.recordLoadException(loadingValueReference.elapsedNanos());
                    this.removeLoadingValue(key, hash, loadingValueReference);
                }
            }
        }

        private V scheduleRefresh(ReferenceEntry<K, V> entry, K key, int hash, V oldValue, long now, CacheLoader<? super K, V> loader) {
            V newValue;
            if (this.map.refreshes() && now - entry.getWriteTime() > this.map.refreshNanos && (newValue = this.refresh(key, hash, loader)) != null) {
                return newValue;
            }
            return oldValue;
        }

        @Nullable
        private V refresh(K key, int hash, CacheLoader<? super K, V> loader) {
            LoadingValueReference<? super K, V> loadingValueReference = this.insertLoadingValueReference(key, hash);
            if (loadingValueReference == null) {
                return null;
            }
            CacheLoader<? super K, V> cacheLoader = loader;
            LoadingValueReference<? super K, V> loadingValueReference2 = loadingValueReference;
            int n = hash;
            K k = key;
            Segment segment = this;
            ListenableFuture<V> listenableFuture = loadingValueReference2.loadFuture((K)k, cacheLoader);
            listenableFuture.addListener(new Runnable(segment, k, n, loadingValueReference2, listenableFuture){
                private /* synthetic */ Object val$key;
                private /* synthetic */ int val$hash;
                private /* synthetic */ LoadingValueReference val$loadingValueReference;
                private /* synthetic */ ListenableFuture val$loadingFuture;
                private /* synthetic */ Segment this$0;
                {
                    this.this$0 = segment;
                    this.val$key = object;
                    this.val$hash = n;
                    this.val$loadingValueReference = loadingValueReference;
                    this.val$loadingFuture = listenableFuture;
                }

                @Override
                public final void run() {
                    try {
                        Object newValue = this.this$0.getAndRecordStats(this.val$key, this.val$hash, this.val$loadingValueReference, this.val$loadingFuture);
                        this.val$loadingValueReference.set(newValue);
                        return;
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "Exception thrown during refresh", t);
                        this.val$loadingValueReference.setException(t);
                        return;
                    }
                }
            }, sameThreadExecutor);
            ListenableFuture<V> result = listenableFuture;
            if (result.isDone()) {
                try {
                    return ArrayFlags.getUninterruptibly(result);
                }
                catch (Throwable throwable) {}
            }
            return null;
        }

        @Nullable
        private LoadingValueReference<K, V> insertLoadingValueReference(K key, int hash) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                ReferenceEntry<K, V> e;
                long now;
                long l = now = this.map.ticker.read();
                segment = this;
                segment.runLockedCleanup(l);
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    if (valueReference.isLoading()) {
                        return null;
                    }
                    ++this.modCount;
                    LoadingValueReference<K, V> loadingValueReference = new LoadingValueReference<K, V>(valueReference);
                    e.setValueReference(loadingValueReference);
                    LoadingValueReference<K, V> loadingValueReference2 = loadingValueReference;
                    return loadingValueReference2;
                }
                ++this.modCount;
                LoadingValueReference loadingValueReference = new LoadingValueReference();
                e = this.newEntry(key, hash, first);
                e.setValueReference(loadingValueReference);
                table.set(index, e);
                LoadingValueReference loadingValueReference3 = loadingValueReference;
                return loadingValueReference3;
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
        }

        private void tryDrainReferenceQueues() {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        @GuardedBy(value="Segment.this")
        private void drainReferenceQueues() {
            LocalCache<K, V> localCache;
            Object object;
            Object object2;
            Reference<Object> reference;
            int n;
            Segment segment;
            if (this.map.usesKeyReferences()) {
                segment = this;
                n = 0;
                while ((reference = segment.keyReferenceQueue.poll()) != null) {
                    object = object2 = (ReferenceEntry)((Object)reference);
                    localCache = segment.map;
                    int n2 = object.getHash();
                    localCache.segmentFor(n2).reclaimKey((ReferenceEntry<K, V>)object, n2);
                    if (++n != 16) continue;
                }
            }
            if (this.map.usesValueReferences()) {
                segment = this;
                n = 0;
                while ((reference = segment.valueReferenceQueue.poll()) != null) {
                    object = object2 = (ValueReference)((Object)reference);
                    localCache = segment.map;
                    ReferenceEntry referenceEntry = object.getEntry();
                    int n3 = referenceEntry.getHash();
                    localCache.segmentFor(n3).reclaimValue((K)referenceEntry.getKey(), n3, (ValueReference<K, V>)object);
                    if (++n != 16) continue;
                }
            }
        }

        private void recordRead(ReferenceEntry<K, V> entry, long now) {
            LocalCache<K, V> localCache = this.map;
            if (localCache.expiresAfterAccess()) {
                entry.setAccessTime(now);
            }
            this.recencyQueue.add(entry);
        }

        @GuardedBy(value="Segment.this")
        private void recordLockedRead(ReferenceEntry<K, V> entry, long now) {
            LocalCache<K, V> localCache = this.map;
            if (localCache.expiresAfterAccess()) {
                entry.setAccessTime(now);
            }
            this.accessQueue.add(entry);
        }

        @GuardedBy(value="Segment.this")
        private void drainRecencyQueue() {
            ReferenceEntry<K, V> e;
            while ((e = this.recencyQueue.poll()) != null) {
                if (!this.accessQueue.contains(e)) continue;
                this.accessQueue.add(e);
            }
        }

        private void tryExpireEntries(long now) {
            if (this.tryLock()) {
                try {
                    this.expireEntries(now);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        @GuardedBy(value="Segment.this")
        private void expireEntries(long now) {
            ReferenceEntry<K, V> e;
            this.drainRecencyQueue();
            while ((e = this.writeQueue.peek()) != null && this.map.isExpired(e, now)) {
                if (!this.removeEntry(e, e.getHash(), RemovalCause.EXPIRED)) {
                    throw new AssertionError();
                }
            }
            while ((e = this.accessQueue.peek()) != null && this.map.isExpired(e, now)) {
                if (!this.removeEntry(e, e.getHash(), RemovalCause.EXPIRED)) {
                    throw new AssertionError();
                }
            }
        }

        @GuardedBy(value="Segment.this")
        final void enqueueNotification(ReferenceEntry<K, V> entry, RemovalCause cause) {
            K k = entry.getKey();
            entry.getHash();
            this.enqueueNotification$2a26c7c4(k, entry.getValueReference(), cause);
        }

        @GuardedBy(value="Segment.this")
        private void enqueueNotification$2a26c7c4(@Nullable K key, ValueReference<K, V> valueReference, RemovalCause cause) {
            this.totalWeight -= valueReference.getWeight();
            if (cause.wasEvicted()) {
                this.statsCounter.recordEviction();
            }
            if (this.map.removalNotificationQueue != DISCARDING_QUEUE) {
                V value = valueReference.get();
                RemovalNotification<K, V> notification = new RemovalNotification<K, V>(key, value, cause);
                this.map.removalNotificationQueue.offer(notification);
            }
        }

        @GuardedBy(value="Segment.this")
        private void evictEntries() {
            if (!this.map.evictsBySize()) {
                return;
            }
            this.drainRecencyQueue();
            while ((long)this.totalWeight > this.maxSegmentWeight) {
                ReferenceEntry referenceEntry22;
                block4: {
                    Segment segment = this;
                    for (ReferenceEntry referenceEntry22 : segment.accessQueue) {
                        int n = referenceEntry22.getValueReference().getWeight();
                        if (n <= 0) continue;
                        break block4;
                    }
                    throw new AssertionError();
                }
                ReferenceEntry e = referenceEntry22;
                if (!this.removeEntry(e, e.getHash(), RemovalCause.SIZE)) {
                    throw new AssertionError();
                }
            }
        }

        @Nullable
        private ReferenceEntry<K, V> getEntry(Object key, int hash) {
            int n = hash;
            Segment segment = this;
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = segment.table;
            for (ReferenceEntry<K, V> e = atomicReferenceArray.get(n & atomicReferenceArray.length() - 1); e != null; e = e.getNext()) {
                if (e.getHash() != hash) continue;
                K entryKey = e.getKey();
                if (entryKey == null) {
                    this.tryDrainReferenceQueues();
                    continue;
                }
                if (!this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                return e;
            }
            return null;
        }

        @Nullable
        private ReferenceEntry<K, V> getLiveEntry(Object key, int hash, long now) {
            ReferenceEntry<K, V> e = this.getEntry(key, hash);
            if (e == null) {
                return null;
            }
            if (this.map.isExpired(e, now)) {
                this.tryExpireEntries(now);
                return null;
            }
            return e;
        }

        final V getLiveValue(ReferenceEntry<K, V> entry, long now) {
            if (entry.getKey() == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            V value = entry.getValueReference().get();
            if (value == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            if (this.map.isExpired(entry, now)) {
                this.tryExpireEntries(now);
                return null;
            }
            return value;
        }

        @Nullable
        final V get(Object key, int hash) {
            try {
                if (this.count != 0) {
                    long now = this.map.ticker.read();
                    ReferenceEntry<K, V> e = this.getLiveEntry(key, hash, now);
                    if (e == null) {
                        return null;
                    }
                    V value = e.getValueReference().get();
                    if (value != null) {
                        this.recordRead(e, now);
                        V v = this.scheduleRefresh(e, e.getKey(), hash, value, now, this.map.defaultLoader);
                        return v;
                    }
                    this.tryDrainReferenceQueues();
                }
                return null;
            }
            finally {
                this.postReadCleanup();
            }
        }

        final boolean containsKey(Object key, int hash) {
            try {
                if (this.count != 0) {
                    long now = this.map.ticker.read();
                    ReferenceEntry<K, V> e = this.getLiveEntry(key, hash, now);
                    if (e == null) {
                        return false;
                    }
                    boolean bl = e.getValueReference().get() != null;
                    return bl;
                }
                return false;
            }
            finally {
                this.postReadCleanup();
            }
        }

        @Nullable
        final V put(K key, int hash, V value, boolean onlyIfAbsent) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                long now;
                long l = now = this.map.ticker.read();
                segment = this;
                segment.runLockedCleanup(l);
                int newCount = this.count + 1;
                if (newCount > this.threshold) {
                    this.expand();
                }
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        ++this.modCount;
                        if (valueReference.isActive()) {
                            this.enqueueNotification$2a26c7c4(key, valueReference, RemovalCause.COLLECTED);
                            this.setValue(e, key, value, now);
                            newCount = this.count;
                        } else {
                            this.setValue(e, key, value, now);
                            newCount = this.count + 1;
                        }
                        this.count = newCount;
                        this.evictEntries();
                        return null;
                    }
                    if (onlyIfAbsent) {
                        this.recordLockedRead(e, now);
                        V v = entryValue;
                        return v;
                    }
                    ++this.modCount;
                    this.enqueueNotification$2a26c7c4(key, valueReference, RemovalCause.REPLACED);
                    this.setValue(e, key, value, now);
                    this.evictEntries();
                    V v = entryValue;
                    return v;
                }
                ++this.modCount;
                ReferenceEntry<K, V> newEntry = this.newEntry(key, hash, first);
                this.setValue(newEntry, key, value, now);
                table.set(index, newEntry);
                this.count = newCount = this.count + 1;
                this.evictEntries();
                return null;
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
        }

        @GuardedBy(value="Segment.this")
        private void expand() {
            AtomicReferenceArray<ReferenceEntry<K, V>> oldTable = this.table;
            int oldCapacity = oldTable.length();
            if (oldCapacity >= 0x40000000) {
                return;
            }
            int newCount = this.count;
            AtomicReferenceArray<ReferenceEntry<K, V>> newTable = Segment.newEntryArray(oldCapacity << 1);
            this.threshold = newTable.length() * 3 / 4;
            int newMask = newTable.length() - 1;
            for (int oldIndex = 0; oldIndex < oldCapacity; ++oldIndex) {
                int newIndex;
                ReferenceEntry<K, V> e;
                ReferenceEntry<K, V> head = oldTable.get(oldIndex);
                if (head == null) continue;
                ReferenceEntry<K, V> next = head.getNext();
                int headIndex = head.getHash() & newMask;
                if (next == null) {
                    newTable.set(headIndex, head);
                    continue;
                }
                ReferenceEntry<K, V> tail = head;
                int tailIndex = headIndex;
                for (e = next; e != null; e = e.getNext()) {
                    newIndex = e.getHash() & newMask;
                    if (newIndex == tailIndex) continue;
                    tailIndex = newIndex;
                    tail = e;
                }
                newTable.set(tailIndex, tail);
                for (e = head; e != tail; e = e.getNext()) {
                    newIndex = e.getHash() & newMask;
                    ReferenceEntry<K, V> newNext = newTable.get(newIndex);
                    ReferenceEntry<K, V> newFirst = this.copyEntry(e, newNext);
                    if (newFirst != null) {
                        newTable.set(newIndex, newFirst);
                        continue;
                    }
                    this.removeCollectedEntry(e);
                    --newCount;
                }
            }
            this.table = newTable;
            this.count = newCount;
        }

        final boolean replace(K key, int hash, V oldValue, V newValue) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                long now;
                long l = now = this.map.ticker.read();
                segment = this;
                segment.runLockedCleanup(l);
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        if (valueReference.isActive()) {
                            ++this.modCount;
                            ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, valueReference, RemovalCause.COLLECTED);
                            int newCount = this.count - 1;
                            table.set(index, newFirst);
                            this.count = newCount;
                        }
                        return false;
                    }
                    if (this.map.valueEquivalence.equivalent(oldValue, entryValue)) {
                        ++this.modCount;
                        this.enqueueNotification$2a26c7c4(key, valueReference, RemovalCause.REPLACED);
                        this.setValue(e, key, newValue, now);
                        this.evictEntries();
                        return true;
                    }
                    this.recordLockedRead(e, now);
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
        }

        @Nullable
        final V replace(K key, int hash, V newValue) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                long now;
                long l = now = this.map.ticker.read();
                segment = this;
                segment.runLockedCleanup(l);
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        if (valueReference.isActive()) {
                            ++this.modCount;
                            ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, valueReference, RemovalCause.COLLECTED);
                            int newCount = this.count - 1;
                            table.set(index, newFirst);
                            this.count = newCount;
                        }
                        return null;
                    }
                    ++this.modCount;
                    this.enqueueNotification$2a26c7c4(key, valueReference, RemovalCause.REPLACED);
                    this.setValue(e, key, newValue, now);
                    this.evictEntries();
                    V v = entryValue;
                    return v;
                }
                return null;
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
        }

        @Nullable
        final V remove(Object key, int hash) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                long now;
                long l = now = this.map.ticker.read();
                segment = this;
                segment.runLockedCleanup(l);
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    RemovalCause cause;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue != null) {
                        cause = RemovalCause.EXPLICIT;
                    } else if (valueReference.isActive()) {
                        cause = RemovalCause.COLLECTED;
                    } else {
                        return null;
                    }
                    ++this.modCount;
                    ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, valueReference, cause);
                    int newCount = this.count - 1;
                    table.set(index, newFirst);
                    this.count = newCount;
                    V v = entryValue;
                    return v;
                }
                return null;
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
        }

        private boolean storeLoadedValue(K key, int hash, LoadingValueReference<K, V> oldValueReference, V newValue) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                long now;
                long l = now = this.map.ticker.read();
                segment = this;
                segment.runLockedCleanup(l);
                int newCount = this.count + 1;
                if (newCount > this.threshold) {
                    this.expand();
                    newCount = this.count + 1;
                }
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (oldValueReference == valueReference || entryValue == null && valueReference != UNSET) {
                        ++this.modCount;
                        if (oldValueReference.isActive()) {
                            RemovalCause cause = entryValue == null ? RemovalCause.COLLECTED : RemovalCause.REPLACED;
                            this.enqueueNotification$2a26c7c4(key, oldValueReference, cause);
                            --newCount;
                        }
                        this.setValue(e, key, newValue, now);
                        this.count = newCount;
                        this.evictEntries();
                        return true;
                    }
                    valueReference = new WeightedStrongValueReference(newValue, 0);
                    this.enqueueNotification$2a26c7c4(key, valueReference, RemovalCause.REPLACED);
                    return false;
                }
                ++this.modCount;
                ReferenceEntry<K, V> newEntry = this.newEntry(key, hash, first);
                this.setValue(newEntry, key, newValue, now);
                table.set(index, newEntry);
                this.count = newCount;
                this.evictEntries();
                return true;
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
        }

        final boolean remove(Object key, int hash, Object value) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                long now;
                long l = now = this.map.ticker.read();
                segment = this;
                segment.runLockedCleanup(l);
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    RemovalCause cause;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (this.map.valueEquivalence.equivalent(value, entryValue)) {
                        cause = RemovalCause.EXPLICIT;
                    } else if (entryValue == null && valueReference.isActive()) {
                        cause = RemovalCause.COLLECTED;
                    } else {
                        return false;
                    }
                    ++this.modCount;
                    ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, valueReference, cause);
                    int newCount = this.count - 1;
                    table.set(index, newFirst);
                    this.count = newCount;
                    boolean bl = cause == RemovalCause.EXPLICIT;
                    return bl;
                }
                return false;
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
        }

        @Nullable
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> removeValueFromChain(ReferenceEntry<K, V> first, ReferenceEntry<K, V> entry, @Nullable K key, int hash, ValueReference<K, V> valueReference, RemovalCause cause) {
            this.enqueueNotification$2a26c7c4(key, valueReference, cause);
            this.writeQueue.remove(entry);
            this.accessQueue.remove(entry);
            if (valueReference.isLoading()) {
                valueReference.notifyNewValue(null);
                return first;
            }
            return this.removeEntryFromChain(first, entry);
        }

        @Nullable
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> removeEntryFromChain(ReferenceEntry<K, V> first, ReferenceEntry<K, V> entry) {
            int newCount = this.count;
            ReferenceEntry<K, V> newFirst = entry.getNext();
            for (ReferenceEntry<K, V> e = first; e != entry; e = e.getNext()) {
                ReferenceEntry<K, V> next = this.copyEntry(e, newFirst);
                if (next != null) {
                    newFirst = next;
                    continue;
                }
                this.removeCollectedEntry(e);
                --newCount;
            }
            this.count = newCount;
            return newFirst;
        }

        @GuardedBy(value="Segment.this")
        private void removeCollectedEntry(ReferenceEntry<K, V> entry) {
            this.enqueueNotification(entry, RemovalCause.COLLECTED);
            this.writeQueue.remove(entry);
            this.accessQueue.remove(entry);
        }

        final boolean reclaimKey(ReferenceEntry<K, V> entry, int hash) {
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    if (e != entry) continue;
                    ++this.modCount;
                    ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, e.getKey(), hash, e.getValueReference(), RemovalCause.COLLECTED);
                    int newCount = this.count - 1;
                    table.set(index, newFirst);
                    this.count = newCount;
                    return true;
                }
                return false;
            }
            finally {
                this.unlock();
                Segment segment = this;
                segment.runUnlockedCleanup();
            }
        }

        final boolean reclaimValue(K key, int hash, ValueReference<K, V> valueReference) {
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> v = e.getValueReference();
                    if (v == valueReference) {
                        ++this.modCount;
                        ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, valueReference, RemovalCause.COLLECTED);
                        int newCount = this.count - 1;
                        table.set(index, newFirst);
                        this.count = newCount;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                if (!this.isHeldByCurrentThread()) {
                    Segment segment = this;
                    segment.runUnlockedCleanup();
                }
            }
        }

        private boolean removeLoadingValue(K key, int hash, LoadingValueReference<K, V> valueReference) {
            this.lock();
            try {
                ReferenceEntry first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> v = e.getValueReference();
                    if (v == valueReference) {
                        if (valueReference.isActive()) {
                            LoadingValueReference<K, V> loadingValueReference = valueReference;
                            e.setValueReference(loadingValueReference.oldValue);
                        } else {
                            ReferenceEntry<K, V> newFirst = this.removeEntryFromChain(first, e);
                            table.set(index, newFirst);
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                Segment segment = this;
                segment.runUnlockedCleanup();
            }
        }

        @GuardedBy(value="Segment.this")
        private boolean removeEntry(ReferenceEntry<K, V> entry, int hash, RemovalCause cause) {
            ReferenceEntry<K, V> first;
            AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
            int index = hash & table.length() - 1;
            for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                if (e != entry) continue;
                ++this.modCount;
                ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, e.getKey(), hash, e.getValueReference(), cause);
                int newCount = this.count - 1;
                table.set(index, newFirst);
                this.count = newCount;
                return true;
            }
            return false;
        }

        final void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                Segment segment = this;
                long l = segment.map.ticker.read();
                segment.runLockedCleanup(l);
                segment.runUnlockedCleanup();
            }
        }

        private void runLockedCleanup(long now) {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    this.expireEntries(now);
                    this.readCount.set(0);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        final void runUnlockedCleanup() {
            if (!this.isHeldByCurrentThread()) {
                LocalCache<K, V> localCache = this.map;
                while (localCache.removalNotificationQueue.poll() != null) {
                    try {
                        RemovalListener cfr_ignored_0 = localCache.removalListener;
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.WARNING, "Exception thrown by removal listener", throwable);
                    }
                }
            }
        }
    }

    static final class WeightedStrongValueReference<K, V>
    extends StrongValueReference<K, V> {
        private int weight;

        WeightedStrongValueReference(V referent, int weight) {
            super(referent);
            this.weight = weight;
        }

        @Override
        public final int getWeight() {
            return this.weight;
        }
    }

    static final class WeightedSoftValueReference<K, V>
    extends SoftValueReference<K, V> {
        private int weight;

        WeightedSoftValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry, int weight) {
            super(queue, referent, entry);
            this.weight = weight;
        }

        @Override
        public final int getWeight() {
            return this.weight;
        }

        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            return new WeightedSoftValueReference<K, V>(queue, value, entry, this.weight);
        }
    }

    static final class WeightedWeakValueReference<K, V>
    extends WeakValueReference<K, V> {
        private int weight;

        WeightedWeakValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry, int weight) {
            super(queue, referent, entry);
            this.weight = weight;
        }

        @Override
        public final int getWeight() {
            return this.weight;
        }

        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            return new WeightedWeakValueReference<K, V>(queue, value, entry, this.weight);
        }
    }

    static class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        private V referent;

        StrongValueReference(V referent) {
            this.referent = referent;
        }

        @Override
        public V get() {
            return this.referent;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public final boolean isLoading() {
            return false;
        }

        @Override
        public final boolean isActive() {
            return true;
        }

        @Override
        public final V waitForValue() {
            return this.get();
        }

        @Override
        public final void notifyNewValue(V newValue) {
        }
    }

    static class SoftValueReference<K, V>
    extends SoftReference<V>
    implements ValueReference<K, V> {
        private ReferenceEntry<K, V> entry;

        SoftValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry) {
            super(referent, queue);
            this.entry = entry;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public final void notifyNewValue(V newValue) {
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            return new SoftValueReference<K, V>(queue, value, entry);
        }

        @Override
        public final boolean isLoading() {
            return false;
        }

        @Override
        public final boolean isActive() {
            return true;
        }

        @Override
        public final V waitForValue() {
            return (V)this.get();
        }
    }

    static class WeakValueReference<K, V>
    extends WeakReference<V>
    implements ValueReference<K, V> {
        private ReferenceEntry<K, V> entry;

        WeakValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry) {
            super(referent, queue);
            this.entry = entry;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public final void notifyNewValue(V newValue) {
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            return new WeakValueReference<K, V>(queue, value, entry);
        }

        @Override
        public final boolean isLoading() {
            return false;
        }

        @Override
        public final boolean isActive() {
            return true;
        }

        @Override
        public final V waitForValue() {
            return (V)this.get();
        }
    }

    static final class WeakAccessWriteEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long accessTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();
        private volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        WeakAccessWriteEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public final void setAccessTime(long time) {
            this.accessTime = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            this.nextAccess = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            this.previousAccess = previous;
        }

        @Override
        public final long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public final void setWriteTime(long time) {
            this.writeTime = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            this.nextWrite = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            this.previousWrite = previous;
        }
    }

    static final class WeakWriteEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        WeakWriteEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public final long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public final void setWriteTime(long time) {
            this.writeTime = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            this.nextWrite = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            this.previousWrite = previous;
        }
    }

    static final class WeakAccessEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long accessTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();

        WeakAccessEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(queue, key, hash, next);
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public final void setAccessTime(long time) {
            this.accessTime = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            this.nextAccess = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            this.previousAccess = previous;
        }
    }

    static class WeakEntry<K, V>
    extends WeakReference<K>
    implements ReferenceEntry<K, V> {
        private int hash;
        private ReferenceEntry<K, V> next;
        private volatile ValueReference<K, V> valueReference = LocalCache.unset();

        WeakEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, queue);
            this.hash = hash;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return (K)this.get();
        }

        @Override
        public long getAccessTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAccessTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getWriteTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWriteTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public final void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public final int getHash() {
            return this.hash;
        }

        @Override
        public final ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static final class StrongAccessWriteEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long accessTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();
        private volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        StrongAccessWriteEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, hash, next);
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public final void setAccessTime(long time) {
            this.accessTime = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            this.nextAccess = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            this.previousAccess = previous;
        }

        @Override
        public final long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public final void setWriteTime(long time) {
            this.writeTime = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            this.nextWrite = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            this.previousWrite = previous;
        }
    }

    static final class StrongWriteEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        StrongWriteEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, hash, next);
        }

        @Override
        public final long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public final void setWriteTime(long time) {
            this.writeTime = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        @Override
        public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            this.nextWrite = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            this.previousWrite = previous;
        }
    }

    static final class StrongAccessEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long accessTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();

        StrongAccessEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(key, hash, next);
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }

        @Override
        public final void setAccessTime(long time) {
            this.accessTime = time;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        @Override
        public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            this.nextAccess = next;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            this.previousAccess = previous;
        }
    }

    static class StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        private K key;
        private int hash;
        private ReferenceEntry<K, V> next;
        private volatile ValueReference<K, V> valueReference = LocalCache.unset();

        StrongEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            this.key = key;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public long getAccessTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAccessTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getWriteTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWriteTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public final void setValueReference(ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        @Override
        public final int getHash() {
            return this.hash;
        }

        @Override
        public final ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static abstract class AbstractReferenceEntry<K, V>
    implements ReferenceEntry<K, V> {
        AbstractReferenceEntry() {
        }

        @Override
        public final ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValueReference(ValueReference<K, V> valueReference) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ReferenceEntry<K, V> getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final K getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getAccessTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAccessTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getWriteTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWriteTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }
    }

    static final class NullEntry
    extends Enum<NullEntry>
    implements ReferenceEntry<Object, Object> {
        public static final /* enum */ NullEntry INSTANCE;

        @Override
        public final ValueReference<Object, Object> getValueReference() {
            return null;
        }

        @Override
        public final void setValueReference(ValueReference<Object, Object> valueReference) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNext() {
            return null;
        }

        @Override
        public final int getHash() {
            return 0;
        }

        @Override
        public final Object getKey() {
            return null;
        }

        @Override
        public final long getAccessTime() {
            return 0L;
        }

        @Override
        public final void setAccessTime(long time) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNextInAccessQueue() {
            return this;
        }

        @Override
        public final void setNextInAccessQueue(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getPreviousInAccessQueue() {
            return this;
        }

        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<Object, Object> previous) {
        }

        @Override
        public final long getWriteTime() {
            return 0L;
        }

        @Override
        public final void setWriteTime(long time) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNextInWriteQueue() {
            return this;
        }

        @Override
        public final void setNextInWriteQueue(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getPreviousInWriteQueue() {
            return this;
        }

        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<Object, Object> previous) {
        }

        static {
            (new NullEntry[1])[0] = INSTANCE = new NullEntry();
        }
    }

    static interface ReferenceEntry<K, V> {
        public ValueReference<K, V> getValueReference();

        public void setValueReference(ValueReference<K, V> var1);

        @Nullable
        public ReferenceEntry<K, V> getNext();

        public int getHash();

        @Nullable
        public K getKey();

        public long getAccessTime();

        public void setAccessTime(long var1);

        public ReferenceEntry<K, V> getNextInAccessQueue();

        public void setNextInAccessQueue(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousInAccessQueue();

        public void setPreviousInAccessQueue(ReferenceEntry<K, V> var1);

        public long getWriteTime();

        public void setWriteTime(long var1);

        public ReferenceEntry<K, V> getNextInWriteQueue();

        public void setNextInWriteQueue(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousInWriteQueue();

        public void setPreviousInWriteQueue(ReferenceEntry<K, V> var1);
    }

    static interface ValueReference<K, V> {
        @Nullable
        public V get();

        public V waitForValue() throws ExecutionException;

        public int getWeight();

        @Nullable
        public ReferenceEntry<K, V> getEntry();

        public ValueReference<K, V> copyFor(ReferenceQueue<V> var1, @Nullable V var2, ReferenceEntry<K, V> var3);

        public void notifyNewValue(@Nullable V var1);

        public boolean isLoading();

        public boolean isActive();
    }

    static abstract class EntryFactory
    extends Enum<EntryFactory> {
        private static /* enum */ EntryFactory STRONG = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongEntry<K, V>(key, hash, next);
            }
        };
        private static /* enum */ EntryFactory STRONG_ACCESS = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongAccessEntry<K, V>(key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                2.copyAccessEntry(original, newEntry);
                return newEntry;
            }
        };
        private static /* enum */ EntryFactory STRONG_WRITE = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongWriteEntry<K, V>(key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                3.copyWriteEntry(original, newEntry);
                return newEntry;
            }
        };
        private static /* enum */ EntryFactory STRONG_ACCESS_WRITE = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new StrongAccessWriteEntry<K, V>(key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                4.copyAccessEntry(original, newEntry);
                4.copyWriteEntry(original, newEntry);
                return newEntry;
            }
        };
        private static /* enum */ EntryFactory WEAK = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakEntry(segment.keyReferenceQueue, key, hash, next);
            }
        };
        private static /* enum */ EntryFactory WEAK_ACCESS = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakAccessEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                6.copyAccessEntry(original, newEntry);
                return newEntry;
            }
        };
        private static /* enum */ EntryFactory WEAK_WRITE = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakWriteEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                7.copyWriteEntry(original, newEntry);
                return newEntry;
            }
        };
        private static /* enum */ EntryFactory WEAK_ACCESS_WRITE = new EntryFactory(){

            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                return new WeakAccessWriteEntry(segment.keyReferenceQueue, key, hash, next);
            }

            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, newNext);
                8.copyAccessEntry(original, newEntry);
                8.copyWriteEntry(original, newEntry);
                return newEntry;
            }
        };
        private static EntryFactory[] factories;

        private EntryFactory() {
        }

        static EntryFactory getFactory(Strength keyStrength, boolean usesAccessQueue, boolean usesWriteQueue) {
            int flags = (keyStrength == Strength.WEAK ? 4 : 0) | (usesAccessQueue ? 1 : 0) | (usesWriteQueue ? 2 : 0);
            return factories[flags];
        }

        abstract <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> var1, K var2, int var3, @Nullable ReferenceEntry<K, V> var4);

        @GuardedBy(value="Segment.this")
        <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            return this.newEntry(segment, original.getKey(), original.getHash(), newNext);
        }

        @GuardedBy(value="Segment.this")
        static <K, V> void copyAccessEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            newEntry.setAccessTime(original.getAccessTime());
            LocalCache.connectAccessOrder(original.getPreviousInAccessQueue(), newEntry);
            LocalCache.connectAccessOrder(newEntry, original.getNextInAccessQueue());
            LocalCache.nullifyAccessOrder(original);
        }

        @GuardedBy(value="Segment.this")
        static <K, V> void copyWriteEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            newEntry.setWriteTime(original.getWriteTime());
            LocalCache.connectWriteOrder(original.getPreviousInWriteQueue(), newEntry);
            LocalCache.connectWriteOrder(newEntry, original.getNextInWriteQueue());
            LocalCache.nullifyWriteOrder(original);
        }

        /* synthetic */ EntryFactory(String x0, int x1, byte by) {
            this();
        }

        static {
            EntryFactory[] entryFactoryArray = new EntryFactory[]{STRONG, STRONG_ACCESS, STRONG_WRITE, STRONG_ACCESS_WRITE, WEAK, WEAK_ACCESS, WEAK_WRITE, WEAK_ACCESS_WRITE};
            factories = new EntryFactory[]{STRONG, STRONG_ACCESS, STRONG_WRITE, STRONG_ACCESS_WRITE, WEAK, WEAK_ACCESS, WEAK_WRITE, WEAK_ACCESS_WRITE};
        }
    }

    static abstract class Strength
    extends Enum<Strength> {
        public static final /* enum */ Strength STRONG = new Strength(){

            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value, int weight) {
                if (weight == 1) {
                    return new StrongValueReference(value);
                }
                return new WeightedStrongValueReference(value, weight);
            }

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.equals();
            }
        };
        public static final /* enum */ Strength SOFT = new Strength(){

            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value, int weight) {
                if (weight == 1) {
                    return new SoftValueReference(segment.valueReferenceQueue, value, entry);
                }
                return new WeightedSoftValueReference(segment.valueReferenceQueue, value, entry, weight);
            }

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity();
            }
        };
        public static final /* enum */ Strength WEAK = new Strength(){

            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value, int weight) {
                if (weight == 1) {
                    return new WeakValueReference(segment.valueReferenceQueue, value, entry);
                }
                return new WeightedWeakValueReference(segment.valueReferenceQueue, value, entry, weight);
            }

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity();
            }
        };
        private static final /* synthetic */ Strength[] $VALUES;

        public static Strength[] values() {
            return (Strength[])$VALUES.clone();
        }

        private Strength() {
        }

        abstract <K, V> ValueReference<K, V> referenceValue(Segment<K, V> var1, ReferenceEntry<K, V> var2, V var3, int var4);

        abstract Equivalence<Object> defaultEquivalence();

        /* synthetic */ Strength(String x0, int x1, byte by) {
            this();
        }

        static {
            $VALUES = new Strength[]{STRONG, SOFT, WEAK};
        }
    }
}

