/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.io.Serializable;
import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.IndexingException;
import org.python.indexer.Scope;
import org.python.indexer.ast.GenericNodeVisitor;
import org.python.indexer.ast.NCall;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public abstract class NNode
implements Serializable {
    private int start = 0;
    private int end = 1;
    protected NNode parent = null;
    private transient NType type;

    public NNode() {
        this.type = Indexer.idx.builtins.None;
    }

    public NNode(int start, int end) {
        this.type = Indexer.idx.builtins.None;
        int n = start;
        NNode nNode = this;
        this.start = n;
        n = end;
        nNode = this;
        this.end = n;
    }

    public final void setParent(NNode parent) {
        this.parent = parent;
    }

    public final NNode getParent() {
        return this.parent;
    }

    private NNode getAstRoot() {
        while (this_.parent != null) {
            NNode this_ = this_.parent;
        }
        return this_;
    }

    public final void setStart(int start) {
        this.start = start;
    }

    public final void setEnd(int end) {
        this.end = end;
    }

    public final int start() {
        return this.start;
    }

    public final int end() {
        return this.end;
    }

    public final int length() {
        return this.end - this.start;
    }

    public final Scope getTable() {
        return this.getType().getTable();
    }

    public final NType getType() {
        if (this.type == null) {
            this.type = Indexer.idx.builtins.None;
        }
        return this.type;
    }

    public final NType setType(NType newType) {
        if (newType == null) {
            throw new IllegalArgumentException();
        }
        this.type = newType;
        return this.type;
    }

    public final NType addType(NType newType) {
        if (newType == null) {
            throw new IllegalArgumentException();
        }
        this.type = NUnionType.union(this.getType(), newType);
        return this.type;
    }

    public boolean bindsName() {
        return false;
    }

    protected void bindNames(Scope s) throws Exception {
        throw new UnsupportedOperationException("Not a name-binding node type");
    }

    public String getFile() {
        if (this.parent != null) {
            return this.parent.getFile();
        }
        return null;
    }

    public final void addChildren(NNode ... nodes) {
        NNode[] arr$ = nodes;
        int len$ = nodes.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            NNode n = arr$[i$];
            if (n == null) continue;
            NNode nNode = this;
            NNode nNode2 = n;
            n.parent = nNode;
        }
    }

    public final void addChildren(List<? extends NNode> nodes) {
        if (nodes != null) {
            for (NNode nNode : nodes) {
                if (nNode == null) continue;
                NNode nNode2 = this;
                NNode nNode22 = nNode;
                nNode.parent = nNode2;
            }
        }
    }

    private static NType handleExceptionInResolve(NNode n, Throwable t) {
        Indexer.idx.handleException("Unable to resolve: " + n + " in " + n.getFile(), t);
        return new NUnknownType();
    }

    public static NType resolveExpr(NNode n, Scope s) {
        if (n == null) {
            return new NUnknownType();
        }
        try {
            NType result = n.resolve(s);
            if (result == null) {
                Indexer.idx.warn(n + " resolved to a null type");
                return n.setType(new NUnknownType());
            }
            return result;
        }
        catch (IndexingException indexingException) {
            IndexingException ix = indexingException;
            throw indexingException;
        }
        catch (Exception x) {
            return NNode.handleExceptionInResolve(n, x);
        }
        catch (StackOverflowError soe) {
            String msg = "Unable to resolve: " + n + " in " + n.getFile() + " (stack overflow)";
            Indexer.idx.warn(msg);
            return NNode.handleExceptionInResolve(n, soe);
        }
    }

    public NType resolve(Scope s) throws Exception {
        return this.getType();
    }

    public boolean isCall() {
        return this instanceof NCall;
    }

    public boolean isClassDef() {
        return false;
    }

    public boolean isFunctionDef() {
        return false;
    }

    protected static void visitNode(NNode n, NNodeVisitor v) {
        if (n != null) {
            n.visit(v);
        }
    }

    protected static void visitNodeList(List<? extends NNode> nodes, NNodeVisitor v) {
        if (nodes != null) {
            for (NNode nNode : nodes) {
                if (nNode == null) continue;
                nNode.visit(v);
            }
        }
    }

    public abstract void visit(NNodeVisitor var1);

    protected final void addWarning(String msg) {
        Indexer.idx.putProblem(this, msg);
    }

    protected final void addError(String msg) {
        Indexer.idx.putProblem(this, msg);
    }

    protected static void addError(NNode loc, String msg) {
        Indexer.idx.putProblem(loc, msg);
    }

    protected static NType resolveListAsUnion(List<? extends NNode> nodes, Scope s) {
        if (nodes == null || nodes.isEmpty()) {
            return new NUnknownType();
        }
        NType result = null;
        for (NNode nNode : nodes) {
            NType nodeType = NNode.resolveExpr(nNode, s);
            if (result == null) {
                result = nodeType;
                continue;
            }
            result = NUnionType.union(result, nodeType);
        }
        return result;
    }

    protected static void resolveList(List<? extends NNode> nodes, Scope s) {
        if (nodes != null) {
            for (NNode nNode : nodes) {
                NNode.resolveExpr(nNode, s);
            }
        }
    }

    public final NNode getDeepestNodeAtOffset(int sourceOffset) {
        NNode ast = this.getAstRoot();
        DeepestOverlappingNodeFinder finder = new DeepestOverlappingNodeFinder(sourceOffset);
        try {
            ast.visit(finder);
        }
        catch (NNodeVisitor.StopIterationException stopIterationException) {}
        return finder.getNode();
    }

    static final class DeepestOverlappingNodeFinder
    extends GenericNodeVisitor {
        private int offset;
        private NNode deepest;

        public DeepestOverlappingNodeFinder(int offset) {
            this.offset = offset;
        }

        public final NNode getNode() {
            return this.deepest;
        }

        @Override
        public final boolean dispatch(NNode node) {
            if (this.offset > node.end) {
                return false;
            }
            if (this.offset >= node.start && this.offset <= node.end) {
                this.deepest = node;
                return true;
            }
            throw new NNodeVisitor.StopIterationException();
        }
    }
}

