/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.jython;

import java.util.List;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.pydev.jython.JythonModules;
import org.python.pydev.jython.JythonPlugin;
import org.python.pydev.shared_core.jython.IPythonInterpreter;
import org.python.pydev.shared_core.jython.JythonPep8Core;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public class JythonPep8 {
    public static final String EXECUTE_PEP8 = "import sys\nargv = ['pycodestyle.py', r'%s'%s]\nsys.argv=argv\n\n\npep8style = pycodestyle.StyleGuide(parse_argv=True, config_file=False)\n\nchecker = pycodestyle.Checker(options=pep8style.options, filename='%s', lines=lines)\n\nif ReportError is None: #Only redefine if it wasn't defined already\n    class ReportError:\n\n        def __init__(self, checker, pep8style, visitor):\n            self.checker = checker\n            self.pep8style = pep8style\n            self.visitor = visitor\n            self.original = checker.report_error\n            checker.report_error = self\n            if not self.pep8style.excluded(self.checker.filename):\n                checker.check_all()\n            #Clear references\n            self.original = None\n            self.checker = None\n            self.pep8style = None\n            self.visitor = None\n            checker.report_error = None\n        \n        def __call__(self, line_number, offset, text, check):\n            code = text[:4]\n            if self.pep8style.options.ignore_code(code):\n                return\n            self.visitor.reportError(line_number, offset, text, check)\n            return self.original(line_number, offset, text, check)\n\nReportError(checker, pep8style, visitor)\nchecker = None #Release checker\npep8style = None #Release pep8style\n";
    public static final Object lock = new Object();
    public static volatile PyObject reportError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void analyzePep8WithJython(JythonPep8Core pep8Params) {
        FastStringBuffer args = new FastStringBuffer(pep8Params.pep8CommandLine.length * 20);
        String[] stringArray = pep8Params.pep8CommandLine;
        int n = pep8Params.pep8CommandLine.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            args.append(',').append("r'").append(string).append('\'');
            ++n2;
        }
        IPythonInterpreter interpreter = JythonPlugin.newPythonInterpreter(pep8Params.useConsole, false);
        String file = StringUtils.replaceAllSlashes((String)pep8Params.absolutePath);
        interpreter.set("visitor", pep8Params.visitor);
        List splitInLines = StringUtils.splitInLines((String)pep8Params.document.get());
        interpreter.set("lines", (Object)splitInLines);
        PyObject tempReportError = reportError;
        if (tempReportError != null) {
            interpreter.set("ReportError", (Object)tempReportError);
        } else {
            interpreter.set("ReportError", (Object)Py.None);
        }
        PyObject pep8Module = JythonModules.getPep8Module(interpreter);
        interpreter.set("pycodestyle", (Object)pep8Module);
        String formatted = StringUtils.format((String)EXECUTE_PEP8, (Object[])new Object[]{file, args.toString(), file});
        interpreter.exec(formatted);
        if (reportError == null) {
            Object object = lock;
            synchronized (object) {
                if (reportError == null) {
                    reportError = (PyObject)interpreter.get("ReportError");
                }
            }
        }
    }
}

