/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.markoccurrences;

import com.python.pydev.analysis.refactoring.wizards.rename.PyReferenceSearcher;
import com.python.pydev.refactoring.ui.MarkOccurrencesPreferencesPage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.refactoring.PyRefactorAction;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.editor.BaseEditor;
import org.python.pydev.shared_ui.mark_occurrences.BaseMarkOccurrencesJob;

public class MarkOccurrencesJob
extends BaseMarkOccurrencesJob {
    private static final Set<String> LOCAL_TEXT_SEARCHES_ON = new HashSet<String>();
    private static final String ANNOTATIONS_CACHE_KEY = "MarkOccurrencesJob Annotations";
    private static final String OCCURRENCE_ANNOTATION_TYPE = "com.python.pydev.occurrences";

    static {
        LOCAL_TEXT_SEARCHES_ON.add("assert");
        LOCAL_TEXT_SEARCHES_ON.add("break");
        LOCAL_TEXT_SEARCHES_ON.add("continue");
        LOCAL_TEXT_SEARCHES_ON.add("del");
        LOCAL_TEXT_SEARCHES_ON.add("lambda");
        LOCAL_TEXT_SEARCHES_ON.add("nonlocal");
        LOCAL_TEXT_SEARCHES_ON.add("global");
        LOCAL_TEXT_SEARCHES_ON.add("pass");
        LOCAL_TEXT_SEARCHES_ON.add("print");
        LOCAL_TEXT_SEARCHES_ON.add("raise");
        LOCAL_TEXT_SEARCHES_ON.add("return");
    }

    public MarkOccurrencesJob(WeakReference<BaseEditor> editor, TextSelectionUtils ps) {
        super(editor, ps);
    }

    protected BaseMarkOccurrencesJob.MarkOccurrencesRequest createRequest(BaseEditor baseEditor, IDocumentProvider documentProvider, IProgressMonitor monitor) throws BadLocationException, OperationCanceledException, CoreException, MisconfigurationException {
        if (!MarkOccurrencesPreferencesPage.useMarkOccurrences()) {
            return new PyMarkOccurrencesRequest(false, null, null);
        }
        PyEdit pyEdit = (PyEdit)baseEditor;
        PyRefactorAction pyRefactorAction = MarkOccurrencesJob.getRefactorAction(pyEdit);
        String currToken = (String)this.ps.getCurrToken().o1;
        if (LOCAL_TEXT_SEARCHES_ON.contains(currToken) && "__dftl_partition_content_type".equals(ParsingUtils.getContentType((IDocument)this.ps.getDoc(), (int)this.ps.getAbsoluteCursorOffset()))) {
            return new TextBasedLocalMarkOccurrencesRequest(currToken);
        }
        RefactoringRequest req = MarkOccurrencesJob.getRefactoringRequest(pyEdit, pyRefactorAction, PySelection.fromTextSelection((TextSelectionUtils)this.ps));
        if (req == null || !req.nature.getRelatedInterpreterManager().isConfigured()) {
            return new PyMarkOccurrencesRequest(false, null, null);
        }
        PyReferenceSearcher searcher = new PyReferenceSearcher(new RefactoringRequest[]{req});
        if (monitor.isCanceled()) {
            return new PyMarkOccurrencesRequest(false, null, null);
        }
        try {
            searcher.prepareSearch(req);
            if (monitor.isCanceled()) {
                return new PyMarkOccurrencesRequest(false, null, null);
            }
            searcher.search(req);
            if (monitor.isCanceled()) {
                return new PyMarkOccurrencesRequest(false, null, null);
            }
            return new PyMarkOccurrencesRequest(true, req, searcher);
        }
        catch (PyReferenceSearcher.SearchException | BadLocationException e) {
            return new PyMarkOccurrencesRequest(false, null, null);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error in occurrences while analyzing modName:" + req.moduleName + " initialName:" + req.qualifier + " line (start at 0):" + req.ps.getCursorLine(), e);
        }
    }

    protected synchronized Map<Annotation, Position> getAnnotationsToAddAsMap(BaseEditor baseEditor, IAnnotationModel annotationModel, BaseMarkOccurrencesJob.MarkOccurrencesRequest markOccurrencesRequest, IProgressMonitor monitor) throws BadLocationException {
        PyEdit pyEdit = (PyEdit)baseEditor;
        PySourceViewer viewer = pyEdit.getPySourceViewer();
        if (viewer == null || monitor.isCanceled()) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        if (markOccurrencesRequest instanceof TextBasedLocalMarkOccurrencesRequest) {
            TextBasedLocalMarkOccurrencesRequest textualMarkOccurrencesRequest = (TextBasedLocalMarkOccurrencesRequest)markOccurrencesRequest;
            PySelection pySelection = PySelection.fromTextSelection((TextSelectionUtils)this.ps);
            Tuple startEndLines = pySelection.getCurrentMethodStartEndLines();
            int initialOffset = pySelection.getAbsoluteCursorOffset(((Integer)startEndLines.o1).intValue(), 0);
            int finalOffset = pySelection.getEndLineOffset(((Integer)startEndLines.o2).intValue());
            List occurrences = this.ps.searchOccurrences(textualMarkOccurrencesRequest.currToken);
            if (occurrences.size() == 0) {
                return null;
            }
            HashMap<Annotation, Position> toAddAsMap = new HashMap<Annotation, Position>();
            for (IRegion iRegion : occurrences) {
                if (iRegion.getOffset() < initialOffset || iRegion.getOffset() > finalOffset) continue;
                try {
                    Annotation annotation = new Annotation(this.getOccurrenceAnnotationsType(), false, "occurrence");
                    Position position = new Position(iRegion.getOffset(), iRegion.getLength());
                    toAddAsMap.put(annotation, position);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            return toAddAsMap;
        }
        PyMarkOccurrencesRequest pyMarkOccurrencesRequest = (PyMarkOccurrencesRequest)markOccurrencesRequest;
        Set<ASTEntry> occurrences = pyMarkOccurrencesRequest.getOccurrences();
        if (occurrences == null) {
            return null;
        }
        IDocument doc = pyEdit.getDocument();
        HashMap<Annotation, Position> toAddAsMap = new HashMap<Annotation, Position>();
        boolean markOccurrencesInStrings = MarkOccurrencesPreferencesPage.useMarkOccurrencesInStrings();
        for (ASTEntry entry : occurrences) {
            if (!markOccurrencesInStrings && entry.node instanceof Name) {
                Name name = (Name)entry.node;
                if (name.ctx == 7) continue;
            }
            SimpleNode node = entry.getNameNode();
            IRegion lineInformation = doc.getLineInformation(node.beginLine - 1);
            try {
                Annotation annotation = new Annotation(this.getOccurrenceAnnotationsType(), false, "occurrence");
                Position position = new Position(lineInformation.getOffset() + node.beginColumn - 1, pyMarkOccurrencesRequest.getInitialName().length());
                toAddAsMap.put(annotation, position);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return toAddAsMap;
    }

    public static RefactoringRequest getRefactoringRequest(PyEdit pyEdit, PyRefactorAction pyRefactorAction, PySelection ps) throws BadLocationException, MisconfigurationException {
        RefactoringRequest req = pyRefactorAction.getRefactoringRequest();
        req.ps = ps;
        req.fillActivationTokenAndQualifier();
        req.inputName = "foo";
        req.setAdditionalInfo("findDefinitionInAdditionalInfo", (Object)false);
        req.setAdditionalInfo("findReferencesOnlyOnLocalScope", (Object)true);
        return req;
    }

    public static PyRefactorAction getRefactorAction(PyEdit pyEdit) {
        PyRefactorAction pyRefactorAction = new PyRefactorAction(){

            protected String perform(IAction action, IProgressMonitor monitor) throws Exception {
                throw new RuntimeException("Perform should not be called in this case.");
            }
        };
        pyRefactorAction.setEditor((IEditorPart)pyEdit);
        return pyRefactorAction;
    }

    protected String getOccurrenceAnnotationsCacheKey() {
        return ANNOTATIONS_CACHE_KEY;
    }

    protected String getOccurrenceAnnotationsType() {
        return OCCURRENCE_ANNOTATION_TYPE;
    }

    public static synchronized void scheduleRequest(WeakReference<BaseEditor> editor2, TextSelectionUtils ps) {
        BaseMarkOccurrencesJob.scheduleRequest((BaseMarkOccurrencesJob)new MarkOccurrencesJob(editor2, ps));
    }

    public static synchronized void scheduleRequest(WeakReference<BaseEditor> editor2, TextSelectionUtils ps, int time) {
        BaseMarkOccurrencesJob.scheduleRequest((BaseMarkOccurrencesJob)new MarkOccurrencesJob(editor2, ps), (int)time);
    }

    private static final class PyMarkOccurrencesRequest
    extends BaseMarkOccurrencesJob.MarkOccurrencesRequest {
        private final RefactoringRequest refactoringRequest;
        private final PyReferenceSearcher pyReferenceSearcher;

        public PyMarkOccurrencesRequest(boolean proceedWithMarkOccurrences, RefactoringRequest refactoringRequest, PyReferenceSearcher pyReferenceSearcher) {
            super(proceedWithMarkOccurrences);
            this.refactoringRequest = refactoringRequest;
            this.pyReferenceSearcher = pyReferenceSearcher;
        }

        public Set<ASTEntry> getOccurrences() {
            return this.pyReferenceSearcher.getLocalReferences(this.refactoringRequest);
        }

        public String getInitialName() {
            return this.refactoringRequest.qualifier;
        }
    }

    private static final class TextBasedLocalMarkOccurrencesRequest
    extends BaseMarkOccurrencesJob.MarkOccurrencesRequest {
        private String currToken;

        public TextBasedLocalMarkOccurrencesRequest(String currToken) {
            super(true);
            this.currToken = currToken;
        }
    }
}

