/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer.search.copied;

import com.python.pydev.refactoring.refactorer.search.AbstractPythonSearchQuery;
import com.python.pydev.refactoring.refactorer.search.copied.EditorOpener;
import com.python.pydev.refactoring.refactorer.search.copied.FileLabelProvider;
import com.python.pydev.refactoring.refactorer.search.copied.FileTableContentProvider;
import com.python.pydev.refactoring.refactorer.search.copied.FileTreeContentProvider;
import com.python.pydev.refactoring.refactorer.search.copied.IFileSearchContentProvider;
import com.python.pydev.refactoring.refactorer.search.copied.LineElement;
import com.python.pydev.refactoring.refactorer.search.copied.NavigatorDragAdapter;
import com.python.pydev.refactoring.refactorer.search.copied.NewTextSearchActionGroup;
import com.python.pydev.refactoring.refactorer.search.copied.OpenSearchPreferencesAction;
import com.python.pydev.refactoring.refactorer.search.copied.SortAction;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.python.pydev.shared_ui.search.ICustomMatch;
import org.python.pydev.shared_ui.search.SearchMessages;
import org.python.pydev.shared_ui.search.replace.ReplaceAction;

public class FileSearchPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final String KEY_SORTING = "org.eclipse.search.resultpage.sorting";
    private static final String KEY_LIMIT = "org.eclipse.search.resultpage.limit";
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;
    private ActionGroup fActionGroup;
    private IFileSearchContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private SortAction fSortByNameAction;
    private SortAction fSortByPathAction;
    private EditorOpener fEditorOpener = new EditorOpener();
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.ui.navigator.ProjectExplorer"};
    private static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };

    public FileSearchPage() {
        this.fSortByNameAction = new SortAction(SearchMessages.FileSearchPage_sort_name_label, this, 2);
        this.fSortByPathAction = new SortAction(SearchMessages.FileSearchPage_sort_path_label, this, 3);
        this.setElementLimit(1000);
    }

    public void setElementLimit(Integer elementLimit) {
        try {
            super.setElementLimit(elementLimit);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int limit = elementLimit;
        this.getSettings().put(KEY_LIMIT, limit);
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    private void addDragAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance()};
        int ops = 5;
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new NavigatorDragAdapter((ISelectionProvider)viewer));
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        FileLabelProvider innerLabelProvider = new FileLabelProvider(this, this.fCurrentSortOrder);
        viewer.setLabelProvider((IBaseLabelProvider)innerLabelProvider);
        viewer.setContentProvider((IContentProvider)new FileTableContentProvider(this));
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        FileLabelProvider innerLabelProvider = new FileLabelProvider(this, 1);
        viewer.setLabelProvider((IBaseLabelProvider)innerLabelProvider);
        viewer.setContentProvider((IContentProvider)new FileTreeContentProvider(this, (AbstractTreeViewer)viewer));
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (IFileSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IFile file = (IFile)match.getElement();
        IWorkbenchPage page = this.getSite().getPage();
        if (offset >= 0 && length != 0) {
            this.fEditorOpener.openAndSelect(page, file, offset, length, activate);
        } else {
            this.fEditorOpener.open(page, file, activate);
        }
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement;
        if (this.showLineMatches() && (firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof IFile && this.getDisplayedMatchCount(firstElement) == 0) {
            try {
                this.fEditorOpener.open(this.getSite().getPage(), (IFile)firstElement, false);
            }
            catch (PartInitException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)SearchMessages.FileSearchPage_open_file_dialog_title, (String)SearchMessages.FileSearchPage_open_file_failed, (IStatus)e.getStatus());
            }
            return;
        }
        super.handleOpen(event);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(mgr);
        AbstractPythonSearchQuery query = (AbstractPythonSearchQuery)this.getInput().getQuery();
        if (query.getSearchString().length() > 0) {
            IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
            if (!selection.isEmpty()) {
                ReplaceAction replaceSelection = new ReplaceAction(this.getSite().getShell(), this.getInput(), selection.toArray(), true);
                replaceSelection.setText(SearchMessages.ReplaceAction_label_selected);
                mgr.appendToGroup("group.reorganize", (IAction)replaceSelection);
            }
            ReplaceAction replaceAll = new ReplaceAction(this.getSite().getShell(), this.getInput(), null, true);
            replaceAll.setText(SearchMessages.ReplaceAction_label_all);
            mgr.appendToGroup("group.reorganize", (IAction)replaceAll);
        }
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(SearchMessages.FileSearchPage_sort_by_label);
        sortMenu.add((IAction)this.fSortByNameAction);
        sortMenu.add((IAction)this.fSortByPathAction);
        this.fSortByNameAction.setChecked(this.fCurrentSortOrder == this.fSortByNameAction.getSortOrder());
        this.fSortByPathAction.setChecked(this.fCurrentSortOrder == this.fSortByPathAction.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fActionGroup = new NewTextSearchActionGroup((IViewPart)part);
    }

    public void init(IPageSite site) {
        super.init(site);
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.appendToGroup("group.properties", (IAction)new OpenSearchPreferencesAction());
    }

    public void dispose() {
        this.fActionGroup.dispose();
        super.dispose();
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    public void setSortOrder(int sortOrder) {
        this.fCurrentSortOrder = sortOrder;
        DecoratingLabelProvider lpWrapper = (DecoratingLabelProvider)this.getViewer().getLabelProvider();
        ((FileLabelProvider)lpWrapper.getLabelProvider()).setOrder(sortOrder);
        this.getViewer().refresh();
        this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        try {
            this.fCurrentSortOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException e) {
            this.fCurrentSortOrder = this.fSortByNameAction.getSortOrder();
        }
        int elementLimit = 1000;
        try {
            elementLimit = this.getSettings().getInt(KEY_LIMIT);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (memento != null) {
            Integer value = memento.getInteger(KEY_SORTING);
            if (value != null) {
                this.fCurrentSortOrder = value;
            }
            if ((value = memento.getInteger(KEY_LIMIT)) != null) {
                elementLimit = value;
            }
        }
        this.setElementLimit(elementLimit);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
        try {
            memento.putInteger(KEY_LIMIT, this.getElementLimit().intValue());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IShowInTargetList.class.equals(adapter)) {
            return (T)SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    public String getLabel() {
        String label = super.getLabel();
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TableViewer) {
            TableViewer tv = (TableViewer)viewer;
            AbstractTextSearchResult result = this.getInput();
            if (result != null) {
                int itemCount = ((IStructuredContentProvider)tv.getContentProvider()).getElements((Object)this.getInput()).length;
                if (this.showLineMatches()) {
                    int matchCount = this.getInput().getMatchCount();
                    if (itemCount < matchCount) {
                        return MessageFormat.format(SearchMessages.FileSearchPage_limited_format_matches, label, itemCount, matchCount);
                    }
                } else {
                    int fileCount = this.getInput().getElements().length;
                    if (itemCount < fileCount) {
                        return MessageFormat.format(SearchMessages.FileSearchPage_limited_format_files, label, itemCount, fileCount);
                    }
                }
            }
        }
        return label;
    }

    public int getDisplayedMatchCount(Object element) {
        if (this.showLineMatches()) {
            if (element instanceof LineElement) {
                LineElement lineEntry = (LineElement)element;
                return lineEntry.getNumberOfMatches(this.getInput());
            }
            return 0;
        }
        return super.getDisplayedMatchCount(element);
    }

    public Match[] getDisplayedMatches(Object element) {
        if (this.showLineMatches()) {
            if (element instanceof LineElement) {
                LineElement lineEntry = (LineElement)element;
                return lineEntry.getMatches(this.getInput());
            }
            return new Match[0];
        }
        return super.getDisplayedMatches(element);
    }

    protected void evaluateChangedElements(Match[] matches, Set changedElements) {
        if (this.showLineMatches()) {
            int i = 0;
            while (i < matches.length) {
                changedElements.add(((ICustomMatch)matches[i]).getLineElement());
                ++i;
            }
        } else {
            int i = 0;
            while (i < matches.length) {
                changedElements.add(matches[i].getElement());
                ++i;
            }
        }
    }

    private boolean showLineMatches() {
        AbstractTextSearchResult input = this.getInput();
        return this.getLayout() == 2 && input != null && !((AbstractPythonSearchQuery)input.getQuery()).isFileNameSearch();
    }

    public static class DecoratorIgnoringViewerSorter
    extends ViewerComparator {
        private final ILabelProvider fLabelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            this.fLabelProvider = labelProvider;
        }

        public int category(Object element) {
            if (element instanceof IContainer) {
                return 1;
            }
            return 2;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof LineElement && e2 instanceof LineElement) {
                LineElement m1 = (LineElement)e1;
                LineElement m2 = (LineElement)e2;
                return m1.getOffset() - m2.getOffset();
            }
            String name1 = this.fLabelProvider.getText(e1);
            String name2 = this.fLabelProvider.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.getComparator().compare(name1, name2);
        }
    }
}

