/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer.search.copied;

import com.python.pydev.refactoring.refactorer.search.PythonFileSearchResult;
import com.python.pydev.refactoring.refactorer.search.copied.FileSearchPage;
import com.python.pydev.refactoring.refactorer.search.copied.IFileSearchContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class FileTableContentProvider
implements IStructuredContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private FileSearchPage fPage;
    private AbstractTextSearchResult fResult;

    public FileTableContentProvider(FileSearchPage page) {
        this.fPage = page;
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof PythonFileSearchResult) {
            int elementLimit = this.getElementLimit();
            Object[] elements = ((PythonFileSearchResult)((Object)inputElement)).getElements();
            if (elementLimit != -1 && elements.length > elementLimit) {
                Object[] shownElements = new Object[elementLimit];
                System.arraycopy(elements, 0, shownElements, 0, elementLimit);
                return shownElements;
            }
            return elements;
        }
        return this.EMPTY_ARR;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof PythonFileSearchResult) {
            this.fResult = (PythonFileSearchResult)((Object)newInput);
        }
    }

    @Override
    public void elementsChanged(Object[] updatedElements) {
        TableViewer viewer = this.getViewer();
        int elementLimit = this.getElementLimit();
        boolean tableLimited = elementLimit != -1;
        int i = 0;
        while (i < updatedElements.length) {
            if (this.fResult.getMatchCount(updatedElements[i]) > 0) {
                if (viewer.testFindItem(updatedElements[i]) != null) {
                    viewer.update(updatedElements[i], null);
                } else if (!tableLimited || viewer.getTable().getItemCount() < elementLimit) {
                    viewer.add(updatedElements[i]);
                }
            } else {
                viewer.remove(updatedElements[i]);
            }
            ++i;
        }
    }

    private int getElementLimit() {
        try {
            return this.fPage.getElementLimit();
        }
        catch (Throwable e) {
            return 0;
        }
    }

    private TableViewer getViewer() {
        return (TableViewer)this.fPage.getViewer();
    }

    @Override
    public void clear() {
        this.getViewer().refresh();
    }
}

