/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.marker_quick_fixes;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.python.pydev.core.CheckAnalysisErrors;
import org.python.pydev.core.IAnalysisMarkersParticipant;
import org.python.pydev.core.IAnalysisPreferences;
import org.python.pydev.core.IMarkerInfoForAnalysis;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageCache;

public class IgnoreErrorParticipant
implements IAnalysisMarkersParticipant {
    private Set<Integer> handled = new HashSet<Integer>();
    private FormatStd format;

    public IgnoreErrorParticipant() {
        this(null);
    }

    private IgnoreErrorParticipant(FormatStd format) {
        this.format = format;
    }

    public static IgnoreErrorParticipant createForTests(FormatStd format) {
        return new IgnoreErrorParticipant(format);
    }

    public void addProps(IMarkerInfoForAnalysis markerInfo, IAnalysisPreferences analysisPreferences, String line, PySelection ps, int offset, IPythonNature nature, IPyEdit edit, List<ICompletionProposalHandle> props) throws BadLocationException, CoreException {
        Integer id = markerInfo.getPyDevAnalisysType();
        if (this.handled.contains(id)) {
            return;
        }
        this.handled.add(id);
        String messageToIgnore = analysisPreferences.getRequiredMessageToIgnore(id.intValue());
        if (CheckAnalysisErrors.isCodeAnalysisErrorHandled((String)line, (String)messageToIgnore)) {
            return;
        }
        IImageCache imageCache = SharedCorePlugin.getImageCache();
        ICompletionProposalHandle proposal = CompletionProposalFactory.get().createIgnoreCompletionProposalInSameLine(messageToIgnore, ps.getEndLineOffset(), 0, offset, imageCache != null ? imageCache.get("icons/annotation_obj.gif") : null, messageToIgnore.substring(1), null, null, 10, edit, line, ps, this.format);
        props.add(proposal);
    }
}

