/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.marker_quick_fixes;

import com.python.pydev.analysis.refactoring.tdd.NullPyCreateAction;
import com.python.pydev.analysis.refactoring.tdd.PyCreateClass;
import com.python.pydev.analysis.refactoring.tdd.PyCreateMethodOrField;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.codecompletion.revisited.CompletionCache;
import org.python.pydev.ast.codecompletion.revisited.CompletionState;
import org.python.pydev.ast.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.ast.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.core.IAnalysisMarkersParticipant;
import org.python.pydev.core.IAnalysisPreferences;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IMarkerInfoForAnalysis;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.ImportHandle;
import org.python.pydev.core.docutils.PyImportsHandling;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.CoreTextSelection;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.string.ICoreTextSelection;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class TddQuickFixFromMarkersParticipant
implements IAnalysisMarkersParticipant {
    IImageHandle imageClass;
    IImageHandle imageMethod;
    IImageHandle imageModule;

    public TddQuickFixFromMarkersParticipant() {
        IImageCache imageCache = SharedCorePlugin.getImageCache();
        if (imageCache != null) {
            this.imageClass = imageCache.get("icons/new/create_class_obj.png");
            this.imageMethod = imageCache.get("icons/new/create_method_obj.png");
            this.imageModule = imageCache.get("icons/new/create_python_module.png");
        }
    }

    public void addProps(IMarkerInfoForAnalysis markerInfo, IAnalysisPreferences analysisPreferences, String line, PySelection ps, int offset, IPythonNature nature, IPyEdit edit, List<ICompletionProposalHandle> props) throws BadLocationException, CoreException {
        String markerContents;
        if (nature == null) {
            return;
        }
        ICodeCompletionASTManager astManager = nature.getAstManager();
        if (astManager == null) {
            return;
        }
        if (!markerInfo.hasPosition()) {
            return;
        }
        Integer id = markerInfo.getPyDevAnalisysType();
        int start = markerInfo.getOffset();
        int end = start + markerInfo.getLength();
        ps.setSelection(start, end);
        try {
            markerContents = ps.getSelectedText();
        }
        catch (Exception e1) {
            return;
        }
        IDocument doc = ps.getDoc();
        List parametersAfterCall = ps.getParametersAfterCall(end);
        switch (id) {
            case 3: {
                this.addCreateClassOption(ps, edit, props, markerContents, parametersAfterCall);
                this.addCreateMethodOption(ps, edit, props, markerContents, parametersAfterCall);
                break;
            }
            case 9: {
                String[] activationTokenAndQual = ps.getActivationTokenAndQualifier(true);
                if (!activationTokenAndQual[0].endsWith(".")) break;
                ArrayList<IDefinition> selected = this.findDefinitions(nature, edit, start - 2, doc);
                for (IDefinition iDefinition : selected) {
                    IModule module = iDefinition.getModule();
                    if (module.getFile() == null) continue;
                    Definition definition = (Definition)iDefinition;
                    File file = module.getFile();
                    if (definition.ast == null) {
                        this.addCreateClassOption(ps, edit, props, markerContents, parametersAfterCall, file);
                        this.addCreateMethodOption(ps, edit, props, markerContents, parametersAfterCall, file);
                        continue;
                    }
                    if (!(definition.ast instanceof ClassDef)) continue;
                    ClassDef classDef = (ClassDef)definition.ast;
                    PyCreateMethodOrField pyCreateMethod = new PyCreateMethodOrField();
                    String className = NodeUtils.getNameFromNameTok((NameTokType)classDef.name);
                    pyCreateMethod.setCreateInClass(className);
                    pyCreateMethod.setCreateAs(1);
                    this.addCreateClassmethodOption(ps, edit, props, markerContents, parametersAfterCall, pyCreateMethod, file, className);
                }
                break;
            }
            case 6: {
                String fullPath;
                File f;
                PyImportsHandling importsHandling = new PyImportsHandling(ps.getDoc(), false);
                int offsetLine = ps.getLineOfOffset(start);
                String selectedText = ps.getSelectedText();
                Tuple found = null;
                Object foundFromImportStr = null;
                boolean isImportFrom = false;
                block10: for (ImportHandle handle : importsHandling) {
                    if (handle.startFoundLine != offsetLine && handle.endFoundLine != offsetLine && (handle.startFoundLine >= offsetLine || handle.endFoundLine <= offsetLine)) continue;
                    List importInfo = handle.getImportInfo();
                    for (ImportHandle.ImportHandleInfo importHandleInfo : importInfo) {
                        String fromImportStr = importHandleInfo.getFromImportStr();
                        List importedStr = importHandleInfo.getImportedStr();
                        for (Object imported : importedStr) {
                            if (!selectedText.equals(imported)) continue;
                            if (fromImportStr != null) {
                                foundFromImportStr = fromImportStr + "." + (String)imported;
                                isImportFrom = true;
                            } else {
                                foundFromImportStr = imported;
                            }
                            try {
                                String currentModule = nature.resolveModule(edit.getEditorFile());
                                ICompletionState state = CompletionStateFactory.getEmptyCompletionState((IPythonNature)nature, (ICompletionCache)new CompletionCache());
                                found = nature.getAstManager().findModule((String)foundFromImportStr, currentModule, state, (IModule)new SourceModule(currentModule, edit.getEditorFile(), (SimpleNode)edit.getAST(), null, nature));
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                            }
                            break block10;
                        }
                    }
                }
                boolean addOptionToCreateClassOrMethod = isImportFrom;
                if (found != null && found.o1 != null) {
                    File f2;
                    if (!(found.o1 instanceof SourceModule) || found.o2 == null || ((String)found.o2).length() <= 0) break;
                    SourceModule sourceModule = (SourceModule)found.o1;
                    File file = sourceModule.getFile();
                    if (((String)found.o2).indexOf(46) != -1) {
                        if (!addOptionToCreateClassOrMethod) {
                            if (!sourceModule.getName().endsWith(".__init__")) break;
                            f2 = this.getFileStructure(file.getParentFile(), (String)found.o2);
                            this.addCreateModuleOption(ps, edit, props, markerContents, f2);
                            break;
                        }
                        if (!sourceModule.getName().endsWith(".__init__")) break;
                        Object moduleName = FullRepIterable.getWithoutLastPart((String)sourceModule.getName());
                        String withoutLastPart = FullRepIterable.getWithoutLastPart((String)((String)found.o2));
                        moduleName = (String)moduleName + "." + withoutLastPart;
                        String classOrMethodName = FullRepIterable.getLastPart((String)((String)found.o2));
                        f = this.getFileStructure(file.getParentFile(), withoutLastPart);
                        this.addCreateClassInNewModuleOption(ps, edit, props, classOrMethodName, (String)moduleName, parametersAfterCall, f);
                        this.addCreateMethodInNewModuleOption(ps, edit, props, classOrMethodName, (String)moduleName, parametersAfterCall, f);
                        break;
                    }
                    if (!addOptionToCreateClassOrMethod || sourceModule.getName().endsWith(".__init__")) {
                        if (!sourceModule.getName().endsWith(".__init__")) break;
                        f2 = new File(file.getParent(), (String)found.o2 + FileTypesPreferences.getDefaultDottedPythonExtension());
                        this.addCreateModuleOption(ps, edit, props, markerContents, f2);
                        break;
                    }
                    this.addCreateClassOption(ps, edit, props, markerContents, parametersAfterCall, file);
                    this.addCreateMethodOption(ps, edit, props, markerContents, parametersAfterCall, file);
                    break;
                }
                if (foundFromImportStr == null) break;
                File editorFile = edit.getEditorFile();
                List split = nature.getPythonPathNature().getOnlyProjectPythonPathStr(false, true);
                int i = 0;
                while (i < split.size()) {
                    fullPath = FileUtils.getFileAbsolutePath((String)((String)split.get(i)));
                    fullPath = PythonPathHelper.getDefaultPathStr((String)fullPath);
                    split.set(i, fullPath);
                    ++i;
                }
                HashSet projectSourcePath = new HashSet(split);
                if (projectSourcePath.size() == 0) {
                    return;
                }
                fullPath = FileUtils.getFileAbsolutePath((File)editorFile);
                fullPath = PythonPathHelper.getDefaultPathStr((String)fullPath);
                String foundSourceFolderFullPath = null;
                if (projectSourcePath.size() == 1) {
                    foundSourceFolderFullPath = (String)projectSourcePath.iterator().next();
                } else {
                    for (String string : projectSourcePath) {
                        if (!fullPath.startsWith(string)) continue;
                        foundSourceFolderFullPath = string;
                        break;
                    }
                }
                if (foundSourceFolderFullPath == null) break;
                if (!addOptionToCreateClassOrMethod) {
                    f = this.getFileStructure(new File(foundSourceFolderFullPath), (String)foundFromImportStr);
                    this.addCreateModuleOption(ps, edit, props, (String)foundFromImportStr, f);
                    break;
                }
                String moduleName = FullRepIterable.getWithoutLastPart((String)foundFromImportStr);
                File file = this.getFileStructure(new File(foundSourceFolderFullPath), moduleName);
                String lastPart = FullRepIterable.getLastPart((String)foundFromImportStr);
                this.addCreateClassInNewModuleOption(ps, edit, props, lastPart, moduleName, parametersAfterCall, file);
                this.addCreateMethodInNewModuleOption(ps, edit, props, lastPart, moduleName, parametersAfterCall, file);
            }
        }
    }

    protected File getFileStructure(File file, String withoutLastPart) {
        File f = file;
        List split = StringUtils.dotSplit((String)withoutLastPart);
        int size = split.size();
        int i = 0;
        while (i < size) {
            f = i == size - 1 ? new File(f, (String)split.get(i) + FileTypesPreferences.getDefaultDottedPythonExtension()) : new File(f, (String)split.get(i));
            ++i;
        }
        return f;
    }

    private void addCreateClassmethodOption(PySelection ps, IPyEdit edit, List<ICompletionProposalHandle> props, String markerContents, List<String> parametersAfterCall, PyCreateMethodOrField pyCreateMethod, File file, String className) {
        props.add(CompletionProposalFactory.get().createTddRefactorCompletionInModule(markerContents, this.imageMethod, "Create " + markerContents + " classmethod at " + className + " in " + file.getName(), null, "Create " + markerContents + " classmethod at class: " + className + " in " + String.valueOf(file), 5, edit, file, parametersAfterCall, (Object)pyCreateMethod, ps, 1));
    }

    private void addCreateMethodOption(PySelection ps, IPyEdit edit, List<ICompletionProposalHandle> props, String markerContents, List<String> parametersAfterCall, File file) {
        props.add(CompletionProposalFactory.get().createTddRefactorCompletionInModule(markerContents, this.imageMethod, "Create " + markerContents + " method at " + file.getName(), null, "Create " + markerContents + " method at " + String.valueOf(file), 5, edit, file, parametersAfterCall, (Object)new PyCreateMethodOrField(), ps, 1));
    }

    private void addCreateClassOption(PySelection ps, IPyEdit edit, List<ICompletionProposalHandle> props, String markerContents, List<String> parametersAfterCall, File file) {
        props.add(CompletionProposalFactory.get().createTddRefactorCompletionInModule(markerContents, this.imageClass, "Create " + markerContents + " class at " + file.getName(), null, "Create " + markerContents + " class at " + String.valueOf(file), 5, edit, file, parametersAfterCall, (Object)new PyCreateClass(), ps, 1));
    }

    private void addCreateClassInNewModuleOption(PySelection ps, IPyEdit edit, List<ICompletionProposalHandle> props, String markerContents, String moduleName, List<String> parametersAfterCall, File file) {
        props.add(CompletionProposalFactory.get().createTddRefactorCompletionInInexistentModule(markerContents, this.imageClass, "Create " + markerContents + " class at new module " + moduleName, null, "Create " + markerContents + " class at new module " + String.valueOf(file), 5, edit, file, new ArrayList(), (Object)new PyCreateClass(), ps));
    }

    private void addCreateMethodInNewModuleOption(PySelection ps, IPyEdit edit, List<ICompletionProposalHandle> props, String markerContents, String moduleName, List<String> parametersAfterCall, File file) {
        props.add(CompletionProposalFactory.get().createTddRefactorCompletionInInexistentModule(markerContents, this.imageMethod, "Create " + markerContents + " method at new module " + moduleName, null, "Create " + markerContents + " method at new module " + String.valueOf(file), 5, edit, file, new ArrayList(), (Object)new PyCreateMethodOrField(), ps));
    }

    private void addCreateModuleOption(PySelection ps, IPyEdit edit, List<ICompletionProposalHandle> props, String markerContents, File file) {
        props.add(CompletionProposalFactory.get().createTddRefactorCompletionInInexistentModule(markerContents, this.imageModule, "Create " + markerContents + " module", null, "Create " + markerContents + " module (" + String.valueOf(file) + ")", 5, edit, file, new ArrayList(), (Object)new NullPyCreateAction(), ps));
    }

    private void addCreateMethodOption(PySelection ps, IPyEdit edit, List<ICompletionProposalHandle> props, String markerContents, List<String> parametersAfterCall) {
        props.add(CompletionProposalFactory.get().createTddRefactorCompletion(markerContents, this.imageMethod, "Create " + markerContents + " method", null, null, 5, edit, 0, parametersAfterCall, (Object)new PyCreateMethodOrField(), ps));
    }

    private void addCreateClassOption(PySelection ps, IPyEdit edit, List<ICompletionProposalHandle> props, String markerContents, List<String> parametersAfterCall) {
        props.add(CompletionProposalFactory.get().createTddRefactorCompletion(markerContents, this.imageClass, "Create " + markerContents + " class", null, null, 5, edit, 0, parametersAfterCall, (Object)new PyCreateClass(), ps));
    }

    private ArrayList<IDefinition> findDefinitions(IPythonNature nature, IPyEdit edit, int start, IDocument doc) {
        CompletionState completionState = new CompletionState();
        ArrayList<IDefinition> selected = new ArrayList<IDefinition>();
        RefactoringRequest request = new RefactoringRequest(edit.getEditorFile(), new PySelection(doc, (ICoreTextSelection)new CoreTextSelection(doc, start, 0)), (IProgressMonitor)new NullProgressMonitor(), nature, edit);
        try {
            PyRefactoringFindDefinition.findActualDefinition((RefactoringRequest)request, (ICompletionState)completionState, selected);
        }
        catch (BadLocationException | CompletionRecursionException e1) {
            Log.log((Throwable)e1);
        }
        return selected;
    }
}

