/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.mypy;

import com.python.pydev.analysis.external.ExternalAnalizerProcessWatchDoc;
import com.python.pydev.analysis.external.IExternalAnalyzer;
import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import com.python.pydev.analysis.external.WriteToStreamHelper;
import com.python.pydev.analysis.mypy.MypyPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.ast.runners.SimplePythonRunner;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.core.CheckAnalysisErrors;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.process.ProcessUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.ArrayUtils;

final class MypyAnalysis
implements IExternalAnalyzer {
    private final IResource resource;
    private final IDocument fDocument;
    private final IPath location;
    private final Map<IResource, List<PyMarkerUtils.MarkerInfo>> fileToMarkers = new HashMap<IResource, List<PyMarkerUtils.MarkerInfo>>();
    private final IProgressMonitor monitor;
    private Thread processWatchDoc;
    private final File mypyLocation;
    private static Pattern MYPY_MATCH_PATTERN1 = Pattern.compile("\\A\\s*(.*)\\s*\\:\\s*(\\d+)\\s*\\:\\s*(\\d+)\\s*\\:\\s*(\\w+)\\s*\\:\\s*(.*)\\Z");
    private static Pattern MYPY_MATCH_PATTERN2 = Pattern.compile("\\A\\s*(.*)\\s*\\:\\s*(\\d+)()\\s*\\:\\s*(\\w+)\\s*\\:\\s*(.*)\\Z");

    public MypyAnalysis(IResource resource, IDocument document, IPath location, IProgressMonitor monitor, File mypyLocation) {
        this.resource = resource;
        this.fDocument = document;
        this.location = location;
        this.monitor = monitor;
        this.mypyLocation = mypyLocation;
    }

    void createMypyProcess(IExternalCodeAnalysisStream out) throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        ICallback0 launchProcessCallback;
        IProject project;
        String target = this.location.toOSString();
        ArrayList<String> cmdList = new ArrayList<String>();
        String userArgs = StringUtils.replaceNewLines((String)MypyPreferences.getMypyArgs((IAdaptable)this.resource), (String)" ");
        ArrayList<String> userArgsAsList = new ArrayList<String>(Arrays.asList(ProcessUtils.parseArguments((String)userArgs)));
        if (!userArgsAsList.contains("--show-column-numbers")) {
            userArgsAsList.add("--show-column-numbers");
        }
        boolean foundFollowImports = false;
        boolean foundCacheDir = false;
        for (String arg : userArgsAsList) {
            if (arg.startsWith("--follow-imports=silent")) {
                foundFollowImports = true;
            }
            if (!arg.startsWith("--cache-dir")) continue;
            foundCacheDir = true;
        }
        if (!foundFollowImports) {
            userArgsAsList.add("--follow-imports=silent");
        }
        if ((project = this.resource.getProject()) == null || !project.isAccessible()) {
            Log.log((String)("Unable to run mypy in: " + target + ". Project not available (" + String.valueOf(project) + ")."));
            return;
        }
        File workingDir = project.getLocation().toFile();
        if (!foundCacheDir) {
            userArgsAsList.add("--cache-dir=" + new File(workingDir, ".mypy_cache").toString());
        }
        cmdList.addAll(userArgsAsList);
        cmdList.add(target);
        PythonNature nature = PythonNature.getPythonNature((IProject)project);
        ICallback<String[], String[]> updateEnv = null;
        if (MypyPreferences.getAddProjectFoldersToMyPyPath((IAdaptable)this.resource)) {
            IModulesManager[] managersInvolved;
            HashSet<String> addToMypyPath = new HashSet<String>();
            IModulesManager[] iModulesManagerArray = managersInvolved = nature.getAstManager().getModulesManager().getManagersInvolved(false);
            int n = managersInvolved.length;
            int n2 = 0;
            while (n2 < n) {
                IModulesManager iModulesManager = iModulesManagerArray[n2];
                for (String s : iModulesManager.getNature().getPythonPathNature().getOnlyProjectPythonPathStr(true, true)) {
                    if (s.isEmpty()) continue;
                    addToMypyPath.add(s);
                }
                ++n2;
            }
            final String mypyPath = StringUtils.join((String)SimpleRunner.getPythonPathSeparator(), addToMypyPath);
            if (addToMypyPath.size() > 0) {
                WriteToStreamHelper.write("MyPy: Using MYPYPATH:", out, mypyPath);
                updateEnv = new ICallback<String[], String[]>(){

                    public String[] call(String[] arg) {
                        int i = 0;
                        while (i < arg.length) {
                            if (arg[i].startsWith("MYPYPATH=")) {
                                arg[i] = arg[i] + SimpleRunner.getPythonPathSeparator() + mypyPath;
                                return arg;
                            }
                            ++i;
                        }
                        return (String[])ArrayUtils.concatArrays((Object[][])new String[][]{arg, {"MYPYPATH=" + mypyPath}});
                    }
                };
            }
        }
        ICallback<String[], String[]> finalUpdateEnv = updateEnv;
        if (this.mypyLocation == null) {
            launchProcessCallback = () -> this.lambda$0((IPythonNature)nature, cmdList, out, workingDir, finalUpdateEnv);
        } else {
            String mypyExecutable = FileUtils.getFileAbsolutePath((File)this.mypyLocation);
            cmdList.add(0, mypyExecutable);
            launchProcessCallback = () -> MypyAnalysis.lambda$1(cmdList, out, workingDir, (IPythonNature)nature, finalUpdateEnv);
        }
        this.processWatchDoc = new ExternalAnalizerProcessWatchDoc(out, this.monitor, this, (ICallback0<Process>)launchProcessCallback, project, true);
        this.processWatchDoc.start();
    }

    @Override
    public void afterRunProcess(String output, String errors, IExternalCodeAnalysisStream out) {
        boolean resourceIsContainer = this.resource instanceof IContainer;
        IProject project = null;
        IFile moduleFile = null;
        if (resourceIsContainer) {
            project = this.resource.getProject();
            if (project == null) {
                Log.log((String)"Expected resource to have project for MyPyAnalysis.");
                return;
            }
            if (!project.isAccessible()) {
                Log.log((String)"Expected project to be accessible for MyPyAnalysis.");
                return;
            }
        } else if (this.resource instanceof IFile) {
            moduleFile = (IFile)this.resource;
        } else {
            return;
        }
        output = output.trim();
        errors = errors.trim();
        HashMap<ModuleLineCol, MessageInfo> moduleLineColToMessage = new HashMap<ModuleLineCol, MessageInfo>();
        if (!output.isEmpty()) {
            WriteToStreamHelper.write("Mypy: The stdout of the command line is:\n", out, output);
        }
        if (!errors.isEmpty()) {
            WriteToStreamHelper.write("Mypy: The stderr of the command line is:\n", out, errors);
        }
        if (this.logStream(output)) {
            RuntimeException e = new RuntimeException("Mypy ERROR: \n" + output);
            Log.log((Throwable)e);
            return;
        }
        if (this.logStream(errors)) {
            RuntimeException e = new RuntimeException("Mypy ERROR: \n" + errors);
            Log.log((Throwable)e);
            return;
        }
        FastStringBuffer fileNameBuf = new FastStringBuffer();
        String loc = this.location != null ? this.location.toString().toLowerCase() : null;
        String res = null;
        if (this.resource != null && this.resource.getFullPath() != null) {
            res = this.resource.getFullPath().toString().toLowerCase();
        }
        HashMap<IFile, IDocument> resourceToDocCache = new HashMap<IFile, IDocument>();
        for (String outputLine : StringUtils.iterLines((String)output)) {
            if (this.monitor.isCanceled()) {
                return;
            }
            try {
                String lineContents;
                IDocument document;
                outputLine = outputLine.trim();
                int column = -1;
                Matcher m = MYPY_MATCH_PATTERN1.matcher(outputLine);
                if (m.matches()) {
                    column = Integer.parseInt(outputLine.substring(m.start(3), m.end(3))) - 1;
                } else {
                    m = MYPY_MATCH_PATTERN2.matcher(outputLine);
                    if (m.matches()) {
                        column = 0;
                    } else {
                        m = null;
                    }
                }
                if (m == null) continue;
                if (resourceIsContainer) {
                    String relativeFilename = outputLine.substring(m.start(1), m.end(1));
                    try {
                        moduleFile = project.getFile((IPath)new Path(relativeFilename));
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                        continue;
                    }
                    document = (IDocument)resourceToDocCache.get(moduleFile);
                    if (document == null) {
                        document = FileUtils.getDocFromResource((IResource)moduleFile);
                        if (document == null) continue;
                        resourceToDocCache.put(moduleFile, document);
                    }
                } else {
                    document = this.fDocument;
                    fileNameBuf.clear();
                    fileNameBuf.append(outputLine.substring(m.start(1), m.end(1))).trim().replaceAll('\\', '/');
                    String fileName = fileNameBuf.toString().toLowerCase();
                    if (!(loc == null && res == null || loc != null && loc.contains(fileName) || res != null && res.contains(fileName))) continue;
                }
                int line = -1;
                String messageId = "";
                String message = "";
                int markerSeverity = -1;
                String severityFound = outputLine.substring(m.start(4), m.end(4)).trim();
                if (severityFound.equals("error")) {
                    markerSeverity = 2;
                }
                if (severityFound.equals("warning")) {
                    markerSeverity = 1;
                }
                if (severityFound.equals("note")) {
                    markerSeverity = 0;
                }
                if (markerSeverity == -1 || CheckAnalysisErrors.isCodeAnalysisErrorHandled((String)(lineContents = PySelection.getLine((IDocument)document, (int)(line = Integer.parseInt(outputLine.substring(m.start(2), m.end(2))) - 1))), null)) continue;
                messageId = "mypy";
                message = outputLine.substring(m.start(5), m.end(5)).trim();
                IRegion region = null;
                try {
                    region = document.getLineInformation(line);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (region == null || document == null) continue;
                ModuleLineCol moduleLineCol = new ModuleLineCol(moduleFile, line, column);
                MessageInfo messageInfo = (MessageInfo)moduleLineColToMessage.get(moduleLineCol);
                if (messageInfo == null) {
                    messageInfo = new MessageInfo(message, markerSeverity, messageId, line, column, document.get(region.getOffset(), region.getLength()), moduleFile, document);
                    moduleLineColToMessage.put(moduleLineCol, messageInfo);
                    continue;
                }
                messageInfo.addMessageLine(message);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        for (MessageInfo messageInfo : moduleLineColToMessage.values()) {
            this.addToMarkers(messageInfo.message.toString(), messageInfo.markerSeverity, messageInfo.messageId, messageInfo.line, messageInfo.column, messageInfo.docLineContents, messageInfo.moduleFile, messageInfo.document);
        }
    }

    private boolean logStream(String output) {
        return output.contains("Traceback (most recent call last):") || output.contains("mypy: error: unrecognized arguments:") && output.contains("usage:");
    }

    private void addToMarkers(String tok, int priority, String id, int line, int column, String lineContents, IFile moduleFile, IDocument document) {
        HashMap<String, String> additionalInfo = new HashMap<String, String>();
        additionalInfo.put("mypy_message_id", id);
        List<PyMarkerUtils.MarkerInfo> list = this.fileToMarkers.get(moduleFile);
        if (list == null) {
            list = new ArrayList<PyMarkerUtils.MarkerInfo>();
            this.fileToMarkers.put((IResource)moduleFile, list);
        }
        list.add(new PyMarkerUtils.MarkerInfo(document, "Mypy: " + tok, "org.python.pydev.mypyproblemmarker", priority, false, false, line, column, line, lineContents.length(), additionalInfo));
    }

    public List<PyMarkerUtils.MarkerInfo> getMarkers(IResource resource) {
        List<PyMarkerUtils.MarkerInfo> ret = this.fileToMarkers.get(resource);
        if (ret == null) {
            return new ArrayList<PyMarkerUtils.MarkerInfo>();
        }
        return new ArrayList<PyMarkerUtils.MarkerInfo>(ret);
    }

    @Override
    public void join() {
        if (this.processWatchDoc != null) {
            try {
                this.processWatchDoc.join();
            }
            catch (InterruptedException e) {
                Log.log((Throwable)e);
            }
        }
    }

    private /* synthetic */ Process lambda$0(IPythonNature iPythonNature, ArrayList arrayList, IExternalCodeAnalysisStream iExternalCodeAnalysisStream, File file, ICallback iCallback) {
        String interpreter;
        try {
            interpreter = iPythonNature.getProjectInterpreter().getExecutableOrJar();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        arrayList.add(0, "mypy");
        String[] args = arrayList.toArray(new String[0]);
        SimplePythonRunner runner = new SimplePythonRunner();
        String[] parameters = SimplePythonRunner.preparePythonCallParameters((String)interpreter, (String)"-m", (String[])args);
        WriteToStreamHelper.write("MyPy: Executing command line:", iExternalCodeAnalysisStream, StringUtils.join((String)" ", (String[])parameters));
        Tuple r = runner.run(parameters, file, iPythonNature, this.monitor, iCallback);
        return (Process)r.o1;
    }

    private static /* synthetic */ Process lambda$1(ArrayList arrayList, IExternalCodeAnalysisStream iExternalCodeAnalysisStream, File file, IPythonNature iPythonNature, ICallback iCallback) {
        String[] args = arrayList.toArray(new String[0]);
        WriteToStreamHelper.write("Mypy: Executing command line:", iExternalCodeAnalysisStream, new Object[]{args});
        SimpleRunner simpleRunner = new SimpleRunner();
        Tuple r = simpleRunner.run(args, file, iPythonNature, null, iCallback);
        Process process = (Process)r.o1;
        return process;
    }

    private static class MessageInfo {
        private final FastStringBuffer message = new FastStringBuffer();
        private final int markerSeverity;
        private final String messageId;
        private final int line;
        private final int column;
        private final String docLineContents;
        private final IFile moduleFile;
        private final IDocument document;

        public MessageInfo(String message, int markerSeverity, String messageId, int line, int column, String docLineContents, IFile moduleFile, IDocument document) {
            this.message.append(message);
            this.markerSeverity = markerSeverity;
            this.messageId = messageId;
            this.line = line;
            this.column = column;
            this.docLineContents = docLineContents;
            this.moduleFile = moduleFile;
            this.document = document;
        }

        public void addMessageLine(String message) {
            this.message.append('\n').append(message);
        }
    }

    private static class ModuleLineCol {
        private IFile moduleFile;
        private final int line;
        private final int col;

        public ModuleLineCol(IFile moduleFile, int line, int col) {
            this.moduleFile = moduleFile;
            this.line = line;
            this.col = col;
        }

        public int hashCode() {
            return Objects.hash(this.col, this.line, this.moduleFile);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleLineCol other = (ModuleLineCol)obj;
            return this.col == other.col && this.line == other.line && Objects.equals(this.moduleFile, other.moduleFile);
        }
    }
}

