/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.pylint;

import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import com.python.pydev.analysis.pylint.OnlyRemoveMarkersPyLintVisitor;
import com.python.pydev.analysis.pylint.PyLintAnalysis;
import com.python.pydev.analysis.pylint.PyLintPreferences;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.progress.NullProgressMonitorWrapper;

public final class PyLintVisitor
extends OnlyRemoveMarkersPyLintVisitor {
    private final IDocument document;
    private final IProgressMonitor monitor;
    private final Object lock = new Object();
    private PyLintAnalysis pyLintRunnable;

    PyLintVisitor(IResource resource, IDocument document, ICallback<IModule, Integer> module, IProgressMonitor monitor) {
        super(resource);
        this.document = document;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startVisit() {
        if (this.resource == null || !PyLintPreferences.usePyLint((IAdaptable)this.resource) || this.document == null && !(this.resource instanceof IContainer)) {
            this.deleteMarkers();
            return;
        }
        IProject project = this.resource.getProject();
        PythonNature pythonNature = PythonNature.getPythonNature((IProject)project);
        if (pythonNature == null) {
            this.deleteMarkers();
            return;
        }
        File pyLintLocation = null;
        if (!(PyLintPreferences.usePyLintFromPythonNature((IPythonNature)pythonNature, (IAdaptable)project) || (pyLintLocation = PyLintPreferences.getPyLintLocation((IPythonNature)pythonNature, (IAdaptable)this.resource)) != null && FileUtils.enhancedIsFile((File)pyLintLocation))) {
            Log.logInfo((String)("PyLint specified but location is not valid: " + String.valueOf(pyLintLocation)));
            this.deleteMarkers();
            return;
        }
        try {
            if (pythonNature.getInterpreterType() != 0) {
                this.deleteMarkers();
                return;
            }
        }
        catch (Exception e) {
            this.deleteMarkers();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.pyLintRunnable != null) {
                return;
            }
            if (project != null) {
                IContainer dir;
                IPath location;
                if (this.resource instanceof IFile) {
                    IFile file = (IFile)this.resource;
                    IPath location2 = file.getLocation();
                    if (location2 != null) {
                        this.pyLintRunnable = new PyLintAnalysis(this.resource, this.document, location2, (IProgressMonitor)new NullProgressMonitorWrapper(this.monitor), pyLintLocation);
                        try {
                            IExternalCodeAnalysisStream out = PyLintPreferences.getConsoleOutputStream((IAdaptable)this.resource);
                            this.pyLintRunnable.createPyLintProcess(out);
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                } else if (this.resource instanceof IContainer && (location = (dir = (IContainer)this.resource).getLocation()) != null) {
                    this.pyLintRunnable = new PyLintAnalysis(this.resource, null, location, (IProgressMonitor)new NullProgressMonitorWrapper(this.monitor), pyLintLocation);
                    try {
                        IExternalCodeAnalysisStream out = PyLintPreferences.getConsoleOutputStream((IAdaptable)this.resource);
                        this.pyLintRunnable.createPyLintProcess(out);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void join() {
        if (this.pyLintRunnable != null) {
            this.pyLintRunnable.join();
        }
    }

    @Override
    public List<PyMarkerUtils.MarkerInfo> getMarkers(IResource resource) {
        if (this.pyLintRunnable == null) {
            return null;
        }
        return this.pyLintRunnable.getMarkers(resource);
    }

    @Override
    public boolean getRequiresAnalysis() {
        return true;
    }
}

