/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.pyright;

import com.python.pydev.analysis.external.ExternalAnalizerProcessWatchDoc;
import com.python.pydev.analysis.external.IExternalAnalyzer;
import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import com.python.pydev.analysis.external.WriteToStreamHelper;
import com.python.pydev.analysis.pyright.PyrightPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.ast.location.FindWorkspaceFiles;
import org.python.pydev.ast.runners.SimplePythonRunner;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.core.CheckAnalysisErrors;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.json.eclipsesource.JsonArray;
import org.python.pydev.json.eclipsesource.JsonObject;
import org.python.pydev.json.eclipsesource.JsonValue;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.process.ProcessUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

final class PyrightAnalysis
implements IExternalAnalyzer {
    private final IResource resource;
    private final IDocument fDocument;
    private final IPath location;
    private final Map<IResource, List<PyMarkerUtils.MarkerInfo>> fileToMarkers = new HashMap<IResource, List<PyMarkerUtils.MarkerInfo>>();
    private final IProgressMonitor monitor;
    private Thread processWatchDoc;
    private final File pyrightLocation;

    public PyrightAnalysis(IResource resource, IDocument document, IPath location, IProgressMonitor monitor, File pyrightLocation) {
        this.resource = resource;
        this.fDocument = document;
        this.location = location;
        this.monitor = monitor;
        this.pyrightLocation = pyrightLocation;
    }

    void createPyrightProcess(IExternalCodeAnalysisStream out) throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        ICallback0 launchProcessCallback;
        IProject project;
        String target = this.location.toOSString();
        ArrayList<String> cmdList = new ArrayList<String>();
        String userArgs = StringUtils.replaceNewLines((String)PyrightPreferences.getPyrightArgs((IAdaptable)this.resource), (String)" ");
        ArrayList<String> userArgsAsList = new ArrayList<String>(Arrays.asList(ProcessUtils.parseArguments((String)userArgs)));
        if (!userArgsAsList.contains("--outputjson")) {
            userArgsAsList.add("--outputjson");
        }
        if ((project = this.resource.getProject()) == null || !project.isAccessible()) {
            Log.log((String)("Unable to run pyright in: " + target + ". Project not available (" + String.valueOf(project) + ")."));
            return;
        }
        File workingDir = project.getLocation().toFile();
        cmdList.addAll(userArgsAsList);
        cmdList.add(target);
        PythonNature nature = PythonNature.getPythonNature((IProject)project);
        if (this.pyrightLocation == null) {
            launchProcessCallback = () -> this.lambda$0((IPythonNature)nature, cmdList, out, workingDir);
        } else {
            String pyrightExecutable = FileUtils.getFileAbsolutePath((File)this.pyrightLocation);
            cmdList.add(0, pyrightExecutable);
            launchProcessCallback = () -> PyrightAnalysis.lambda$1(cmdList, out, workingDir, (IPythonNature)nature);
        }
        this.processWatchDoc = new ExternalAnalizerProcessWatchDoc(out, this.monitor, this, (ICallback0<Process>)launchProcessCallback, project, true);
        this.processWatchDoc.start();
    }

    @Override
    public void afterRunProcess(String output, String errors, IExternalCodeAnalysisStream out) {
        JsonValue jsonValue;
        boolean resourceIsContainer = this.resource instanceof IContainer;
        IProject project = null;
        IFile moduleFile = null;
        if (resourceIsContainer) {
            project = this.resource.getProject();
            if (project == null) {
                Log.log((String)"Expected resource to have project for PyrightAnalysis.");
                return;
            }
            if (!project.isAccessible()) {
                Log.log((String)"Expected project to be accessible for PyrightAnalysis.");
                return;
            }
        } else if (this.resource instanceof IFile) {
            moduleFile = (IFile)this.resource;
        } else {
            return;
        }
        output = output.trim();
        errors = errors.trim();
        HashMap<ModuleLineCol, MessageInfo> moduleLineColToMessage = new HashMap<ModuleLineCol, MessageInfo>();
        if (!output.isEmpty()) {
            WriteToStreamHelper.write("Pyright: The stdout of the command line is:\n", out, output);
        }
        if (!errors.isEmpty()) {
            WriteToStreamHelper.write("Pyright: The stderr of the command line is:\n", out, errors);
        }
        if (output.indexOf("Traceback (most recent call last):") != -1) {
            RuntimeException e = new RuntimeException("Pyright ERROR: \n" + output);
            Log.log((Throwable)e);
            return;
        }
        if (errors.indexOf("Traceback (most recent call last):") != -1) {
            RuntimeException e = new RuntimeException("Pyright ERROR: \n" + errors);
            Log.log((Throwable)e);
            return;
        }
        FastStringBuffer fileNameBuf = new FastStringBuffer();
        String loc = this.location != null ? this.location.toString().toLowerCase() : null;
        String res = null;
        if (this.resource != null && this.resource.getFullPath() != null) {
            res = this.resource.getFullPath().toString().toLowerCase();
        }
        if (output.isEmpty()) {
            return;
        }
        try {
            jsonValue = JsonValue.readFrom((String)output);
        }
        catch (Exception e) {
            Log.log((String)StringUtils.format((String)"Expected pyright output to be with json format. i.e.: --outputformat=json.\nFile: %s\nOutput:\n%s", (Object[])new Object[]{this.resource.getFullPath(), output}), (Throwable)e);
            return;
        }
        if (jsonValue == null) {
            Log.log((String)"Pyright output returned null json value!");
            return;
        }
        HashMap<IFile, IDocument> resourceToDocCache = new HashMap<IFile, IDocument>();
        if (!jsonValue.isObject()) {
            Log.log((String)"Expected pyright output to be a json object");
            return;
        }
        JsonObject asObject = jsonValue.asObject();
        JsonValue diagnostics = asObject.get("generalDiagnostics");
        if (diagnostics == null || !diagnostics.isArray()) {
            Log.log((String)"Expected pyright output to have diagnostics array");
            return;
        }
        JsonArray diagnosticsArray = diagnostics.asArray();
        for (JsonValue diagnosticValue : diagnosticsArray) {
            String lineContents;
            int markerSeverity;
            String messageId;
            String message;
            IDocument document;
            int endColumn;
            int endLine;
            int column;
            int line;
            block56: {
                JsonValue messageJson;
                if (this.monitor.isCanceled()) {
                    return;
                }
                if (!diagnosticValue.isObject()) {
                    Log.log((String)("Pyright: In diagnostics output, expected value to be an object. Found: " + String.valueOf(diagnosticValue)));
                    continue;
                }
                JsonObject diagnosticObject = diagnosticValue.asObject();
                JsonValue file = diagnosticObject.get("file");
                if (file == null || !file.isString()) {
                    Log.log((String)("Pyright: Expected file to be a string in: " + String.valueOf(diagnosticObject)));
                    continue;
                }
                JsonValue range = diagnosticObject.get("range");
                if (range == null || !range.isObject()) {
                    Log.log((String)("Pyright: Expected range to be an object in: " + String.valueOf(diagnosticObject)));
                    continue;
                }
                JsonObject rangeObject = range.asObject();
                JsonValue start = rangeObject.get("start");
                if (start == null || !start.isObject()) {
                    Log.log((String)("Pyright: Expected start to be an object in: " + String.valueOf(rangeObject)));
                    continue;
                }
                JsonObject startObject = start.asObject();
                JsonValue lineJson = startObject.get("line");
                if (lineJson == null || !lineJson.isNumber()) {
                    Log.log((String)("Pyright: Expected line to be a number. Found: " + String.valueOf(lineJson)));
                    continue;
                }
                line = lineJson.asInt();
                JsonValue columnJson = startObject.get("character");
                if (columnJson == null || !columnJson.isNumber()) {
                    Log.log((String)("Pyright: Expected character to be a number. Found: " + String.valueOf(columnJson)));
                    continue;
                }
                column = columnJson.asInt();
                JsonValue end = rangeObject.get("end");
                if (end == null || !end.isObject()) {
                    Log.log((String)("Pyright: Expected end to be an object in: " + String.valueOf(rangeObject)));
                    continue;
                }
                JsonObject endObject = end.asObject();
                JsonValue endLineJson = endObject.get("line");
                if (endLineJson == null || !endLineJson.isNumber()) {
                    Log.log((String)("Pyright: Expected end line to be a number. Found: " + String.valueOf(endLineJson)));
                    continue;
                }
                endLine = endLineJson.asInt();
                JsonValue endColumnJson = endObject.get("character");
                if (endColumnJson == null || !endColumnJson.isNumber()) {
                    Log.log((String)("Pyright: Expected end character to be a number. Found: " + String.valueOf(endColumnJson)));
                    continue;
                }
                endColumn = endColumnJson.asInt();
                if (resourceIsContainer) {
                    block55: {
                        try {
                            moduleFile = FindWorkspaceFiles.getFileForLocation((IPath)Path.fromOSString((String)file.asString()), (IProject)project);
                            if (moduleFile == null) {
                                Log.log((String)("Pyright: Could not find file for path: " + file.asString()));
                            }
                            break block55;
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                        continue;
                    }
                    document = (IDocument)resourceToDocCache.get(moduleFile);
                    if (document == null) {
                        document = FileUtils.getDocFromResource((IResource)moduleFile);
                        if (document == null) continue;
                        resourceToDocCache.put(moduleFile, document);
                    }
                } else {
                    document = this.fDocument;
                    IFile fileForLocation = FindWorkspaceFiles.getFileForLocation((IPath)Path.fromOSString((String)file.asString()), (IProject)project);
                    if (fileForLocation == null) {
                        Log.log((String)("Pyright: Could not find file for path: " + file.asString()));
                        continue;
                    }
                    fileNameBuf.clear();
                    fileNameBuf.append(file.asString()).trim().replaceAll('\\', '/');
                    String fileName = fileNameBuf.toString().toLowerCase();
                    if (!(loc == null && res == null || loc != null && loc.contains(fileName) || res != null && res.contains(fileName))) {
                        Log.log((String)("Pyright: Skipped file: " + fileName + " because it doesn't match the current one: " + res));
                        continue;
                    }
                }
                if ((messageJson = diagnosticObject.get("message")) == null || !messageJson.isString()) {
                    Log.log((String)("Pyright: expected message to be a string in: " + String.valueOf(diagnosticObject)));
                    continue;
                }
                message = messageJson.asString();
                messageId = "pyright";
                JsonValue ruleJson = diagnosticObject.get("rule");
                if (ruleJson != null && ruleJson.isString()) {
                    messageId = ruleJson.asString();
                }
                markerSeverity = 1;
                JsonValue severityJson = diagnosticObject.get("severity");
                if (severityJson == null || !severityJson.isString()) break block56;
                String severity = severityJson.asString();
                switch (severity.toLowerCase()) {
                    case "error": {
                        markerSeverity = 2;
                        break;
                    }
                    case "warning": {
                        markerSeverity = 1;
                        break;
                    }
                    case "information": {
                        markerSeverity = 0;
                        break;
                    }
                    default: {
                        markerSeverity = 1;
                    }
                }
            }
            if (CheckAnalysisErrors.isCodeAnalysisErrorHandled((String)(lineContents = PySelection.getLine((IDocument)document, (int)line)), null)) continue;
            IRegion region = null;
            try {
                region = document.getLineInformation(line);
                if (region == null || document == null) continue;
                ModuleLineCol moduleLineCol = new ModuleLineCol(moduleFile, line, column, endLine, endColumn);
                MessageInfo messageInfo = (MessageInfo)moduleLineColToMessage.get(moduleLineCol);
                if (messageInfo == null) {
                    messageInfo = new MessageInfo(message, markerSeverity, messageId, line, column, endLine, endColumn, document.get(region.getOffset(), region.getLength()), moduleFile, document);
                    moduleLineColToMessage.put(moduleLineCol, messageInfo);
                    continue;
                }
                messageInfo.addMessageLine(message);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        for (MessageInfo messageInfo : moduleLineColToMessage.values()) {
            this.addToMarkers(messageInfo.message.toString(), messageInfo.markerSeverity, messageInfo.messageId, messageInfo.line, messageInfo.column, messageInfo.endLine, messageInfo.endColumn, messageInfo.docLineContents, messageInfo.moduleFile, messageInfo.document);
        }
    }

    private void addToMarkers(String tok, int priority, String id, int line, int column, int endLine, int endColumn, String lineContents, IFile moduleFile, IDocument document) {
        HashMap<String, String> additionalInfo = new HashMap<String, String>();
        additionalInfo.put("pyright_message_id", id);
        List<PyMarkerUtils.MarkerInfo> list = this.fileToMarkers.get(moduleFile);
        if (list == null) {
            list = new ArrayList<PyMarkerUtils.MarkerInfo>();
            this.fileToMarkers.put((IResource)moduleFile, list);
        }
        list.add(new PyMarkerUtils.MarkerInfo(document, "Pyright: " + tok, "org.python.pydev.pyrightproblemmarker", priority, false, false, line, column, endLine, endColumn, additionalInfo));
    }

    public List<PyMarkerUtils.MarkerInfo> getMarkers(IResource resource) {
        List<PyMarkerUtils.MarkerInfo> ret = this.fileToMarkers.get(resource);
        if (ret == null) {
            return new ArrayList<PyMarkerUtils.MarkerInfo>();
        }
        return new ArrayList<PyMarkerUtils.MarkerInfo>(ret);
    }

    @Override
    public void join() {
        if (this.processWatchDoc != null) {
            try {
                this.processWatchDoc.join();
            }
            catch (InterruptedException e) {
                Log.log((Throwable)e);
            }
        }
    }

    private /* synthetic */ Process lambda$0(IPythonNature iPythonNature, ArrayList arrayList, IExternalCodeAnalysisStream iExternalCodeAnalysisStream, File file) {
        String interpreter;
        try {
            interpreter = iPythonNature.getProjectInterpreter().getExecutableOrJar();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        arrayList.add(0, "pyright");
        String[] args = arrayList.toArray(new String[0]);
        WriteToStreamHelper.write("Pyright: Executing command line:", iExternalCodeAnalysisStream, "python", "-m", args);
        SimplePythonRunner runner = new SimplePythonRunner();
        String[] parameters = SimplePythonRunner.preparePythonCallParameters((String)interpreter, (String)"-m", (String[])args);
        Tuple r = runner.run(parameters, file, iPythonNature, this.monitor, null);
        return (Process)r.o1;
    }

    private static /* synthetic */ Process lambda$1(ArrayList arrayList, IExternalCodeAnalysisStream iExternalCodeAnalysisStream, File file, IPythonNature iPythonNature) {
        String[] args = arrayList.toArray(new String[0]);
        WriteToStreamHelper.write("Pyright: Executing command line:", iExternalCodeAnalysisStream, new Object[]{args});
        SimpleRunner simpleRunner = new SimpleRunner();
        Tuple r = simpleRunner.run(args, file, iPythonNature, null, null);
        Process process = (Process)r.o1;
        return process;
    }

    private static class MessageInfo {
        private final FastStringBuffer message = new FastStringBuffer();
        private final int markerSeverity;
        private final String messageId;
        private final int line;
        private final int column;
        private final int endLine;
        private final int endColumn;
        private final String docLineContents;
        private final IFile moduleFile;
        private final IDocument document;

        public MessageInfo(String message, int markerSeverity, String messageId, int line, int column, int endLine, int endColumn, String docLineContents, IFile moduleFile, IDocument document) {
            this.message.append(message);
            this.markerSeverity = markerSeverity;
            this.messageId = messageId;
            this.line = line;
            this.column = column;
            this.endLine = endLine;
            this.endColumn = endColumn;
            this.docLineContents = docLineContents;
            this.moduleFile = moduleFile;
            this.document = document;
        }

        public void addMessageLine(String message) {
            this.message.append('\n').append(message);
        }
    }

    private static class ModuleLineCol {
        private IFile moduleFile;
        private final int line;
        private final int col;
        private final int endLine;
        private final int endCol;

        public ModuleLineCol(IFile moduleFile, int line, int col, int endLine, int endCol) {
            this.moduleFile = moduleFile;
            this.line = line;
            this.col = col;
            this.endLine = endLine;
            this.endCol = endCol;
        }

        public int hashCode() {
            return Objects.hash(this.col, this.endCol, this.endLine, this.line, this.moduleFile);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleLineCol other = (ModuleLineCol)obj;
            return this.col == other.col && this.endCol == other.endCol && this.endLine == other.endLine && this.line == other.line && Objects.equals(this.moduleFile, other.moduleFile);
        }
    }
}

