/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.pyright;

import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import com.python.pydev.analysis.pyright.OnlyRemoveMarkersPyrightVisitor;
import com.python.pydev.analysis.pyright.PyrightAnalysis;
import com.python.pydev.analysis.pyright.PyrightPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.markers.PyMarkerUtils;
import org.python.pydev.shared_core.progress.NullProgressMonitorWrapper;

public final class PyrightVisitor
extends OnlyRemoveMarkersPyrightVisitor {
    private IDocument document;
    private IProgressMonitor monitor;
    private final Object lock = new Object();
    private PyrightAnalysis pyrightRunnable;

    PyrightVisitor(IResource resource, IDocument document, ICallback<IModule, Integer> module, IProgressMonitor monitor) {
        super(resource);
        this.document = document;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startVisit() {
        if (this.resource == null || !PyrightPreferences.usePyright((IAdaptable)this.resource) || this.document == null && !(this.resource instanceof IContainer)) {
            this.deleteMarkers();
            return;
        }
        IProject project = this.resource.getProject();
        PythonNature pythonNature = PythonNature.getPythonNature((IProject)project);
        if (pythonNature == null) {
            this.deleteMarkers();
            return;
        }
        File pyrightLocation = null;
        if (!(PyrightPreferences.usePyrightFromPythonNature((IPythonNature)pythonNature, (IAdaptable)project) || (pyrightLocation = PyrightPreferences.getPyrightLocation(pythonNature)) != null && FileUtils.enhancedIsFile((File)pyrightLocation))) {
            if (pyrightLocation == null) {
                Log.log((String)("Unable to find pyright. Project: " + project.getName()));
            } else {
                Log.log((String)("pyright location does not exist: " + String.valueOf(pyrightLocation)));
            }
            this.deleteMarkers();
            return;
        }
        try {
            if (pythonNature.getInterpreterType() != 0) {
                this.deleteMarkers();
                return;
            }
        }
        catch (Exception e) {
            this.deleteMarkers();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.pyrightRunnable != null) {
                return;
            }
            if (project != null) {
                IContainer dir;
                IPath location;
                if (this.resource instanceof IFile) {
                    IFile file = (IFile)this.resource;
                    IPath location2 = file.getLocation();
                    if (location2 != null) {
                        this.pyrightRunnable = new PyrightAnalysis(this.resource, this.document, location2, (IProgressMonitor)new NullProgressMonitorWrapper(this.monitor), pyrightLocation);
                        try {
                            IExternalCodeAnalysisStream out = PyrightPreferences.getConsoleOutputStream((IAdaptable)project);
                            this.pyrightRunnable.createPyrightProcess(out);
                        }
                        catch (Exception e) {
                            Log.log((Throwable)e);
                        }
                    }
                } else if (this.resource instanceof IContainer && (location = (dir = (IContainer)this.resource).getLocation()) != null) {
                    this.pyrightRunnable = new PyrightAnalysis(this.resource, null, location, (IProgressMonitor)new NullProgressMonitorWrapper(this.monitor), pyrightLocation);
                    try {
                        IExternalCodeAnalysisStream out = PyrightPreferences.getConsoleOutputStream((IAdaptable)project);
                        this.pyrightRunnable.createPyrightProcess(out);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void join() {
        if (this.pyrightRunnable != null) {
            this.pyrightRunnable.join();
        }
    }

    @Override
    public List<PyMarkerUtils.MarkerInfo> getMarkers(IResource resource) {
        ArrayList<PyMarkerUtils.MarkerInfo> ret = new ArrayList<PyMarkerUtils.MarkerInfo>();
        if (this.pyrightRunnable == null) {
            return ret;
        }
        return this.pyrightRunnable.getMarkers(resource);
    }

    @Override
    public boolean getRequiresAnalysis() {
        return true;
    }
}

