/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.refactoring.quick_fixes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.ReplaceEdit;
import org.python.pydev.core.docutils.ImportHandle;
import org.python.pydev.core.docutils.ImportNotRecognizedException;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PyDocIterator;
import org.python.pydev.core.docutils.PyImportsHandling;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class AddTokenAndImportStatement {
    private IDocument document;
    private char trigger;
    private final int offset;
    private boolean addLocalImport;
    private boolean addLocalImportsOnTopOfMethod;
    private boolean groupImports;
    private int maxCols;
    private PySelection selection;
    private PySelection.LineStartingScope previousLineThatStartsScope = null;
    private PySelection ps = null;
    private List<ImportHandle> importHandles;
    private String delimiter;
    private Integer lineForFutureImport;
    private Integer lineForNonFutureImport;
    private Tuple<String, Integer> localImportsLocation;

    public AddTokenAndImportStatement(IDocument document, char trigger, int offset, boolean addLocalImport, boolean addLocalImportsOnTopOfMethod, boolean groupImports, int maxCols) {
        this.selection = new PySelection(document);
        if (addLocalImport) {
            this.ps = new PySelection(document, offset);
            int startLineIndex = this.ps.getStartLineIndex();
            if (startLineIndex == 0) {
                addLocalImport = false;
            } else {
                String[] indentTokens = PySelection.INDENT_TOKENS;
                if (addLocalImportsOnTopOfMethod) {
                    indentTokens = PySelection.FUNC_TOKEN;
                }
                this.previousLineThatStartsScope = this.ps.getPreviousLineThatStartsScope(indentTokens, startLineIndex - 1, PySelection.getFirstCharPosition((String)this.ps.getCursorLineContents()));
                if (this.previousLineThatStartsScope == null) {
                    addLocalImport = false;
                }
            }
        }
        this.document = document;
        this.trigger = trigger;
        this.offset = offset;
        this.addLocalImport = addLocalImport;
        this.addLocalImportsOnTopOfMethod = addLocalImportsOnTopOfMethod;
        this.groupImports = groupImports;
        this.maxCols = maxCols;
    }

    public PySelection.LineStartingScope getPreviousLineThatStartsScope() {
        return this.previousLineThatStartsScope;
    }

    public void createTextEdit(ComputedInfo computedInfo) {
        try {
            boolean isWithStatement;
            if (computedInfo.realImportRep.length() > 0 && (isWithStatement = computedInfo.realImportRep.equals("from __future__ import with_statement"))) {
                computedInfo.fReplacementString = "with";
            }
            String delimiter = this.getDelimiter();
            computedInfo.appliedWithTrigger = this.trigger == '.' || this.trigger == '(';
            String appendForTrigger = "";
            if (computedInfo.appliedWithTrigger) {
                if (this.trigger == '(') {
                    appendForTrigger = "()";
                } else if (this.trigger == '.') {
                    appendForTrigger = ".";
                }
            }
            if (computedInfo.fReplacementString.length() > 0) {
                int dif = this.offset - computedInfo.fReplacementOffset;
                computedInfo.replace(this.offset - dif, dif + computedInfo.fLen, computedInfo.fReplacementString + appendForTrigger);
            }
            if (this.addLocalImport && computedInfo.realImportRep.length() > 0 && this.addAsLocalImport(this.previousLineThatStartsScope, this.ps, delimiter, computedInfo, this.addLocalImportsOnTopOfMethod)) {
                return;
            }
            int lineToAddImport = -1;
            ImportHandle.ImportHandleInfo groupInto = null;
            ImportHandle.ImportHandleInfo realImportHandleInfo = null;
            if (computedInfo.realImportRep.length() > 0) {
                if (this.groupImports) {
                    try {
                        realImportHandleInfo = new ImportHandle.ImportHandleInfo(computedInfo.realImportRep);
                        Iterator<ImportHandle> it = this.createimportsHandlingIterator();
                        block4: while (it.hasNext()) {
                            ImportHandle handle = it.next();
                            if (handle.contains(realImportHandleInfo)) {
                                lineToAddImport = -2;
                                break;
                            }
                            if (groupInto != null || realImportHandleInfo.getFromImportStr() == null) continue;
                            List handleImportInfo = handle.getImportInfo();
                            for (ImportHandle.ImportHandleInfo importHandleInfo : handleImportInfo) {
                                if (realImportHandleInfo.getFromImportStr() == null || !realImportHandleInfo.getFromImportStrWithoutUnwantedChars().equals(importHandleInfo.getFromImportStrWithoutUnwantedChars())) continue;
                                groupInto = importHandleInfo;
                                continue block4;
                            }
                        }
                    }
                    catch (ImportNotRecognizedException e1) {
                        Log.log((Throwable)e1);
                    }
                }
                if (lineToAddImport == -1) {
                    boolean isFutureImport = PySelection.isFutureImportLine((String)computedInfo.realImportRep);
                    lineToAddImport = this.getLineAvailableForImport(isFutureImport);
                }
            } else {
                lineToAddImport = -1;
            }
            if (groupInto != null && realImportHandleInfo != null) {
                int endLineNum = groupInto.getEndLine();
                String endLineWithoutComment = PySelection.getLineWithoutCommentsOrLiterals((String)PySelection.getLine((IDocument)this.document, (int)endLineNum));
                String endLineTrimmedWithoutComment = endLineWithoutComment.trim();
                FastStringBuffer lastImportLineBuf = new FastStringBuffer();
                lastImportLineBuf.append(endLineWithoutComment).rightTrim();
                int lastImportLineNum = endLineNum;
                if (endLineNum != groupInto.getStartLine()) {
                    String penultLineWithoutComment = PySelection.getLineWithoutCommentsOrLiterals((String)TextSelectionUtils.getLine((IDocument)this.document, (int)(endLineNum - 1)));
                    if (")".equals(endLineTrimmedWithoutComment)) {
                        lastImportLineBuf.clear().append(penultLineWithoutComment);
                        --lastImportLineNum;
                    } else if (endLineTrimmedWithoutComment.isEmpty() && penultLineWithoutComment.trim().endsWith("\\")) {
                        lastImportLineBuf.clear().append(penultLineWithoutComment).rightTrim().deleteLast();
                        --lastImportLineNum;
                    }
                }
                int lastImportLineLen = lastImportLineBuf.length();
                if (lastImportLineBuf.endsWith(')') || lastImportLineBuf.endsWith('\\')) {
                    lastImportLineBuf.deleteLast();
                }
                int replaceOffset = TextSelectionUtils.getAbsoluteCursorOffset((IDocument)this.document, (int)lastImportLineNum, (int)lastImportLineBuf.length());
                replaceOffset -= lastImportLineBuf.length() - lastImportLineBuf.rightTrim().length();
                while (lastImportLineBuf.endsWith(',')) {
                    --replaceOffset;
                    lastImportLineBuf.deleteLast();
                }
                String strToAdd = ", " + (String)realImportHandleInfo.getImportedStr().get(0);
                if (lastImportLineLen + strToAdd.length() > this.maxCols) {
                    strToAdd = endLineTrimmedWithoutComment.endsWith(")") ? "," + delimiter + computedInfo.indentString + (String)realImportHandleInfo.getImportedStr().get(0) : ",\\" + delimiter + computedInfo.indentString + (String)realImportHandleInfo.getImportedStr().get(0);
                    computedInfo.importLen = strToAdd.length();
                    computedInfo.replace(replaceOffset, 0, strToAdd);
                    return;
                }
                computedInfo.importLen = strToAdd.length();
                computedInfo.replace(replaceOffset, 0, strToAdd);
                return;
            }
            if (lineToAddImport >= 0 && lineToAddImport <= this.document.getNumberOfLines()) {
                IRegion lineInformation = this.document.getLineInformation(lineToAddImport);
                String strToAdd = computedInfo.realImportRep + delimiter;
                computedInfo.importLen = strToAdd.length();
                computedInfo.replace(lineInformation.getOffset(), 0, strToAdd);
                return;
            }
        }
        catch (BadLocationException x) {
            Log.log((Throwable)x);
        }
    }

    private String getDelimiter() {
        if (this.delimiter == null) {
            this.delimiter = PySelection.getDelimiter((IDocument)this.document);
        }
        return this.delimiter;
    }

    private int getLineAvailableForImport(boolean isFutureImport) {
        if (isFutureImport) {
            if (this.lineForFutureImport == null) {
                this.lineForFutureImport = this.selection.getLineAvailableForImport(isFutureImport);
            }
            return this.lineForFutureImport;
        }
        if (this.lineForNonFutureImport == null) {
            this.lineForNonFutureImport = this.selection.getLineAvailableForImport(isFutureImport);
        }
        return this.lineForNonFutureImport;
    }

    private Iterator<ImportHandle> createimportsHandlingIterator() {
        if (this.importHandles == null) {
            PyImportsHandling importsHandling = new PyImportsHandling(this.document);
            this.importHandles = new ArrayList<ImportHandle>();
            importsHandling.forEach(this.importHandles::add);
        }
        return this.importHandles.iterator();
    }

    private boolean addAsLocalImport(PySelection.LineStartingScope previousLineThatStartsScope, PySelection ps, String delimiter, ComputedInfo computedInfo, boolean addLocalImportsOnTopOfMethod) {
        block5: {
            block6: {
                if (previousLineThatStartsScope == null) break block5;
                if (this.localImportsLocation == null) {
                    this.localImportsLocation = AddTokenAndImportStatement.computeLocalImportsLocation(ps, previousLineThatStartsScope, addLocalImportsOnTopOfMethod);
                }
                if (this.localImportsLocation != null) break block6;
                return false;
            }
            try {
                String indent = (String)this.localImportsLocation.o1;
                int iLine = (Integer)this.localImportsLocation.o2;
                String strToAdd = indent + computedInfo.realImportRep + delimiter;
                Tuple offsetAndContents = PySelection.getOffsetAndContentsToAddLine((IDocument)ps.getDoc(), (String)ps.getEndLineDelim(), (String)strToAdd, (int)(iLine - 1));
                if (offsetAndContents != null) {
                    computedInfo.replace((Integer)offsetAndContents.o1, 0, (String)offsetAndContents.o2);
                }
                computedInfo.importLen = strToAdd.length();
                return true;
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return false;
    }

    private static Tuple<String, Integer> computeLocalImportsLocation(PySelection ps, PySelection.LineStartingScope previousLineThatStartsScope, boolean addLocalImportsOnTopOfMethod) throws SyntaxErrorException {
        int iLineStartingScope = previousLineThatStartsScope.iLineStartingScope;
        PySelection.InsideParenthesisInfo insideParenthesisInfo = new PySelection(ps.getDoc(), iLineStartingScope, 0).getInsideParentesisToks(false);
        if (insideParenthesisInfo != null) {
            int cursorOffset = ps.getAbsoluteCursorOffset();
            if (cursorOffset < insideParenthesisInfo.closeParenthesisOffset) {
                return null;
            }
            iLineStartingScope = ps.getLineOfOffset(insideParenthesisInfo.closeParenthesisOffset);
        }
        int iLine = iLineStartingScope + 1;
        String line = ps.getLine(iLine);
        int startLineIndex = ps.getStartLineIndex();
        while (iLine < startLineIndex && (line.startsWith("#") || line.trim().length() == 0)) {
            line = ps.getLine(++iLine);
        }
        if (iLine >= startLineIndex) {
            iLine = startLineIndex;
            line = ps.getLine(iLine);
        }
        String indent = line.substring(0, PySelection.getFirstCharPosition((String)line));
        if (addLocalImportsOnTopOfMethod) {
            if (iLine < startLineIndex) {
                String line2 = ps.getLine(iLine);
                String trimmed = line2.trim();
                if (trimmed.startsWith("'") || trimmed.startsWith("\"")) {
                    int lineOfOffset;
                    ParsingUtils parsingUtils = ParsingUtils.create((Object)ps.getDoc());
                    int index = line2.indexOf("'");
                    int index2 = line2.indexOf("\"");
                    int use = index < 0 ? index2 : (index2 < 0 ? index : Math.min(index, index2));
                    int newOffset = parsingUtils.eatLiterals(null, ps.getAbsoluteCursorOffset(iLine, use));
                    iLine = lineOfOffset = ps.getLineOfOffset(newOffset) + 1;
                }
                int j = iLine;
                while (j < startLineIndex) {
                    line2 = ps.getLine(j);
                    trimmed = line2.trim();
                    if (trimmed.length() == 0) {
                        ++j;
                        continue;
                    }
                    if (!PySelection.isImportLine((String)trimmed)) break;
                    PyDocIterator docIterator = new PyDocIterator(ps.getDoc(), true, true, false, false);
                    docIterator.setStartingOffset(ps.getLineOffset(j));
                    String str = docIterator.next();
                    if (str.contains("(")) {
                        while (docIterator.hasNext()) {
                            if (str.contains(")")) {
                                j = docIterator.getLastReturnedLine() + 1;
                                break;
                            }
                            str = docIterator.next();
                        }
                    } else if (StringUtils.endsWith((String)str.trim(), (char)'\\')) {
                        while (docIterator.hasNext()) {
                            if (!StringUtils.endsWith((String)str.trim(), (char)'\\')) {
                                j = docIterator.getLastReturnedLine() + 1;
                                break;
                            }
                            str = docIterator.next();
                        }
                    }
                    iLine = ++j;
                }
                line = ps.getLine(iLine);
            }
        } else {
            int firstCharPos = PySelection.getFirstCharPosition((String)line);
            int j = startLineIndex;
            while (j >= 0) {
                String line2 = ps.getLine(j);
                if (PySelection.getFirstCharPosition((String)line2) == firstCharPos) {
                    iLine = j;
                    break;
                }
                if (j == iLineStartingScope) break;
                --j;
            }
        }
        return new Tuple((Object)indent, (Object)iLine);
    }

    public static class ComputedInfo {
        public final IDocument document;
        public final String realImportRep;
        public final int fReplacementOffset;
        public final int fLen;
        public final String indentString;
        public String fReplacementString;
        public boolean appliedWithTrigger;
        public int importLen;
        public List<ReplaceEdit> replaceEdit = new ArrayList<ReplaceEdit>(2);

        public ComputedInfo(String realImportRep, int fReplacementOffset, int fLen, String indentString, String fReplacementString, boolean appliedWithTrigger, int importLen, IDocument document) {
            this.realImportRep = realImportRep;
            this.fReplacementOffset = fReplacementOffset;
            this.fLen = fLen;
            this.indentString = indentString;
            this.fReplacementString = fReplacementString;
            this.appliedWithTrigger = appliedWithTrigger;
            this.importLen = importLen;
            this.document = document;
        }

        public void replace(int offset, int length, String text) {
            try {
                this.replaceEdit.add(new ReplaceEdit(offset, length, text));
            }
            catch (Exception e) {
                Log.log((String)("Error trying to create ReplaceEdit with offset: " + offset + " len: " + length + " text: " + text), (Throwable)e);
            }
        }
    }
}

