/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.refactoring.wizards.rename;

import com.python.pydev.analysis.refactoring.changes.PyRenameResourceChange;
import com.python.pydev.analysis.refactoring.wizards.IRefactorRenameProcess;
import com.python.pydev.analysis.refactoring.wizards.rename.AbstractRenameRefactorProcess;
import com.python.pydev.analysis.refactoring.wizards.rename.IRefactorCustomEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.python.pydev.ast.codecompletion.revisited.modules.ASTEntryWithSourceModule;
import org.python.pydev.ast.location.FindWorkspaceFiles;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public abstract class TextEditCreation {
    protected String inputName;
    protected String initialName;
    protected String moduleName;
    private IDocument currentDoc;
    private List<IRefactorRenameProcess> processes;
    private RefactoringStatus status;
    private Map<Tuple<String, File>, HashSet<ASTEntry>> fileOccurrences;
    private HashSet<ASTEntry> docOccurrences;
    private IFile currentFile;
    public static ICallback<IFile, File> createWorkspaceFile;
    private static final int AST_ENTRIES_FILTER_TEXT = 1;
    private static final int AST_ENTRIES_FILTER_FILE = 2;

    public TextEditCreation(String initialName, String inputName, String moduleName, IDocument currentDoc, List<IRefactorRenameProcess> processes, RefactoringStatus status, IFile currentFile) {
        Assert.isNotNull((Object)inputName);
        this.initialName = initialName;
        this.inputName = inputName;
        this.moduleName = moduleName;
        this.currentDoc = currentDoc;
        this.processes = processes;
        this.status = status;
        this.currentFile = currentFile;
    }

    public void fillRefactoringChangeObject(RefactoringRequest request, CheckConditionsContext context) {
        for (IRefactorRenameProcess p : this.processes) {
            if (this.status.hasFatalError() || request.getMonitor().isCanceled()) break;
            HashSet<ASTEntry> occurrences = p.getOccurrences();
            if (this.docOccurrences == null) {
                this.docOccurrences = occurrences;
            } else {
                this.docOccurrences.addAll(occurrences);
            }
            Map<Tuple<String, File>, HashSet<ASTEntry>> occurrencesInOtherFiles = p.getOccurrencesInOtherFiles();
            if (this.fileOccurrences == null) {
                this.fileOccurrences = occurrencesInOtherFiles;
                continue;
            }
            for (Map.Entry<Tuple<String, File>, HashSet<ASTEntry>> entry : new HashMap<Tuple<String, File>, HashSet<ASTEntry>>(occurrencesInOtherFiles).entrySet()) {
                HashSet<ASTEntry> set = occurrencesInOtherFiles.get(entry.getKey());
                if (set == null) {
                    occurrencesInOtherFiles.put(entry.getKey(), entry.getValue());
                    continue;
                }
                set.addAll((Collection<ASTEntry>)entry.getValue());
            }
        }
        this.createCurrModuleChange(request);
        this.createOtherFileChanges(request);
    }

    private void createOtherFileChanges(RefactoringRequest request) {
        for (Map.Entry<Tuple<String, File>, HashSet<ASTEntry>> entry : this.fileOccurrences.entrySet()) {
            Tuple<String, File> tup = entry.getKey();
            IFile workspaceFile = null;
            IPath path = null;
            Document doc = null;
            if (!SharedCorePlugin.inTestMode()) {
                IProject project = null;
                IPythonNature nature = request.nature;
                if (nature != null) {
                    project = nature.getProject();
                }
                if ((workspaceFile = FindWorkspaceFiles.getWorkspaceFile((File)((File)tup.o2), (IProject)project)) == null) {
                    this.status.addWarning(StringUtils.format((String)"Error. Unable to resolve the file:\n%s\nto a file in the Eclipse workspace.", (Object[])new Object[]{tup.o2}));
                    continue;
                }
                path = workspaceFile.getFullPath();
            } else {
                path = Path.fromOSString((String)((File)tup.o2).getAbsolutePath());
                doc = new Document(FileUtils.getFileContents((File)((File)tup.o2)));
                workspaceFile = (IFile)createWorkspaceFile.call((Object)((File)tup.o2));
            }
            HashSet<ASTEntry> astEntries = this.filterAstEntries(entry.getValue(), 1);
            if (astEntries.size() > 0) {
                if (doc == null) {
                    doc = FileUtilsFileBuffer.getDocFromResource((IResource)workspaceFile);
                }
                List<Tuple<List<TextEdit>, String>> renameEdits = this.getAllRenameEdits((IDocument)doc, astEntries, path, request.nature);
                if (this.status.hasFatalError()) {
                    return;
                }
                if (renameEdits.size() > 0) {
                    Tuple<TextChange, MultiTextEdit> textFileChange = this.getTextFileChange(workspaceFile, (IDocument)doc);
                    TextChange docChange = (TextChange)textFileChange.o1;
                    MultiTextEdit rootEdit = (MultiTextEdit)textFileChange.o2;
                    this.fillEditsInDocChange(docChange, rootEdit, renameEdits);
                }
            }
            if ((astEntries = this.filterAstEntries(entry.getValue(), 2)).size() <= 0) continue;
            IFile resourceToRename = workspaceFile;
            String newName = this.inputName;
            if (((String)tup.o1).endsWith(".__init__") && !this.initialName.equals("__init__")) {
                resourceToRename = resourceToRename.getParent();
                newName = this.inputName;
                if (!resourceToRename.getName().equals(FullRepIterable.getLastPart((String)this.initialName))) {
                    this.status.addFatalError(StringUtils.format((String)"Error. The package that was found (%s) for renaming does not match the initial token found (%s)", (Object[])new Object[]{resourceToRename.getName(), this.initialName}));
                    return;
                }
            }
            this.createResourceChange((IResource)resourceToRename, newName, request);
        }
    }

    protected abstract PyRenameResourceChange createResourceChange(IResource var1, String var2, RefactoringRequest var3);

    protected abstract Tuple<TextChange, MultiTextEdit> getTextFileChange(IFile var1, IDocument var2);

    private HashSet<ASTEntry> filterAstEntries(HashSet<ASTEntry> value, int astEntryFilter) {
        HashSet<ASTEntry> ret = new HashSet<ASTEntry>();
        for (ASTEntry entry : value) {
            if (entry instanceof ASTEntryWithSourceModule) {
                if ((astEntryFilter & 2) == 0) continue;
                ret.add(entry);
                continue;
            }
            if ((astEntryFilter & 1) == 0) continue;
            ret.add(entry);
        }
        return ret;
    }

    private void createCurrModuleChange(RefactoringRequest request) {
        if (this.docOccurrences.size() == 0 && !request.isModuleRenameRefactoringRequest()) {
            this.status.addFatalError("No occurrences found.");
            return;
        }
        Tuple<TextChange, MultiTextEdit> textFileChange = this.getTextFileChange(this.currentFile, this.currentDoc);
        TextChange docChange = (TextChange)textFileChange.o1;
        MultiTextEdit rootEdit = (MultiTextEdit)textFileChange.o2;
        List<Tuple<List<TextEdit>, String>> renameEdits = this.getAllRenameEdits(this.currentDoc, this.docOccurrences, this.currentFile != null ? this.currentFile.getFullPath() : null, request.nature);
        if (this.status.hasFatalError()) {
            return;
        }
        if (renameEdits.size() > 0) {
            this.fillEditsInDocChange(docChange, rootEdit, renameEdits);
        }
    }

    private void fillEditsInDocChange(TextChange docChange, MultiTextEdit rootEdit, List<Tuple<List<TextEdit>, String>> renameEdits) {
        Assert.isTrue((renameEdits.size() > 0 ? 1 : 0) != 0);
        for (Tuple<List<TextEdit>, String> t : renameEdits) {
            TextEdit[] arr = ((List)t.o1).toArray(new TextEdit[((List)t.o1).size()]);
            rootEdit.addChildren(arr);
            docChange.addTextEditGroup(new TextEditGroup((String)t.o2, arr));
        }
    }

    protected TextEdit createRenameEdit(int offset) {
        return new ReplaceEdit(offset, this.initialName.length(), this.inputName);
    }

    protected List<Tuple<List<TextEdit>, String>> getAllRenameEdits(IDocument doc, HashSet<ASTEntry> occurrences, IPath workspaceFile, IPythonNature nature) {
        HashSet<Integer> s = new HashSet<Integer>();
        ArrayList<Tuple<List<TextEdit>, String>> ret = new ArrayList<Tuple<List<TextEdit>, String>>();
        FastStringBuffer entryBuf = new FastStringBuffer();
        for (ASTEntry entry : occurrences) {
            entryBuf.clear();
            Integer loc = (Integer)entry.getAdditionalInfo("AST_ENTRY_FOUND_LOCATION", (Object)0);
            if (loc == 2) {
                entryBuf.append("Change (comment): ");
            } else if (loc == 1) {
                entryBuf.append("Change (string): ");
            } else {
                entryBuf.append("Change: ");
            }
            entryBuf.appendObject((Object)this.initialName);
            entryBuf.append(" >> ");
            entryBuf.appendObject((Object)this.inputName);
            entryBuf.append(" (line:");
            entryBuf.append(entry.node.beginLine);
            entryBuf.append(")");
            int offset = AbstractRenameRefactorProcess.getOffset(doc, entry);
            if (s.contains(offset)) continue;
            s.add(offset);
            if (entry instanceof IRefactorCustomEntry) {
                IRefactorCustomEntry iRefactorCustomEntry = (IRefactorCustomEntry)entry;
                List<TextEdit> edits = iRefactorCustomEntry.createRenameEdit(doc, this.initialName, this.inputName, this.status, workspaceFile, nature);
                ret.add((Tuple<List<TextEdit>, String>)new Tuple(edits, (Object)entryBuf.toString()));
                entry.setAdditionalInfo("AST_ENTRY_REPLACE_EDIT", edits);
                if (!this.status.hasFatalError()) continue;
                return ret;
            }
            TextEditCreation.checkExpectedInput(doc, entry.node.beginLine, offset, this.initialName, this.status, workspaceFile);
            if (this.status.hasFatalError()) {
                return ret;
            }
            List<TextEdit> edits = Arrays.asList(this.createRenameEdit(offset));
            entry.setAdditionalInfo("AST_ENTRY_REPLACE_EDIT", edits);
            ret.add((Tuple<List<TextEdit>, String>)new Tuple(edits, (Object)entryBuf.toString()));
        }
        return ret;
    }

    public static void checkExpectedInput(IDocument doc, int line, int offset, String initialName, RefactoringStatus status, IPath workspaceFile) {
        try {
            String string = doc.get(offset, initialName.length());
            if (!string.equals(initialName)) {
                status.addFatalError(StringUtils.format((String)"Error: file %s changed during analysis.\nExpected doc to contain: '%s' and it contained: '%s' at offset: %s (line: %s).", (Object[])new Object[]{workspaceFile != null ? workspaceFile : "has", initialName, string, offset, line}));
                return;
            }
        }
        catch (BadLocationException e) {
            status.addFatalError(StringUtils.format((String)"Error: file %s changed during analysis.\nExpected doc to contain: '%s' at offset: %s (line: %s).", (Object[])new Object[]{workspaceFile != null ? workspaceFile : "has", initialName, offset, line}));
        }
    }
}

