/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.ruff;

import com.python.pydev.analysis.external.IExternalCodeAnalysisStream;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.preferences.PyScopedPreferences;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;

public class RuffPreferences {
    public static final String RUFF_FILE_LOCATION = "RUFF_FILE_LOCATION";
    public static final String USE_RUFF = "USE_RUFF";
    public static final boolean DEFAULT_USE_RUFF = false;
    public static final String RUFF_USE_CONSOLE = "RUFF_USE_CONSOLE";
    public static final boolean DEFAULT_RUFF_USE_CONSOLE = false;
    public static final String SEARCH_RUFF_LOCATION = "SEARCH_RUFF_LOCATION";
    public static final String LOCATION_SEARCH = "SEARCH";
    public static final String LOCATION_SPECIFY = "SPECIFY";
    public static final String DEFAULT_SEARCH_RUFF_LOCATION = "SEARCH";
    public static final String RUFF_ARGS = "RUFF_ARGS";
    public static final String DEFAULT_RUFF_ARGS = "";
    public static ICallback<IExternalCodeAnalysisStream, IAdaptable> createRuffStream = projectAdaptable -> null;

    public static boolean useRuff(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getBoolean((String)USE_RUFF, (IAdaptable)projectAdaptable);
    }

    public static boolean useRuffConsole(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getBoolean((String)RUFF_USE_CONSOLE, (IAdaptable)projectAdaptable);
    }

    public static String getRuffArgs(IAdaptable projectAdaptable) {
        return PyScopedPreferences.getString((String)RUFF_ARGS, (IAdaptable)projectAdaptable);
    }

    public static boolean useRuffFromPythonNature(IPythonNature pythonNature, IAdaptable projectAdaptable) {
        return !LOCATION_SPECIFY.equals(PyScopedPreferences.getString((String)SEARCH_RUFF_LOCATION, (IAdaptable)projectAdaptable));
    }

    public static File getRuffLocation(PythonNature pythonNature) {
        IProject project = pythonNature.getProject();
        if (LOCATION_SPECIFY.equals(PyScopedPreferences.getString((String)SEARCH_RUFF_LOCATION, (IAdaptable)project))) {
            return new File(PyScopedPreferences.getString((String)RUFF_FILE_LOCATION, (IAdaptable)project));
        }
        return null;
    }

    public static IExternalCodeAnalysisStream getConsoleOutputStream(IAdaptable projectAdaptable) throws MalformedURLException {
        return (IExternalCodeAnalysisStream)createRuffStream.call((Object)projectAdaptable);
    }
}

