/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.scopeanalysis;

import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.analysis.visitors.GenAndTok;
import com.python.pydev.analysis.visitors.Scope;
import com.python.pydev.analysis.visitors.ScopeItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.codecompletion.revisited.CompletionCache;
import org.python.pydev.ast.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.ast.codecompletion.revisited.visitors.AssignOrTypeAliasDefinition;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.ast.codecompletion.revisited.visitors.LocalScope;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.TupleN;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.AugAssign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Dict;
import org.python.pydev.parser.jython.ast.DictComp;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Global;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Lambda;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.SetComp;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.StringToIntCounterSmallSet;
import org.python.pydev.shared_core.utils.ArrayUtils;

public abstract class AbstractScopeAnalyzerVisitor
extends VisitorBase {
    public boolean futureAnnotationsImported = false;
    public final IPythonNature nature;
    public final String moduleName;
    public final Scope scope;
    protected final List<Found> probablyNotDefined = new ArrayList<Found>();
    public final IModule current;
    protected final IProgressMonitor monitor;
    protected final IDocument document;
    public final ICompletionCache completionCache;
    private final LocalScope currentLocalScope;
    private final Set<String> builtinTokens = new HashSet<String>();
    protected int isInMatchScope = 0;
    private int visitingAttributeStackI = 0;
    private StringToIntCounterSmallSet visitingAttributeStack = null;
    private final StringToIntCounterSmallSet visitingAttributeStackCache = new StringToIntCounterSmallSet();

    public AbstractScopeAnalyzerVisitor(IPythonNature nature, String moduleName, IModule current, IDocument document, IProgressMonitor monitor) {
        this.monitor = monitor;
        this.current = current;
        this.nature = nature;
        this.currentLocalScope = new LocalScope(nature, current);
        this.moduleName = moduleName;
        this.document = document;
        this.scope = new Scope(this, nature, moduleName);
        if (current instanceof SourceModule) {
            this.currentLocalScope.getScopeStack().push((Object)((SourceModule)current).getAst());
        }
        this.startScope(1, null);
        ICompletionState completionState = CompletionStateFactory.getEmptyCompletionState((IPythonNature)nature, (ICompletionCache)new CompletionCache());
        this.completionCache = completionState;
        TokensList builtinCompletions = nature.getAstManager().getBuiltinCompletions(completionState, new TokensList());
        if (moduleName != null && moduleName.endsWith("__init__")) {
            builtinCompletions.addAll(new TokensList((IToken)new SourceToken((SimpleNode)new Name("__path__", 1, false), "__path__", "", "", moduleName, nature, current)));
        }
        for (IterTokenEntry entry : builtinCompletions) {
            IToken t = entry.getToken();
            Found found = this.makeFound(t);
            org.python.pydev.shared_core.structure.Tuple tup = new org.python.pydev.shared_core.structure.Tuple((Object)t, (Object)found);
            this.addToNamesToIgnore(t, this.scope.getCurrScopeItems(), (org.python.pydev.shared_core.structure.Tuple<IToken, Found>)tup);
            this.builtinTokens.add(t.getRepresentation());
        }
    }

    protected void checkStop() {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        this.checkStop();
        return null;
    }

    public void traverse(SimpleNode node) throws Exception {
        this.checkStop();
        node.traverse((VisitorIF)this);
    }

    public Object visitCall(Call callNode) throws Exception {
        int i;
        if (callNode.func != null) {
            this.onVisitCallFunc(callNode);
        }
        if (callNode.args != null) {
            i = 0;
            while (i < callNode.args.length) {
                if (callNode.args[i] != null) {
                    callNode.args[i].accept((VisitorIF)this);
                }
                ++i;
            }
        }
        if (callNode.keywords != null) {
            i = 0;
            while (i < callNode.keywords.length) {
                if (callNode.keywords[i] != null) {
                    callNode.keywords[i].accept((VisitorIF)this);
                }
                ++i;
            }
        }
        if (callNode.starargs != null) {
            callNode.starargs.accept((VisitorIF)this);
        }
        if (callNode.kwargs != null) {
            callNode.kwargs.accept((VisitorIF)this);
        }
        return null;
    }

    protected void onVisitCallFunc(Call callNode) throws Exception {
        callNode.func.accept((VisitorIF)this);
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        int i;
        this.unhandled_node((SimpleNode)node);
        AbstractScopeAnalyzerVisitor visitor = this;
        this.handleDecorators(node.decs);
        if (node.type_params != null) {
            node.type_params.accept((VisitorIF)visitor);
        }
        if (node.bases != null) {
            i = 0;
            while (i < node.bases.length) {
                if (node.bases[i] != null) {
                    node.bases[i].accept((VisitorIF)visitor);
                }
                ++i;
            }
        }
        this.currentLocalScope.getScopeStack().push((Object)node);
        this.startScope(4, (SimpleNode)node);
        if (node.name != null) {
            node.name.accept((VisitorIF)visitor);
        }
        if (node.body != null) {
            i = 0;
            while (i < node.body.length) {
                if (node.body[i] != null) {
                    node.body[i].accept((VisitorIF)visitor);
                }
                ++i;
            }
        }
        if (node.keywords != null) {
            i = 0;
            while (i < node.keywords.length) {
                if (node.keywords[i] != null) {
                    node.keywords[i].accept((VisitorIF)visitor);
                }
                ++i;
            }
        }
        this.endScope((SimpleNode)node);
        this.currentLocalScope.getScopeStack().pop();
        this.addToNamesToIgnore((SimpleNode)node, true, true);
        return null;
    }

    protected void addToNamesToIgnore(SimpleNode node, boolean finishClassScope, boolean checkBuiltins) {
        String rep;
        SourceToken token = AbstractVisitor.makeToken((SimpleNode)node, (String)"", (IPythonNature)this.nature, (IModule)this.current);
        if (checkBuiltins && this.checkCurrentScopeForAssignmentsToBuiltins() && this.builtinTokens.contains(rep = token.getRepresentation())) {
            this.onAddAssignmentToBuiltinMessage((IToken)token, rep);
        }
        ScopeItems currScopeItems = this.scope.getCurrScopeItems();
        Found found = new Found((IToken)token, (IToken)token, this.scope.getCurrScopeId(), this.scope.getCurrScopeItems());
        org.python.pydev.shared_core.structure.Tuple tup = new org.python.pydev.shared_core.structure.Tuple((Object)token, (Object)found);
        this.addToNamesToIgnore((IToken)token, currScopeItems, (org.python.pydev.shared_core.structure.Tuple<IToken, Found>)tup);
        Iterator<Found> it = this.probablyNotDefined.iterator();
        while (it.hasNext()) {
            IToken tok;
            String firstPart;
            Found n = it.next();
            GenAndTok single = n.getSingle();
            ScopeItems scopeFound = single.scopeFound;
            int foundScopeType = scopeFound.getScopeType();
            int globalClassOrMethodScopeType = scopeFound.globalClassOrMethodScopeType;
            if ((globalClassOrMethodScopeType & 0x12) != 0 && this.scope.getCurrScopeItems().getScopeType() == 4 || !(firstPart = FullRepIterable.getFirstPart((String)(tok = single.tok).getRepresentation())).equals(token.getRepresentation())) continue;
            if (finishClassScope && this.scope.getCurrScopeId() < scopeFound.getScopeId() && foundScopeType != 64 && !this.futureAnnotationsImported && (globalClassOrMethodScopeType == 4 || foundScopeType == 32) && (globalClassOrMethodScopeType & 0x12) == 0) {
                it.remove();
                this.onAddUndefinedMessage(tok, found);
                continue;
            }
            it.remove();
            this.onNotDefinedFoundLater(n, found);
        }
    }

    private boolean checkCurrentScopeForAssignmentsToBuiltins() {
        return this.scope.getCurrScopeItems().getScopeType() != 4;
    }

    protected void addToNamesToIgnore(IToken token, ScopeItems currScopeItems, org.python.pydev.shared_core.structure.Tuple<IToken, Found> tup) {
        currScopeItems.namesToIgnore.put(token.getRepresentation(), tup);
        this.onAfterAddToNamesToIgnore(currScopeItems, tup);
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        exprType[] exprTypeArray;
        exprType expr;
        int n;
        int n2;
        exprType[] exprTypeArray2;
        this.unhandled_node((SimpleNode)node);
        this.addToNamesToIgnore((SimpleNode)node, false, true);
        AbstractScopeAnalyzerVisitor visitor = this;
        argumentsType args = node.args;
        if (args.defaults != null) {
            exprTypeArray2 = args.defaults;
            n2 = args.defaults.length;
            n = 0;
            while (n < n2) {
                expr = exprTypeArray2[n];
                if (expr != null) {
                    expr.accept((VisitorIF)visitor);
                }
                ++n;
            }
        }
        if (args.kw_defaults != null) {
            exprTypeArray2 = args.kw_defaults;
            n2 = args.kw_defaults.length;
            n = 0;
            while (n < n2) {
                expr = exprTypeArray2[n];
                if (expr != null) {
                    expr.accept((VisitorIF)visitor);
                }
                ++n;
            }
        }
        ArrayUtils.ArraysIterator it = new ArrayUtils.ArraysIterator();
        it.addArray((Object[])args.kwonlyargannotation);
        it.addArray((Object[])args.annotation);
        if (args.varargannotation != null) {
            it.addArray((Object[])new exprType[]{args.varargannotation});
        }
        if (args.kwargannotation != null) {
            it.addArray((Object[])new exprType[]{args.kwargannotation});
        }
        if (node.returns != null) {
            it.addArray((Object[])new exprType[]{node.returns});
        }
        if (it.hasNext()) {
            int scopeType = 32;
            if (this.futureAnnotationsImported || !this.scope.isInGobalScope()) {
                scopeType = 64;
            }
            SimpleNode dummyNode = new SimpleNode();
            this.startScope(scopeType, dummyNode);
            if (node.type_params != null) {
                node.type_params.accept((VisitorIF)visitor);
            }
            while (it.hasNext()) {
                exprType expr2 = (exprType)it.next();
                if (expr2 == null) continue;
                expr2.accept((VisitorIF)visitor);
            }
            this.endScope(dummyNode);
        }
        this.handleDecorators(node.decs);
        this.startScope(2, (SimpleNode)node);
        this.currentLocalScope.getScopeStack().push((Object)node);
        if (node.type_params != null) {
            node.type_params.accept((VisitorIF)visitor);
        }
        this.scope.isInMethodDefinition = true;
        if (args.args != null) {
            exprTypeArray = args.args;
            int n3 = args.args.length;
            int n4 = 0;
            while (n4 < n3) {
                exprType expr3 = exprTypeArray[n4];
                expr3.accept((VisitorIF)visitor);
                ++n4;
            }
        }
        if (args.vararg != null) {
            args.vararg.accept((VisitorIF)visitor);
        }
        if (args.kwarg != null) {
            args.kwarg.accept((VisitorIF)visitor);
        }
        if (args.kwonlyargs != null) {
            exprTypeArray = args.kwonlyargs;
            int n5 = args.kwonlyargs.length;
            int n6 = 0;
            while (n6 < n5) {
                exprType expr4 = exprTypeArray[n6];
                if (expr4 != null) {
                    expr4.accept((VisitorIF)visitor);
                }
                ++n6;
            }
        }
        this.scope.isInMethodDefinition = false;
        if (node.body != null) {
            int i = 0;
            while (i < node.body.length) {
                if (node.body[i] != null) {
                    node.body[i].accept((VisitorIF)visitor);
                }
                ++i;
            }
        }
        this.endScope((SimpleNode)node);
        this.currentLocalScope.getScopeStack().pop();
        return null;
    }

    protected void handleDecorators(decoratorsType[] decs) throws Exception {
        if (decs != null) {
            decoratorsType[] decoratorsTypeArray = decs;
            int n = decs.length;
            int n2 = 0;
            while (n2 < n) {
                decoratorsType dec = decoratorsTypeArray[n2];
                if (dec != null) {
                    this.handleDecorator(dec);
                }
                ++n2;
            }
        }
    }

    protected void handleDecorator(decoratorsType dec) throws Exception {
        dec.accept((VisitorIF)this);
    }

    public Object visitLambda(Lambda node) throws Exception {
        exprType expr;
        int n;
        int n2;
        exprType[] exprTypeArray;
        this.unhandled_node((SimpleNode)node);
        AbstractScopeAnalyzerVisitor visitor = this;
        argumentsType args = node.args;
        if (args.defaults != null) {
            exprTypeArray = args.defaults;
            n2 = args.defaults.length;
            n = 0;
            while (n < n2) {
                expr = exprTypeArray[n];
                if (expr != null) {
                    expr.accept((VisitorIF)visitor);
                }
                ++n;
            }
        }
        this.startScope(16, (SimpleNode)node);
        this.scope.isInMethodDefinition = true;
        if (args.args != null) {
            exprTypeArray = args.args;
            n2 = args.args.length;
            n = 0;
            while (n < n2) {
                expr = exprTypeArray[n];
                expr.accept((VisitorIF)visitor);
                ++n;
            }
        }
        if (args.vararg != null) {
            args.vararg.accept((VisitorIF)visitor);
        }
        if (args.kwarg != null) {
            args.kwarg.accept((VisitorIF)visitor);
        }
        if (args.kwonlyargs != null) {
            exprTypeArray = args.kwonlyargs;
            n2 = args.kwonlyargs.length;
            n = 0;
            while (n < n2) {
                expr = exprTypeArray[n];
                expr.accept((VisitorIF)visitor);
                ++n;
            }
        }
        this.scope.isInMethodDefinition = false;
        if (node.body != null) {
            node.body.accept((VisitorIF)visitor);
        }
        this.endScope((SimpleNode)node);
        return null;
    }

    public Object visitNameTok(NameTok nameTok) throws Exception {
        this.unhandled_node((SimpleNode)nameTok);
        if (nameTok.ctx == 5 || nameTok.ctx == 6 || nameTok.ctx == 11 || nameTok.ctx == 12) {
            SourceToken token = AbstractVisitor.makeToken((SimpleNode)nameTok, (String)this.moduleName, (IPythonNature)this.nature, (IModule)this.current);
            this.scope.addToken((IToken)token, (IToken)token, nameTok.id);
            if (this.checkCurrentScopeForAssignmentsToBuiltins() && this.builtinTokens.contains(token.getRepresentation())) {
                this.onAddAssignmentToBuiltinMessage((IToken)token, token.getRepresentation());
            }
        }
        return null;
    }

    public Object visitAugAssign(AugAssign node) throws Exception {
        return super.visitAugAssign(node);
    }

    public Object visitImport(Import node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        List list = AbstractVisitor.makeImportToken((Import)node, null, (String)this.moduleName, (boolean)true, (IPythonNature)this.nature, (IModule)this.current);
        if (this.checkCurrentScopeForAssignmentsToBuiltins()) {
            for (IToken token : list) {
                if (!this.builtinTokens.contains(token.getRepresentation())) continue;
                this.onAddAssignmentToBuiltinMessage(token, token.getRepresentation());
            }
        }
        this.scope.addImportTokens(new TokensList((Collection)list), null, this.completionCache);
        return null;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        try {
            if (AbstractVisitor.isWildImport((ImportFrom)node)) {
                IToken wildImport = AbstractVisitor.makeWildImportToken((ImportFrom)node, null, (String)this.moduleName, (IPythonNature)this.nature, (IModule)this.current);
                ICompletionState state = CompletionStateFactory.getEmptyCompletionState((IPythonNature)this.nature, (ICompletionCache)this.completionCache);
                state.setBuiltinsGotten(true);
                TokensList completionsForWildImport = new TokensList();
                if (this.nature.getAstManager().getCompletionsForWildImport(state, this.current, completionsForWildImport, wildImport)) {
                    this.scope.addImportTokens(completionsForWildImport, wildImport, this.completionCache);
                }
            } else {
                List list = AbstractVisitor.makeImportToken((ImportFrom)node, null, (String)this.moduleName, (boolean)true, (IPythonNature)this.nature, (IModule)this.current);
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    IToken token = (IToken)listIterator.next();
                    if (!"__future__.annotations".equals(token.getOriginalRep())) continue;
                    listIterator.remove();
                    this.futureAnnotationsImported = true;
                    break;
                }
                this.scope.addImportTokens(new TokensList((Collection)list), null, this.completionCache);
            }
        }
        catch (Exception e) {
            Log.log((int)4, (String)("Error when analyzing module " + this.moduleName), (Throwable)e);
        }
        return null;
    }

    public Object visitName(Name node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        SourceToken token = AbstractVisitor.makeToken((SimpleNode)node, (String)this.moduleName, (IPythonNature)this.nature, (IModule)this.current);
        boolean found = true;
        if (node.ctx == 1 || node.ctx == 3 || node.ctx == 5) {
            found = this.markRead((IToken)token);
        }
        if (node.ctx == 2 || node.ctx == 9 || node.ctx == 6 || node.ctx == 8 || node.ctx == 5 && found) {
            org.python.pydev.shared_core.structure.Tuple<IToken, Found> foundInNamesToIgnore;
            String rep = token.getRepresentation();
            if (this.checkCurrentScopeForAssignmentsToBuiltins() && this.isInMatchScope == 0 && this.builtinTokens.contains(rep)) {
                this.onAddAssignmentToBuiltinMessage((IToken)token, rep);
            }
            if ((foundInNamesToIgnore = this.findInNamesToIgnore(rep, (IToken)token)) == null) {
                if (!rep.equals("self") && !rep.equals("cls")) {
                    this.scope.addToken((IToken)token, (IToken)token);
                    if (node.ctx == 9) {
                        this.markRead((IToken)token);
                    }
                } else {
                    this.addToNamesToIgnore((SimpleNode)node, false, false);
                }
            }
        }
        return token;
    }

    protected org.python.pydev.shared_core.structure.Tuple<IToken, Found> findInNamesToIgnore(String rep, IToken token) {
        org.python.pydev.shared_core.structure.Tuple<IToken, Found> found = this.scope.findInNamesToIgnore(rep);
        return found;
    }

    public Object visitGlobal(Global node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        NameTokType[] nameTokTypeArray = node.names;
        int n = node.names.length;
        int n2 = 0;
        while (n2 < n) {
            NameTokType name = nameTokTypeArray[n2];
            Name nameAst = new Name(((NameTok)name).id, 2, false);
            nameAst.beginLine = name.beginLine;
            nameAst.beginColumn = name.beginColumn;
            SourceToken token = AbstractVisitor.makeToken((SimpleNode)nameAst, (String)this.moduleName, (IPythonNature)this.nature, (IModule)this.current);
            this.scope.addTokenToGlobalScope((IToken)token);
            this.addToNamesToIgnore((SimpleNode)nameAst, false, true);
            ++n2;
        }
        return null;
    }

    public Object visitAttribute(Attribute node) throws Exception {
        SourceToken token = AbstractVisitor.makeFullNameToken((SimpleNode)node, (String)this.moduleName, (IPythonNature)this.nature, (IModule)this.current);
        this.unhandled_node((SimpleNode)node);
        ++this.visitingAttributeStackI;
        if (this.visitingAttributeStackI == 1) {
            this.visitingAttributeStack = this.visitingAttributeStackCache;
        }
        String representation = token.getRepresentation();
        int curr = this.visitingAttributeStack.increment(representation);
        try {
            boolean doReturn = AbstractScopeAnalyzerVisitor.visitNeededAttributeParts(node, this);
            if (representation.length() == 0) {
                return null;
            }
            if (doReturn) {
                return null;
            }
            String fullRep = representation;
            if (node.ctx == 2 || node.ctx == 9 || node.ctx == 6 || node.ctx == 8 || node.ctx == 5) {
                int i = fullRep.indexOf(46, 0);
                String sub = fullRep;
                if (i > 0) {
                    sub = fullRep.substring(0, i);
                }
                this.markRead((IToken)token, sub, true, false);
            } else if (node.ctx == 1) {
                Iterator it = new FullRepIterable(fullRep).iterator();
                boolean found = false;
                while (it.hasNext()) {
                    String sub = (String)it.next();
                    if (it.hasNext()) {
                        if (!this.markRead((IToken)token, sub, false, false)) continue;
                        found = true;
                        continue;
                    }
                    boolean addToNotDefined = !found && this.visitingAttributeStack.get(representation) == curr;
                    this.markRead((IToken)token, fullRep, addToNotDefined, true);
                }
            }
        }
        finally {
            --this.visitingAttributeStackI;
            if (this.visitingAttributeStackI == 0) {
                this.visitingAttributeStack.clear();
                this.visitingAttributeStack = null;
            }
        }
        return null;
    }

    public static boolean visitNeededAttributeParts(Attribute node, VisitorBase base) throws Exception {
        exprType value = node.value;
        boolean valueVisited = false;
        boolean doReturn = false;
        if (value instanceof Subscript) {
            Subscript subs = (Subscript)value;
            base.traverse((SimpleNode)subs.slice);
            if (subs.value instanceof Name) {
                base.visitName((Name)subs.value);
            } else {
                base.traverse((SimpleNode)subs.value);
            }
            doReturn = true;
        } else if (value instanceof Call) {
            AbstractScopeAnalyzerVisitor.visitCallAttr((Call)value, base);
            valueVisited = true;
        } else if (value instanceof Tuple) {
            base.visitTuple((Tuple)value);
            valueVisited = true;
        } else if (value instanceof Dict) {
            base.visitDict((Dict)value);
            doReturn = true;
        }
        if (!doReturn && !valueVisited && AbstractScopeAnalyzerVisitor.visitNeededValues(value, base)) {
            doReturn = true;
        }
        return doReturn;
    }

    protected static boolean visitNeededValues(exprType value, VisitorBase base) throws Exception {
        if (value instanceof Name) {
            return false;
        }
        if (value instanceof Attribute) {
            return AbstractScopeAnalyzerVisitor.visitNeededValues(((Attribute)value).value, base);
        }
        if (value != null) {
            value.accept((VisitorIF)base);
        }
        return true;
    }

    protected static void visitCallAttr(Call c, VisitorBase base) throws Exception {
        int i;
        VisitorBase visitor = base;
        if (c.func instanceof Attribute) {
            base.visitAttribute((Attribute)c.func);
        }
        if (c.args != null) {
            i = 0;
            while (i < c.args.length) {
                if (c.args[i] != null) {
                    c.args[i].accept((VisitorIF)visitor);
                }
                ++i;
            }
        }
        if (c.keywords != null) {
            i = 0;
            while (i < c.keywords.length) {
                if (c.keywords[i] != null) {
                    c.keywords[i].accept((VisitorIF)visitor);
                }
                ++i;
            }
        }
        if (c.starargs != null) {
            c.starargs.accept((VisitorIF)visitor);
        }
        if (c.kwargs != null) {
            c.kwargs.accept((VisitorIF)visitor);
        }
    }

    public Object visitFor(For node) throws Exception {
        this.scope.addStatementSubScope();
        Object ret = super.visitFor(node);
        this.scope.removeStatementSubScope();
        return ret;
    }

    public Object visitAssign(Assign node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        if (node.value != null) {
            node.value.accept((VisitorIF)this);
        }
        if (node.type != null) {
            int scopeType = 32;
            if (this.futureAnnotationsImported || !this.scope.isInGobalScope()) {
                scopeType = 64;
            }
            this.startScope(scopeType, (SimpleNode)node.type);
            node.type.accept((VisitorIF)this);
            this.endScope((SimpleNode)node.type);
        }
        if (node.value == null) {
            ++this.scope.inAssignWithoutValue;
        }
        if (node.targets != null) {
            int i = 0;
            while (i < node.targets.length) {
                if (node.targets[i] != null) {
                    node.targets[i].accept((VisitorIF)this);
                }
                ++i;
            }
        }
        if (node.value == null) {
            --this.scope.inAssignWithoutValue;
        }
        this.onAfterVisitAssign(node);
        return null;
    }

    public Object visitIf(If node) throws Exception {
        this.scope.addIfSubScope(node);
        Object r = super.visitIf(node);
        this.scope.removeIfSubScope();
        return r;
    }

    public Object visitWhile(While node) throws Exception {
        this.scope.addStatementSubScope();
        Object r = super.visitWhile(node);
        this.scope.removeStatementSubScope();
        return r;
    }

    public Object visitTryExcept(TryExcept node) throws Exception {
        this.scope.addTryExceptSubScope(node);
        Object r = super.visitTryExcept(node);
        this.scope.removeTryExceptSubScope();
        return r;
    }

    public Object visitTryFinally(TryFinally node) throws Exception {
        this.scope.addStatementSubScope();
        Object r = super.visitTryFinally(node);
        this.scope.removeStatementSubScope();
        return r;
    }

    public Object visitDictComp(DictComp node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        if (node.generators != null) {
            int i = 0;
            while (i < node.generators.length) {
                if (node.generators[i] != null) {
                    node.generators[i].accept((VisitorIF)this);
                }
                ++i;
            }
        }
        if (node.key != null) {
            node.key.accept((VisitorIF)this);
        }
        if (node.value != null) {
            node.value.accept((VisitorIF)this);
        }
        return null;
    }

    public Object visitSetComp(SetComp node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        if (node.generators != null) {
            int i = 0;
            while (i < node.generators.length) {
                if (node.generators[i] != null) {
                    node.generators[i].accept((VisitorIF)this);
                }
                ++i;
            }
        }
        if (node.elt != null) {
            node.elt.accept((VisitorIF)this);
        }
        return null;
    }

    public Object visitListComp(ListComp node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        if (node.ctx == 2) {
            this.startScope(8, (SimpleNode)node);
        }
        try {
            Comprehension type = null;
            if (node.generators != null && node.generators.length > 0) {
                type = (Comprehension)node.generators[0];
            }
            ArrayList<exprType> eltsToVisit = new ArrayList<exprType>();
            if (type != null && type.iter instanceof ListComp) {
                ListComp listComp = (ListComp)type.iter;
                if (listComp.ctx == 2) {
                    this.startScope(8, (SimpleNode)listComp);
                }
                try {
                    this.visitListCompGenerators(listComp, eltsToVisit);
                    for (exprType type2 : eltsToVisit) {
                        type2.accept((VisitorIF)this);
                    }
                }
                finally {
                    if (listComp.ctx == 2) {
                        this.endScope((SimpleNode)listComp);
                    }
                }
                type.target.accept((VisitorIF)this);
                if (node.elt != null) {
                    node.elt.accept((VisitorIF)this);
                }
                return null;
            }
            if (node.generators != null) {
                int i = 0;
                while (i < node.generators.length) {
                    if (node.generators[i] != null) {
                        node.generators[i].accept((VisitorIF)this);
                    }
                    ++i;
                }
            }
            if (node.elt instanceof ListComp) {
                this.visitListCompGenerators((ListComp)node.elt, eltsToVisit);
                for (exprType type2 : eltsToVisit) {
                    type2.accept((VisitorIF)this);
                }
                return null;
            }
            if (node.elt != null) {
                node.elt.accept((VisitorIF)this);
            }
            return null;
        }
        finally {
            if (node.ctx == 2) {
                this.endScope((SimpleNode)node);
            }
        }
    }

    private void visitListCompGenerators(ListComp node, List<exprType> eltsToVisit) throws Exception {
        comprehensionType[] comprehensionTypeArray = node.generators;
        int n = node.generators.length;
        int n2 = 0;
        while (n2 < n) {
            comprehensionType c = comprehensionTypeArray[n2];
            Comprehension comp = (Comprehension)c;
            if (node.elt instanceof ListComp) {
                this.visitListCompGenerators((ListComp)node.elt, eltsToVisit);
                comp.accept((VisitorIF)this);
            } else {
                comp.accept((VisitorIF)this);
                eltsToVisit.add(node.elt);
            }
            ++n2;
        }
    }

    protected void startScope(int newScopeType, SimpleNode node) {
        this.scope.startScope(newScopeType, node);
        this.onAfterStartScope(newScopeType, node);
    }

    protected void endScope(SimpleNode node) {
        this.onBeforeEndScope(node);
        ScopeItems m = this.scope.endScope();
        Iterator<Found> it = this.probablyNotDefined.iterator();
        while (it.hasNext()) {
            Found n = it.next();
            GenAndTok probablyNotDefinedFirst = n.getSingle();
            IToken tok = probablyNotDefinedFirst.tok;
            String rep = tok.getRepresentation();
            List<Found> foundItems = this.find(m, rep);
            boolean setUsed = false;
            for (Found found : foundItems) {
                GenAndTok foundItemFirst = found.getSingle();
                if ((probablyNotDefinedFirst.scopeFound.getScopeType() & 0x12) == 0 || m.getScopeType() == 4 || foundItemFirst.scopeId >= probablyNotDefinedFirst.scopeId || !this.scope.typeCheckingDefinitionAndUsageOk(foundItemFirst, probablyNotDefinedFirst.inTypeChecking, probablyNotDefinedFirst.scopeFound.getScopeType())) continue;
                found.setUsed(true);
                setUsed = true;
            }
            if (!setUsed) continue;
            it.remove();
        }
        if (this.scope.size() == 0) {
            this.onLastScope(m);
        }
        this.onAfterEndScope(node, m);
    }

    protected List<Found> find(ScopeItems m, String fullRep) {
        ArrayList<Found> foundItems = new ArrayList<Found>();
        if (m == null) {
            return foundItems;
        }
        int i = fullRep.indexOf(46, 0);
        while (i >= 0) {
            String sub = fullRep.substring(0, i);
            i = fullRep.indexOf(46, i + 1);
            foundItems.addAll(m.getAll(sub));
        }
        foundItems.addAll(m.getAll(fullRep));
        return foundItems;
    }

    protected boolean markRead(IToken token) {
        String rep = token.getRepresentation();
        return this.markRead(token, rep, true, false);
    }

    protected boolean markRead(IToken token, String rep, boolean addToNotDefined, boolean checkIfIsValidImportToken) {
        boolean found;
        block27: {
            found = false;
            Found foundAs = null;
            String foundAsStr = null;
            int acceptedScopes = 0;
            ScopeItems currScopeItems = this.scope.getCurrScopeItems();
            boolean inTypeChecking = currScopeItems.isInTypeChecking();
            acceptedScopes = (currScopeItems.getScopeType() & 0x12) != 0 ? 123 : 127;
            if ("locals".equals(rep)) {
                currScopeItems.setAllUsed();
                return true;
            }
            Iterator it = new FullRepIterable(rep, true).iterator();
            while (!found && it.hasNext()) {
                String nextTokToSearch = (String)it.next();
                foundAs = this.scope.findFirst(nextTokToSearch, true, acceptedScopes, inTypeChecking, currScopeItems.getScopeType());
                boolean bl = found = foundAs != null;
                if (!found) continue;
                foundAsStr = nextTokToSearch;
                foundAs.getSingle().references.add(token);
                this.onFoundTokenAs(token, foundAs);
            }
            if (!found && this.scope.isVisitingStrTypeAnnotation()) {
                FastStack scopeStack = this.currentLocalScope.getScopeStack();
                for (ISimpleNode n : scopeStack) {
                    if (!(n instanceof ClassDef)) continue;
                    ClassDef classDef = (ClassDef)n;
                    if (!rep.equals(((NameTok)classDef.name).id)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                int i = rep.indexOf(46);
                if (i != -1) {
                    rep = rep.substring(0, i);
                }
                if (addToNotDefined) {
                    org.python.pydev.shared_core.structure.Tuple<IToken, Found> foundInNamesToIgnore = this.findInNamesToIgnore(rep, token);
                    if (foundInNamesToIgnore == null) {
                        Found foundForProbablyNotDefined = this.makeFound(token);
                        if (this.scope.size() > 1) {
                            this.probablyNotDefined.add(foundForProbablyNotDefined);
                            this.onAddToProbablyNotDefined(token, foundForProbablyNotDefined);
                        } else {
                            this.onAddUndefinedMessage(token, foundForProbablyNotDefined);
                        }
                    } else {
                        IToken tokenInNamesToIgnore = (IToken)foundInNamesToIgnore.o1;
                        this.onFoundInNamesToIgnore(token, tokenInNamesToIgnore);
                    }
                }
            } else if (checkIfIsValidImportToken) {
                try {
                    if (foundAs.isImport() && !rep.equals(foundAsStr) && foundAs.importInfo != null && foundAs.importInfo.wasResolved) {
                        Object tokToCheck;
                        IModule m = foundAs.importInfo.mod;
                        if (foundAs.isWildImport()) {
                            tokToCheck = foundAsStr;
                        } else {
                            String tok = foundAs.importInfo.rep;
                            tokToCheck = rep.substring(foundAsStr.length() + 1);
                            if (tok.length() > 0) {
                                tokToCheck = tok + "." + (String)tokToCheck;
                            }
                        }
                        for (String repToCheck : new FullRepIterable((String)tokToCheck)) {
                            int inGlobalTokens = m.isInGlobalTokens(repToCheck, this.nature, true, true, this.completionCache);
                            if (inGlobalTokens == 0) {
                                if (!this.isDefinitionUnknown(m, repToCheck)) {
                                    TokensList interfaceForLocal = this.currentLocalScope.getInterfaceForLocal(foundAsStr, false, true);
                                    boolean foundInHasAttr = false;
                                    for (IterTokenEntry entry : interfaceForLocal) {
                                        IToken iToken = entry.getToken();
                                        if (!iToken.getRepresentation().equals(repToCheck)) continue;
                                        foundInHasAttr = true;
                                        break;
                                    }
                                    if (!foundInHasAttr) {
                                        IToken foundTok = this.findNameTok(token, repToCheck);
                                        this.onAddUndefinedVarInImportMessage(foundTok, foundAs);
                                    }
                                }
                            } else if (inGlobalTokens != 2) {
                                continue;
                            }
                            break block27;
                        }
                        break block27;
                    }
                    if (foundAs.isImport() && (foundAs.importInfo == null || !foundAs.importInfo.wasResolved)) {
                        this.onFoundUnresolvedImportPart(token, rep, foundAs);
                    }
                }
                catch (Exception e) {
                    Log.log((String)("Error checking for valid tokens (imports) for " + this.moduleName), (Throwable)e);
                }
            }
        }
        return found;
    }

    protected void onFoundInNamesToIgnore(IToken token, IToken tokenInNamesToIgnore) {
    }

    protected void onFoundTokenAs(IToken token, Found foundAs) {
    }

    private boolean isDefinitionUnknown(IModule m, String repToCheck) throws Exception {
        String name = m.getName();
        TupleN key = new TupleN(new Object[]{"isDefinitionUnknown", name != null ? name : "", repToCheck});
        Boolean isUnknown = (Boolean)this.completionCache.getObj((Object)key);
        if (isUnknown == null) {
            isUnknown = this.internalGenerateIsDefinitionUnknown(m, repToCheck);
            this.completionCache.add((Object)key, (Object)isUnknown);
        }
        return isUnknown;
    }

    private boolean internalGenerateIsDefinitionUnknown(IModule m, String repToCheck) throws Exception {
        if (!(m instanceof SourceModule)) {
            return false;
        }
        if ((repToCheck = FullRepIterable.headAndTail((String)repToCheck, (boolean)true)[0]).length() == 0) {
            return false;
        }
        IDefinition[] definitions = m.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)repToCheck, (IPythonNature)this.nature, (ICompletionCache)this.completionCache), -1, -1, this.nature);
        int i = 0;
        while (i < definitions.length) {
            IDefinition foundDefinition = definitions[i];
            if (foundDefinition instanceof AssignOrTypeAliasDefinition) {
                AssignOrTypeAliasDefinition d = (AssignOrTypeAliasDefinition)foundDefinition;
                if (d.value.equals("None")) {
                    return true;
                }
                IDefinition[] definitions2 = d.module.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)d.value, (IPythonNature)this.nature, (ICompletionCache)this.completionCache), d.line, d.col, this.nature);
                if (definitions2.length == 1 && definitions2[0] instanceof Definition) {
                    ClassDef def;
                    Definition definition = (Definition)definitions2[0];
                    if (definition.ast instanceof FunctionDef) {
                        return true;
                    }
                    if (definition.ast instanceof ClassDef && this.isDynamicClass(def = (ClassDef)definition.ast)) {
                        return true;
                    }
                }
            } else if (foundDefinition instanceof Definition) {
                ClassDef classDef;
                Definition definition = (Definition)foundDefinition;
                if (definition.ast instanceof ClassDef && this.isDynamicClass(classDef = (ClassDef)definition.ast)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isDynamicClass(ClassDef def) {
        String docString = NodeUtils.getNodeDocString((SimpleNode)def);
        return docString != null && docString.indexOf("@DynamicAttrs") != -1;
    }

    protected Found makeFound(IToken token) {
        return new Found(token, token, this.scope.getCurrScopeId(), this.scope.getCurrScopeItems());
    }

    protected IToken findNameTok(IToken token, String tokToCheck) {
        if (token instanceof SourceToken) {
            SourceToken s = (SourceToken)token;
            SimpleNode ast = s.getAst();
            String searchFor = FullRepIterable.getLastPart((String)tokToCheck);
            while (ast instanceof Attribute) {
                Attribute a = (Attribute)ast;
                if (((NameTok)a.attr).id.equals(searchFor)) {
                    return new SourceToken((SimpleNode)a.attr, searchFor, "", "", token.getParentPackage(), this.nature, s.module);
                }
                if (a.value.toString().equals(searchFor)) {
                    return new SourceToken((SimpleNode)a.value, searchFor, "", "", token.getParentPackage(), this.nature, s.module);
                }
                ast = a.value;
            }
        }
        return token;
    }

    protected abstract void onAfterVisitAssign(Assign var1);

    protected abstract void onAfterStartScope(int var1, SimpleNode var2);

    protected abstract void onBeforeEndScope(SimpleNode var1);

    protected abstract void onAfterEndScope(SimpleNode var1, ScopeItems var2);

    protected abstract void onLastScope(ScopeItems var1);

    protected abstract void onAddUndefinedMessage(IToken var1, Found var2);

    protected void onAddToProbablyNotDefined(IToken token, Found foundForProbablyNotDefined) {
    }

    protected void onNotDefinedFoundLater(Found foundInProbablyNotDefined, Found laterFound) {
        foundInProbablyNotDefined.reportDefined(laterFound);
    }

    protected abstract void onAddUndefinedVarInImportMessage(IToken var1, Found var2);

    public abstract void onAddUnusedMessage(SimpleNode var1, Found var2);

    public abstract void onAddReimportMessage(Found var1);

    public abstract void onAddUnresolvedImport(IToken var1);

    protected abstract void onAddAssignmentToBuiltinMessage(IToken var1, String var2);

    protected void onAfterAddToNamesToIgnore(ScopeItems currScopeItems, org.python.pydev.shared_core.structure.Tuple<IToken, Found> tup) {
    }

    protected void onFoundUnresolvedImportPart(IToken token, String rep, Found foundAs) {
    }

    public void onImportInfoSetOnFound(Found found) {
    }
}

