/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.scopeanalysis.AbstractScopeAnalyzerVisitor;
import com.python.pydev.analysis.visitors.ArgumentsChecker;
import com.python.pydev.analysis.visitors.DuplicationChecker;
import com.python.pydev.analysis.visitors.FixLinesVisitor;
import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.analysis.visitors.MessagesManager;
import com.python.pydev.analysis.visitors.NoSelfChecker;
import com.python.pydev.analysis.visitors.ScopeItems;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.analysis.messages.IMessage;
import org.python.pydev.ast.analysis.messages.Message;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.ast.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.core.IAnalysisPreferences;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.IGrammar;
import org.python.pydev.parser.IGrammar2;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.fastparser.grammar_fstrings_common.FStringsAST;
import org.python.pydev.parser.grammar_fstrings.FStringsGrammar;
import org.python.pydev.parser.grammar_fstrings.FStringsGrammarFactory;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assert;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.AugAssign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Compare;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Lambda;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Print;
import org.python.pydev.parser.jython.ast.Raise;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.Yield;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.match_caseType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_core.structure.FastStack;

public final class OccurrencesVisitor
extends AbstractScopeAnalyzerVisitor {
    public final MessagesManager messagesManager;
    private final DuplicationChecker duplicationChecker;
    private final NoSelfChecker noSelfChecker;
    private final ArgumentsChecker argumentsChecker;
    private final boolean analyzeArgumentsMismatch = false;
    private IAnalysisPreferences prefs;
    private int isInTestScope = 0;
    private static Set<String> CONTAINER_CLASSES = new HashSet<String>();
    private final FastStack<TokenFoundStructure> recordedFounds = new FastStack(4);
    private int recordFounds = 0;

    static {
        CONTAINER_CLASSES.add("list");
        CONTAINER_CLASSES.add("List");
        CONTAINER_CLASSES.add("typing.List");
        CONTAINER_CLASSES.add("tuple");
        CONTAINER_CLASSES.add("Tuple");
        CONTAINER_CLASSES.add("typing.Tuple");
        CONTAINER_CLASSES.add("set");
        CONTAINER_CLASSES.add("Set");
        CONTAINER_CLASSES.add("typing.Set");
        CONTAINER_CLASSES.add("str");
    }

    public OccurrencesVisitor(IPythonNature nature, String moduleName, IModule current, IAnalysisPreferences prefs, IDocument document, IProgressMonitor monitor) {
        super(nature, moduleName, current, document, monitor);
        this.messagesManager = new MessagesManager(prefs, moduleName, document);
        this.prefs = prefs;
        this.argumentsChecker = null;
        this.duplicationChecker = new DuplicationChecker(this);
        this.noSelfChecker = new NoSelfChecker(this);
    }

    public Object visitCompare(Compare node) throws Exception {
        Object ret = super.visitCompare(node);
        if (this.isInTestScope == 0) {
            SourceToken token = AbstractVisitor.makeToken((SimpleNode)node, (String)this.moduleName, (IPythonNature)this.nature, (IModule)this.current);
            this.messagesManager.addMessage(11, (IToken)token);
        }
        return ret;
    }

    public void traverse(match_caseType node) throws Exception {
        this.checkStop();
        ++this.isInTestScope;
        ++this.isInMatchScope;
        if (node.pattern != null) {
            node.pattern.accept((VisitorIF)this);
        }
        if (node.guard != null) {
            node.guard.accept((VisitorIF)this);
        }
        --this.isInTestScope;
        --this.isInMatchScope;
        this.scope.addStatementSubScope();
        if (node.body != null) {
            stmtType[] stmtTypeArray = node.body;
            int n = node.body.length;
            int n2 = 0;
            while (n2 < n) {
                stmtType n3 = stmtTypeArray[n2];
                if (n3 != null) {
                    n3.accept((VisitorIF)this);
                }
                ++n2;
            }
        }
        this.scope.removeStatementSubScope();
    }

    public void traverse(If node) throws Exception {
        this.checkStop();
        if (node.test != null) {
            ++this.isInTestScope;
            node.test.accept((VisitorIF)this);
            --this.isInTestScope;
        }
        if (node.body != null) {
            int i = 0;
            while (i < node.body.length) {
                if (node.body[i] != null) {
                    node.body[i].accept((VisitorIF)this);
                }
                ++i;
            }
        }
        if (node.orelse != null) {
            node.orelse.accept((VisitorIF)this);
        }
    }

    public Object visitTuple(Tuple node) throws Exception {
        ++this.isInTestScope;
        Object ret = super.visitTuple(node);
        --this.isInTestScope;
        return ret;
    }

    public void traverse(While node) throws Exception {
        this.checkStop();
        if (node.test != null) {
            ++this.isInTestScope;
            node.test.accept((VisitorIF)this);
            --this.isInTestScope;
        }
        if (node.body != null) {
            int i = 0;
            while (i < node.body.length) {
                if (node.body[i] != null) {
                    node.body[i].accept((VisitorIF)this);
                }
                ++i;
            }
        }
        if (node.orelse != null) {
            node.orelse.accept((VisitorIF)this);
        }
    }

    public Object visitRaise(Raise node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitRaise(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitComprehension(Comprehension node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitComprehension(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitAssert(Assert node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitAssert(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitPrint(Print node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitPrint(node);
        --this.isInTestScope;
        return r;
    }

    @Override
    public Object visitAssign(Assign node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitAssign(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitStr(Str node) throws Exception {
        if (this.scope.isVisitingTypeAnnotation()) {
            String fullRepresentationString = null;
            if (this.scope.subscripts.size() > 0) {
                Subscript lastSubscript = (Subscript)this.scope.subscripts.peek();
                fullRepresentationString = NodeUtils.getFullRepresentationString((SimpleNode)lastSubscript.value);
            }
            if (fullRepresentationString == null || CONTAINER_CLASSES.contains(fullRepresentationString)) {
                int startInternalStrColOffset;
                Throwable errorOnParsing;
                String s;
                block17: {
                    s = node.s;
                    IGrammar grammar = PyParser.createGrammar((boolean)true, (int)this.nature.getGrammarVersion(), (char[])s.toCharArray());
                    errorOnParsing = null;
                    startInternalStrColOffset = OccurrencesVisitor.getStrOffset(node);
                    try {
                        SimpleNode typingNode = grammar.file_input();
                        errorOnParsing = grammar.getErrorOnParsing();
                        if (errorOnParsing != null) break block17;
                        new FixLinesVisitor(node.beginLine - 1, node.beginColumn + startInternalStrColOffset - 1).traverse(typingNode);
                        this.scope.startScope(64, (SimpleNode)node);
                        try {
                            this.traverse(typingNode);
                        }
                        finally {
                            this.scope.endScope();
                        }
                    }
                    catch (Exception e) {
                        if (errorOnParsing != null) break block17;
                        errorOnParsing = e;
                    }
                }
                if (errorOnParsing != null) {
                    Document doc = new Document(s);
                    this.reportParserError(node, node.beginLine, node.beginColumn + startInternalStrColOffset, (IDocument)doc, errorOnParsing);
                }
            }
        }
        if (node.fstring && (node.fstring_nodes == null || node.fstring_nodes.length == 0)) {
            String s = node.s;
            List<Throwable> parseErrors = null;
            int startInternalStrColOffset = OccurrencesVisitor.getStrOffset(node);
            FStringsAST ast = null;
            if (s.trim().length() > 0) {
                try {
                    FStringsGrammar fStringsGrammar = FStringsGrammarFactory.createGrammar((String)s);
                    ast = fStringsGrammar.f_string();
                    parseErrors = fStringsGrammar.getParseErrors();
                }
                catch (Throwable e) {
                    parseErrors = Arrays.asList(e);
                }
            }
            Document doc = new Document(s);
            if (parseErrors != null && parseErrors.size() > 0) {
                for (Exception exception : parseErrors) {
                    this.reportParserError(node, node.beginLine, node.beginColumn + startInternalStrColOffset, (IDocument)doc, exception);
                }
            } else if (ast != null) {
                this.analyzeFStringAst(node, startInternalStrColOffset, ast, (IDocument)doc);
            }
        }
        return super.visitStr(node);
    }

    public static int getStrOffset(Str node) {
        int startInternalStrColOffset = 1;
        if (node.raw) {
            ++startInternalStrColOffset;
        }
        if (node.unicode) {
            ++startInternalStrColOffset;
        }
        if (node.fstring) {
            ++startInternalStrColOffset;
        }
        if (node.type == 2 || node.type == 1) {
            startInternalStrColOffset += 2;
        }
        return startInternalStrColOffset;
    }

    private void analyzeFStringAst(Str node, int startInternalStrColOffset, FStringsAST ast, IDocument doc) throws Exception {
        for (FStringsAST.FStringExpressionContent content : ast.getFStringExpressionsContent(doc)) {
            Document contentDoc = new Document(content.string);
            IGrammar grammar = PyParser.createGrammar((boolean)true, (int)this.nature.getGrammarVersion(), (char[])content.string.toCharArray());
            if (grammar instanceof IGrammar2) {
                int startInternalStrColOffset2;
                IGrammar2 iGrammar2 = (IGrammar2)grammar;
                Throwable errorOnParsing = null;
                Expr expr = null;
                try {
                    expr = iGrammar2.eval_input();
                    errorOnParsing = grammar.getErrorOnParsing();
                }
                catch (Throwable e) {
                    errorOnParsing = e;
                }
                int startInternalStrLineOffset = content.beginLine + node.beginLine - 1;
                int n = startInternalStrColOffset2 = content.beginLine == 1 ? startInternalStrColOffset + content.beginColumn + node.beginColumn - 1 : content.beginColumn;
                if (errorOnParsing != null) {
                    this.reportParserError(node, startInternalStrLineOffset, startInternalStrColOffset2, (IDocument)contentDoc, errorOnParsing);
                    continue;
                }
                if (expr == null) continue;
                FixLinesVisitor fixLinesVisitor = new FixLinesVisitor(startInternalStrLineOffset - 1, startInternalStrColOffset2 - 1);
                expr.accept((VisitorIF)fixLinesVisitor);
                expr.accept((VisitorIF)this);
                continue;
            }
            Log.log((String)("Expected: " + String.valueOf(grammar) + " to implement IGrammar2."));
        }
    }

    private void reportParserError(Str node, int startInternalStrLineOffset, int startInternalStrColOffset, IDocument doc, Throwable parserError) {
        ErrorDescription errorDescription = PyParser.createErrorDesc((Throwable)parserError, (IDocument)doc);
        int errorDescriptionBeginLine = errorDescription.getBeginLine(doc);
        int startLine = errorDescriptionBeginLine + startInternalStrLineOffset - 1;
        int endLine = errorDescription.getEndLine(doc) + startInternalStrLineOffset - 1;
        int startCol = errorDescription.getBeginColumn(doc);
        int endCol = errorDescription.getEndCol(doc);
        if (errorDescriptionBeginLine == 1) {
            startCol += startInternalStrColOffset;
            if (startLine == endLine) {
                endCol += startInternalStrColOffset;
            }
        }
        Message message = new Message(17, (Object)errorDescription.message, startLine, endLine, startCol, endCol, this.prefs);
        this.messagesManager.addMessage((IToken)AbstractVisitor.makeToken((SimpleNode)node, (String)this.moduleName, (IPythonNature)this.nature, (IModule)this.current), (IMessage)message);
    }

    public Object visitYield(Yield node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitYield(node);
        --this.isInTestScope;
        return r;
    }

    @Override
    public Object visitAugAssign(AugAssign node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitAugAssign(node);
        --this.isInTestScope;
        return r;
    }

    @Override
    public Object visitCall(Call node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitCall(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitReturn(Return node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitReturn(node);
        --this.isInTestScope;
        return r;
    }

    @Override
    protected void handleDecorator(decoratorsType dec) throws Exception {
        ++this.isInTestScope;
        dec.accept((VisitorIF)this);
        --this.isInTestScope;
    }

    @Override
    public Object visitLambda(Lambda node) throws Exception {
        ++this.isInTestScope;
        Object ret = super.visitLambda(node);
        --this.isInTestScope;
        return ret;
    }

    public Object visitSubscript(Subscript node) throws Exception {
        this.scope.pushSubscript(node);
        try {
            Object object = super.visitSubscript(node);
            return object;
        }
        finally {
            this.scope.popSubscript(node);
        }
    }

    @Override
    public void traverse(SimpleNode node) throws Exception {
        if (node instanceof If) {
            this.traverse((If)node);
        } else if (node instanceof While) {
            this.traverse((While)node);
        } else if (node instanceof ListComp) {
            this.visitListComp((ListComp)node);
        } else if (node instanceof match_caseType) {
            this.traverse((match_caseType)node);
        } else {
            super.traverse(node);
        }
    }

    public List<IMessage> getMessages() {
        this.endScope(null);
        return this.messagesManager.getMessages();
    }

    @Override
    protected void onAddUndefinedVarInImportMessage(IToken foundTok, Found foundAs) {
        this.messagesManager.addUndefinedVarInImportMessage(foundTok, foundTok.getRepresentation());
    }

    @Override
    protected void onAddAssignmentToBuiltinMessage(IToken foundTok, String representation) {
        this.messagesManager.onAddAssignmentToBuiltinMessage(foundTok, representation);
    }

    @Override
    protected void onAddUndefinedMessage(IToken token, Found foundAs) {
        if ("...".equals(token.getRepresentation())) {
            return;
        }
        this.messagesManager.addUndefinedMessage(token);
    }

    @Override
    protected void onLastScope(ScopeItems m) {
        for (Found n : this.probablyNotDefined) {
            Map<String, org.python.pydev.shared_core.structure.Tuple<IToken, Found>> lastInStack;
            String rep = n.getSingle().tok.getRepresentation();
            if (this.scope.findInNamesToIgnore(rep, lastInStack = m.namesToIgnore) != null) continue;
            this.onAddUndefinedMessage(n.getSingle().tok, n);
        }
    }

    @Override
    protected void onAfterEndScope(SimpleNode node, ScopeItems m) {
        boolean reportUnused = true;
        if (node != null && node instanceof FunctionDef) {
            boolean bl = reportUnused = !this.isVirtual((FunctionDef)node);
        }
        if (reportUnused) {
            int scopeType = m.getScopeType();
            for (List<Found> list : m.getAll()) {
                int len = list.size();
                int i = 0;
                while (i < len) {
                    Found f = list.get(i);
                    if (!f.isUsed() && ((scopeType & 0x12) != 0 || f.isImport())) {
                        this.messagesManager.addUnusedMessage(node, f);
                    }
                    ++i;
                }
            }
        }
    }

    protected boolean isVirtual(FunctionDef node) {
        if (node.body != null) {
            int len = node.body.length;
            int i = 0;
            while (i < len) {
                stmtType n = node.body[i];
                if (!(n instanceof Raise || n instanceof Expr && ((Expr)n).value instanceof Str)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    protected void onAfterStartScope(int newScopeType, SimpleNode node) {
        if (newScopeType == 4) {
            this.duplicationChecker.beforeClassDef((ClassDef)node);
            this.noSelfChecker.beforeClassDef((ClassDef)node);
        } else if ((newScopeType & 2) != 0) {
            this.duplicationChecker.beforeFunctionDef((FunctionDef)node);
            this.noSelfChecker.beforeFunctionDef((FunctionDef)node);
        }
    }

    @Override
    protected void onBeforeEndScope(SimpleNode node) {
        if (node instanceof ClassDef) {
            this.noSelfChecker.afterClassDef((ClassDef)node);
            this.duplicationChecker.afterClassDef((ClassDef)node);
        } else if (node instanceof FunctionDef) {
            this.duplicationChecker.afterFunctionDef((FunctionDef)node);
            this.noSelfChecker.afterFunctionDef((FunctionDef)node);
        }
    }

    @Override
    public void onAddUnusedMessage(SimpleNode node, Found found) {
        this.messagesManager.addUnusedMessage(node, found);
    }

    @Override
    public void onAddReimportMessage(Found newFound) {
        this.messagesManager.addReimportMessage(newFound);
    }

    @Override
    public void onAddUnresolvedImport(IToken token) {
        this.messagesManager.addMessage(6, token);
    }

    @Override
    protected void onAfterVisitAssign(Assign node) {
        this.noSelfChecker.visitAssign(node);
    }

    @Override
    protected void onVisitCallFunc(Call callNode) throws Exception {
        super.onVisitCallFunc(callNode);
    }

    private void onPushToRecordedFounds(IToken o1) {
        if (this.recordFounds > 0) {
            this.recordedFounds.push((Object)new TokenFoundStructure(o1, true, null));
        }
    }

    @Override
    protected void onAddToProbablyNotDefined(IToken token, Found foundForProbablyNotDefined) {
        if (this.recordFounds > 0) {
            this.recordedFounds.push((Object)new TokenFoundStructure(token, false, foundForProbablyNotDefined));
        }
    }

    protected TokenFoundStructure popFound() {
        --this.recordFounds;
        if (this.recordedFounds.size() > 0) {
            TokenFoundStructure ret = (TokenFoundStructure)this.recordedFounds.peek();
            this.recordedFounds.clear();
            return ret;
        }
        return null;
    }

    protected void startRecordFound() {
        ++this.recordFounds;
    }

    @Override
    protected void onFoundTokenAs(IToken token, Found foundAs) {
    }

    @Override
    protected void onFoundInNamesToIgnore(IToken token, IToken tokenInNamesToIgnore) {
    }

    public static final class TokenFoundStructure {
        public final IToken token;
        public final boolean defined;
        public final Found found;

        public TokenFoundStructure(IToken token, boolean defined, Found found) {
            this.token = token;
            this.defined = defined;
            this.found = found;
        }
    }
}

