/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.analysis.visitors.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.python.pydev.core.IToken;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.excepthandlerType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.Tuple;

public final class ScopeItems {
    private final Map<String, List<Found>> m = new HashMap<String, List<Found>>();
    public final Map<String, Tuple<IToken, Found>> namesToIgnore = new HashMap<String, Tuple<IToken, Found>>();
    public final FastStack<If> ifNodes = new FastStack(10);
    public int statementSubScope = 0;
    public final FastStack<TryExceptInfo> tryExceptSubScope = new FastStack(10);
    private final int scopeId;
    private final int scopeType;
    public final int globalClassOrMethodScopeType;
    public final SimpleNode scopeNode;
    private Boolean inTypeChecking = null;

    public TryExceptInfo getTryExceptImportError() {
        for (TryExceptInfo except : this.getCurrTryExceptNodes()) {
            excepthandlerType[] excepthandlerTypeArray = except.except.handlers;
            int n = except.except.handlers.length;
            int n2 = 0;
            while (n2 < n) {
                String rep;
                excepthandlerType handler = excepthandlerTypeArray[n2];
                if (handler.type != null && (rep = NodeUtils.getRepresentationString((ISimpleNode)handler.type)) != null && rep.equals("ImportError")) {
                    return except;
                }
                ++n2;
            }
        }
        return null;
    }

    public ScopeItems(int scopeId, int scopeType, int globalClassOrMethodScopeType, SimpleNode node) {
        this.scopeId = scopeId;
        this.scopeType = scopeType;
        this.globalClassOrMethodScopeType = globalClassOrMethodScopeType;
        this.scopeNode = node;
    }

    public Found getLastAppearance(String rep) {
        List<Found> foundItems = this.m.get(rep);
        if (foundItems == null || foundItems.size() == 0) {
            return null;
        }
        int i = foundItems.size() - 1;
        while (i >= 0) {
            Found found = foundItems.get(i);
            if (!found.isEphemeral()) {
                return found;
            }
            --i;
        }
        return null;
    }

    public void setAllUsed() {
        for (List<Found> list : this.m.values()) {
            int len = list.size();
            int i = 0;
            while (i < len) {
                list.get(i).setUsed(true);
                ++i;
            }
        }
    }

    public Collection<List<Found>> getAll() {
        return this.m.values();
    }

    public List<Found> getAll(String rep) {
        List<Found> r = this.m.get(rep);
        if (r == null) {
            return new ArrayList<Found>(0);
        }
        return r;
    }

    public void put(String rep, Found found) {
        List<Found> foundItems = this.m.get(rep);
        if (foundItems == null) {
            foundItems = new ArrayList<Found>();
            this.m.put(rep, foundItems);
        }
        foundItems.add(found);
    }

    public boolean isInTypeChecking() {
        if (this.statementSubScope == 0 || this.ifNodes.size() == 0) {
            return false;
        }
        if (this.inTypeChecking != null) {
            return this.inTypeChecking;
        }
        this.inTypeChecking = false;
        for (If ifStatement : this.ifNodes) {
            if (!this.isTypeCheckingIfStatement(ifStatement)) continue;
            this.inTypeChecking = true;
            break;
        }
        return this.inTypeChecking;
    }

    private boolean isTypeCheckingIfStatement(If ifStatement) {
        String rep = NodeUtils.getFullRepresentationString((SimpleNode)ifStatement.test);
        return rep != null && (rep.equals("typing.TYPE_CHECKING") || rep.equals("TYPE_CHECKING"));
    }

    public void addIfSubScope(If node) {
        this.ifNodes.push((Object)node);
        ++this.statementSubScope;
        this.inTypeChecking = null;
    }

    public void removeIfSubScope() {
        this.ifNodes.pop();
        --this.statementSubScope;
        this.inTypeChecking = null;
    }

    public void addStatementSubScope() {
        ++this.statementSubScope;
    }

    public void removeStatementSubScope() {
        --this.statementSubScope;
    }

    public void addTryExceptSubScope(TryExcept node) {
        this.tryExceptSubScope.push((Object)new TryExceptInfo(node));
        ++this.statementSubScope;
    }

    public void removeTryExceptSubScope() {
        this.tryExceptSubScope.pop();
        --this.statementSubScope;
    }

    public FastStack<TryExceptInfo> getCurrTryExceptNodes() {
        return this.tryExceptSubScope;
    }

    public boolean getIsInStatementSubScope() {
        return this.statementSubScope != 0;
    }

    public int getScopeId() {
        return this.scopeId;
    }

    public int getScopeType() {
        return this.scopeType;
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer();
        buffer.append("ScopeItem (type:");
        buffer.append(Scope.getScopeTypeStr(this.scopeType));
        buffer.append(")\n");
        for (Map.Entry<String, List<Found>> entry : this.m.entrySet()) {
            buffer.append(entry.getKey());
            buffer.append(": contains ");
            buffer.append(entry.getValue().toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public List<Tuple<String, Found>> getUsedItems() {
        ArrayList<Tuple<String, Found>> found = new ArrayList<Tuple<String, Found>>();
        for (Map.Entry<String, List<Found>> entry : this.m.entrySet()) {
            for (Found f : entry.getValue()) {
                if (!f.isUsed()) continue;
                found.add((Tuple<String, Found>)new Tuple((Object)entry.getKey(), (Object)f));
            }
        }
        return found;
    }

    public static class TryExceptInfo {
        public TryExcept except;
        private Map<String, List<Found>> importsMapInTryExcept = new HashMap<String, List<Found>>();

        public TryExceptInfo(TryExcept except) {
            this.except = except;
        }

        public void addFoundImportToTryExcept(Found found) {
            if (!found.isImport()) {
                return;
            }
            String rep = found.getSingle().generator.getRepresentation();
            List<Found> importsListInTryExcept = this.importsMapInTryExcept.get(rep);
            if (importsListInTryExcept == null) {
                importsListInTryExcept = new ArrayList<Found>();
                this.importsMapInTryExcept.put(rep, importsListInTryExcept);
            } else if (importsListInTryExcept.size() > 0) {
                importsListInTryExcept.get(importsListInTryExcept.size() - 1).setUsed(true);
            }
            importsListInTryExcept.add(found);
        }
    }
}

