/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.codecompletion.simpleassist;

import java.util.ArrayList;
import java.util.Collection;
import org.python.pydev.ast.codecompletion.PyCodeCompletionPreferences;
import org.python.pydev.ast.simpleassist.ISimpleAssistParticipant;
import org.python.pydev.ast.simpleassist.ISimpleAssistParticipant2;
import org.python.pydev.core.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;

public class KeywordsSimpleAssist
implements ISimpleAssistParticipant,
ISimpleAssistParticipant2 {
    public Collection<ICompletionProposalHandle> computeCompletionProposals(String activationToken, String qualifier, PySelection ps, IPySyntaxHighlightingAndCodeCompletionEditor edit, int offset) {
        boolean isPy3Syntax = true;
        return this.innerComputeProposals(activationToken, qualifier, offset, false, isPy3Syntax);
    }

    public Collection<ICompletionProposalHandle> computeConsoleProposals(String activationToken, String qualifier, int offset) {
        return this.innerComputeProposals(activationToken, qualifier, offset, true, false);
    }

    private Collection<ICompletionProposalHandle> innerComputeProposals(String activationToken, String qualifier, int offset, boolean buildForConsole, boolean isPy3Syntax) {
        ArrayList<ICompletionProposalHandle> results = new ArrayList<ICompletionProposalHandle>();
        if (!PyCodeCompletionPreferences.useKeywordsCodeCompletion()) {
            return results;
        }
        int qlen = qualifier.length();
        if (activationToken.isEmpty() && !qualifier.isEmpty()) {
            String[] stringArray = PyCodeCompletionPreferences.getKeywords();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String keyw = stringArray[n2];
                if (keyw.startsWith(qualifier) && !keyw.equals(qualifier)) {
                    if (buildForConsole) {
                        results.add(CompletionProposalFactory.get().createPyCompletionProposal(keyw, offset - qlen, qlen, keyw.length(), 10, null));
                    } else {
                        if (isPy3Syntax && "print".equals(keyw)) {
                            keyw = "print()";
                        }
                        results.add(CompletionProposalFactory.get().createSimpleAssistProposal(keyw, offset - qlen, qlen, keyw.length(), 10, null));
                    }
                }
                ++n2;
            }
        }
        return results;
    }
}

