/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.interactiveconsole;

import java.io.File;
import java.util.ListResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.newconsole.PydevConsoleFactory;
import org.python.pydev.debug.newconsole.prefs.InteractiveConsolePrefs;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.shared_interactive_console.console.codegen.PythonSnippetUtils;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsole;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsoleViewer;
import org.python.pydev.shared_ui.editor.BaseEditor;
import org.python.pydev.shared_ui.editor.IPyEditListener;

public class EvaluateActionSetter
implements IPyEditListener {
    private static void sendCommandToConsole(PySelection selection, ScriptConsole console, PyEdit edit) throws BadLocationException {
        ScriptConsole pydevConsole = console;
        IDocument document = pydevConsole.getDocument();
        String cmd = EvaluateActionSetter.getCommandToSend(edit, selection);
        if (cmd != null) {
            document.replace(document.getLength(), 0, cmd);
        }
        if (InteractiveConsolePrefs.getFocusConsoleOnSendCommand()) {
            ScriptConsoleViewer viewer = pydevConsole.getViewer();
            if (viewer == null) {
                return;
            }
            StyledText textWidget = viewer.getTextWidget();
            if (textWidget == null) {
                return;
            }
            textWidget.setFocus();
        }
    }

    private static String getCommandToSend(PyEdit edit, PySelection selection) {
        Object cmd = null;
        String code = selection.getTextSelection().getText();
        if (code.length() != 0) {
            cmd = code + "\n";
        } else {
            File editorFile = edit.getEditorFile();
            if (editorFile != null) {
                cmd = PythonSnippetUtils.getRunfileCommand((File)editorFile);
            }
        }
        return cmd;
    }

    public void onCreateActions(ListResourceBundle resources, BaseEditor baseEditor, IProgressMonitor monitor) {
        final PyEdit edit = (PyEdit)baseEditor;
        final EvaluateAction evaluateAction = new EvaluateAction(edit);
        evaluateAction.setActionDefinitionId("org.python.pydev.interactiveconsole.evaluateActionSetter");
        evaluateAction.setId("org.python.pydev.interactiveconsole.evaluateActionSetter");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!edit.isDisposed()) {
                    edit.setAction("org.python.pydev.interactiveconsole.evaluateActionSetter", (IAction)evaluateAction);
                }
            }
        };
        Display.getDefault().syncExec(runnable);
    }

    public void onSave(BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onDispose(BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onSetDocument(IDocument document, BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    private class EvaluateAction
    extends Action {
        private final PyEdit edit;

        private EvaluateAction(PyEdit edit) {
            this.edit = edit;
        }

        public void run() {
            try {
                PySelection selection = PySelectionFromEditor.createPySelectionFromEditor((ITextEditor)this.edit);
                ScriptConsole console = ScriptConsole.getActiveScriptConsole();
                if (console == null) {
                    PydevConsoleFactory factory = new PydevConsoleFactory();
                    Object cmd = null;
                    if (InteractiveConsolePrefs.getSendCommandOnCreationFromEditor() && (cmd = EvaluateActionSetter.getCommandToSend(this.edit, selection)) != null) {
                        cmd = "\n" + (String)cmd;
                    }
                    factory.createConsole((String)cmd);
                } else if (console instanceof ScriptConsole) {
                    EvaluateActionSetter.sendCommandToConsole(selection, console, this.edit);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }
}

