/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.internal.console.IOConsolePartition;
import org.eclipse.ui.part.IPageBookViewPage;
import org.python.pydev.ast.codecompletion.PyCodeCompletionPreferences;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.console.ScriptConsoleViewerWrapper;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.GetCompletionsCommand;
import org.python.pydev.debug.model.remote.ICommandResponseListener;
import org.python.pydev.debug.newconsole.CurrentPyStackFrameForConsole;
import org.python.pydev.debug.newconsole.PydevConsoleCommunication;
import org.python.pydev.debug.newconsole.PydevConsoleCompletionProcessor;
import org.python.pydev.debug.newconsole.PydevConsoleInterpreter;
import org.python.pydev.editor.PyInformationControlCreator;
import org.python.pydev.editor.codecompletion.PyContentAssistant;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleCommunication;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleShell;
import org.python.pydev.shared_interactive_console.console.InterpreterResponse;
import org.python.pydev.shared_ui.bindings.KeyBindingHelper;

public class ConsoleCompletionsPageParticipant
implements IConsolePageParticipant {
    private PyContentAssistant contentAssist;

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public void init(IPageBookViewPage page, IConsole console) {
        if (!(console instanceof ProcessConsole)) {
            return;
        }
        ProcessConsole processConsole = (ProcessConsole)console;
        IProcess process = processConsole.getProcess();
        if (process == null) {
            return;
        }
        if (!PyCodeCompletionPreferences.useCodeCompletion() || !PyCodeCompletionPreferences.useCodeCompletionOnDebug()) {
            return;
        }
        String attribute = process.getAttribute("PYDEV_DEBUG_IPROCESS_ATTR");
        if (!"true".equals(attribute)) {
            return;
        }
        Control control = page.getControl();
        if (page instanceof IOConsolePage) {
            control.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (KeyBindingHelper.matchesContentAssistKeybinding((KeyEvent)e)) {
                        ConsoleCompletionsPageParticipant.this.contentAssist.showPossibleCompletions();
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            final CurrentPyStackFrameForConsole currentPyStackFrameForConsole = new CurrentPyStackFrameForConsole(console);
            IOConsolePage consolePage = (IOConsolePage)page;
            TextConsoleViewer viewer = consolePage.getViewer();
            PydevConsoleInterpreter interpreter = new PydevConsoleInterpreter();
            interpreter.setLaunchAndRelatedInfo(process.getLaunch());
            interpreter.setConsoleCommunication(new GetCompletionsInDebug(currentPyStackFrameForConsole));
            this.contentAssist = new PyContentAssistant(){

                public String showPossibleCompletions() {
                    if (currentPyStackFrameForConsole.getLastSelectedFrame() == null) {
                        return null;
                    }
                    return super.showPossibleCompletions();
                }
            };
            this.contentAssist.setInformationControlCreator((IInformationControlCreator)new PyInformationControlCreator());
            this.contentAssist.install((ITextViewer)new ScriptConsoleViewerWrapper(viewer, interpreter.getInterpreterInfo()));
            PydevConsoleCompletionProcessor processor = new PydevConsoleCompletionProcessor((IScriptConsoleShell)interpreter, this.contentAssist);
            this.contentAssist.setContentAssistProcessor((IContentAssistProcessor)processor, IOConsolePartition.INPUT_PARTITION_TYPE);
            this.contentAssist.setContentAssistProcessor((IContentAssistProcessor)processor, IOConsolePartition.OUTPUT_PARTITION_TYPE);
            this.contentAssist.enableAutoActivation(true);
            this.contentAssist.enableAutoInsert(false);
            this.contentAssist.setAutoActivationDelay(PyCodeCompletionPreferences.getAutocompleteDelay());
        }
    }

    public void dispose() {
    }

    public void activated() {
    }

    public void deactivated() {
    }

    public static class GetCompletionsInDebug
    implements IScriptConsoleCommunication,
    ICommandResponseListener {
        private static final ICompletionProposalHandle[] EMPTY_COMPLETION_PROPOSALS = new ICompletionProposalHandle[0];
        private String actTok;
        private String text;
        private int offset;
        private volatile List<Object[]> receivedXmlCompletions;
        private CurrentPyStackFrameForConsole currentPyStackFrameForConsole;

        public GetCompletionsInDebug(CurrentPyStackFrameForConsole currentPyStackFrameForConsole) {
            this.currentPyStackFrameForConsole = currentPyStackFrameForConsole;
        }

        public String getDescription(String text) throws Exception {
            throw new RuntimeException("Not implemented");
        }

        public boolean isConnected() {
            return this.currentPyStackFrameForConsole.getLastSelectedFrame() != null;
        }

        public ICompletionProposalHandle[] getCompletions(String text, String actTok, int offset, boolean showForTabCompletion) throws Exception {
            this.text = text;
            this.actTok = actTok;
            this.offset = offset;
            PyStackFrame stackFrame = this.currentPyStackFrameForConsole.getLastSelectedFrame();
            if (stackFrame != null) {
                AbstractDebugTarget target = (AbstractDebugTarget)stackFrame.getAdapter(IDebugTarget.class);
                if (target != null) {
                    GetCompletionsCommand cmd = new GetCompletionsCommand(target, actTok, stackFrame.getLocalsLocator().getPyDBLocation());
                    cmd.setCompletionListener(this);
                    target.postCommand(cmd);
                }
                return this.waitForCommand();
            }
            return EMPTY_COMPLETION_PROPOSALS;
        }

        private ICompletionProposalHandle[] waitForCommand() {
            int i = 300;
            while (--i > 0 && this.receivedXmlCompletions == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            List<Object[]> fromServer = this.receivedXmlCompletions;
            this.receivedXmlCompletions = null;
            if (fromServer == null) {
                Log.logInfo((String)"Timeout for waiting for debug completions elapsed (3 seconds).");
                return EMPTY_COMPLETION_PROPOSALS;
            }
            ArrayList<ICompletionProposalHandle> ret = new ArrayList<ICompletionProposalHandle>(fromServer.size());
            PydevConsoleCommunication.convertConsoleCompletionsToICompletions(this.text, this.actTok, this.offset, fromServer, ret, false);
            return ret.toArray(new ICompletionProposalHandle[0]);
        }

        public void execInterpreter(String command, ICallback<Object, InterpreterResponse> onResponseReceived) {
            throw new RuntimeException("Not implemented");
        }

        public void interrupt() {
            throw new RuntimeException("Not implemented");
        }

        public void setOnContentsReceivedCallback(ICallback<Object, Tuple<String, String>> onContentsReceived) {
            throw new RuntimeException("Not implemented");
        }

        public void close() throws Exception {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void commandComplete(AbstractDebuggerCommand cmd) {
            GetCompletionsCommand compCmd = (GetCompletionsCommand)cmd;
            try {
                String response = compCmd.getResponse();
                List<Object[]> fromServer = XMLUtils.convertXMLcompletionsFromConsole(response);
                this.receivedXmlCompletions = fromServer;
            }
            catch (CoreException e) {
                this.receivedXmlCompletions = new ArrayList<Object[]>(0);
                Log.log((Throwable)e);
            }
        }

        public void linkWithDebugSelection(boolean isLinkedWithDebug) {
            throw new RuntimeException("Not implemented");
        }
    }
}

