/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.curr_exception;

import java.io.File;
import java.lang.ref.WeakReference;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.debug.curr_exception.CurrentExceptionView;
import org.python.pydev.debug.model.PyExceptionBreakPointManager;
import org.python.pydev.shared_core.image.IImageDescriptor;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class EditIgnoredCaughtExceptions
extends Action {
    private WeakReference<CurrentExceptionView> currentExceptionView;

    public EditIgnoredCaughtExceptions(CurrentExceptionView currentExceptionView) {
        this.currentExceptionView = new WeakReference<CurrentExceptionView>(currentExceptionView);
        this.setImageDescriptor(ImageCache.asImageDescriptor((IImageDescriptor)SharedUiPlugin.getImageCache().getDescriptor("icons/history_list.gif")));
        this.setToolTipText("Edit currently ignored caught exceptions.");
    }

    public void run() {
        IPath ignoreThrownExceptionsPath = PyExceptionBreakPointManager.getInstance().ignoreCaughtExceptionsWhenThrownFrom.getIgnoreThrownExceptionsPath();
        File file = ignoreThrownExceptionsPath.toFile();
        IEditorPart openFile = EditorUtils.openFile((File)file);
        if (openFile instanceof ITextEditor) {
            final ITextEditor textEditor = (ITextEditor)openFile;
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            final IEditorInput input = openFile.getEditorInput();
            if (documentProvider instanceof IStorageDocumentProvider) {
                IStorageDocumentProvider storageDocumentProvider = (IStorageDocumentProvider)documentProvider;
                storageDocumentProvider.setEncoding((Object)input, "utf-8");
                textEditor.doRevertToSaved();
            }
            if (textEditor instanceof ISaveablePart) {
                IPropertyListener listener = new IPropertyListener(){

                    public void propertyChanged(Object source, int propId) {
                        if (propId == 257 && source == textEditor && textEditor.getEditorInput() == input && !textEditor.isDirty()) {
                            PyExceptionBreakPointManager.getInstance().ignoreCaughtExceptionsWhenThrownFrom.updateIgnoreThrownExceptions();
                        }
                    }
                };
                textEditor.addPropertyListener(listener);
            }
        }
    }
}

