/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.python.pydev.debug.model.PyDebugTarget;
import org.python.pydev.debug.model.PyStackFrameConsole;
import org.python.pydev.debug.model.PyThreadConsole;
import org.python.pydev.debug.model.remote.RemoteDebuggerConsole;
import org.python.pydev.debug.newconsole.IPydevConsoleDebugTarget;
import org.python.pydev.debug.newconsole.PydevConsoleCommunication;
import org.python.pydev.shared_core.utils.ArrayUtils;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsole;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsoleManager;

public class PyDebugTargetConsole
extends PyDebugTarget
implements IPydevConsoleDebugTarget {
    PyThreadConsole virtualConsoleThread = new PyThreadConsole(this);
    IThread[] virtualConsoleThreads = new IThread[]{this.virtualConsoleThread};
    private ScriptConsole console;

    public PyDebugTargetConsole(PydevConsoleCommunication scriptConsoleCommunication, ILaunch launch, IProcess process, RemoteDebuggerConsole debugger) {
        super(launch, process, null, debugger, null);
    }

    @Override
    public RemoteDebuggerConsole getDebugger() {
        return (RemoteDebuggerConsole)super.getDebugger();
    }

    @Override
    public IThread[] getThreads() throws DebugException {
        if (this.isTerminated()) {
            return new IThread[0];
        }
        IThread[] realThreads = super.getThreads();
        if (realThreads != null) {
            return (IThread[])ArrayUtils.concatArrays((Object[][])new IThread[][]{this.virtualConsoleThreads, realThreads});
        }
        return this.virtualConsoleThreads;
    }

    private IStackFrame[] createFrames() {
        PyStackFrameConsole frame = new PyStackFrameConsole(this.virtualConsoleThread, this);
        return new IStackFrame[]{frame};
    }

    @Override
    public void setSuspended(boolean suspended) {
        if (suspended != this.virtualConsoleThread.isSuspended()) {
            int state;
            if (suspended) {
                state = 2;
                this.virtualConsoleThread.setSuspended(true, this.createFrames());
            } else {
                state = 1;
                this.virtualConsoleThread.setSuspended(false, null);
            }
            this.fireEvent(new DebugEvent((Object)this.virtualConsoleThread, state, 32));
        }
    }

    @Override
    public String getName() throws DebugException {
        if (this.console == null) {
            return "PyDev Console";
        }
        return this.console.getName();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setSuspended(true);
    }

    @Override
    public void terminate() {
        super.terminate();
        if (this.console != null) {
            ScriptConsoleManager.getInstance().close(this.console);
        }
    }

    public void setConsole(ScriptConsole console) {
        this.console = console;
    }
}

