/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.XMLUtils;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.EvaluateExpressionCommand;
import org.python.pydev.debug.model.remote.ICommandResponseListener;

public class PyWatchExpressionDelegate
implements IWatchExpressionDelegate,
IWatchExpressionResult,
ICommandResponseListener {
    private final Object sync = new Object();
    protected IValue value = null;
    protected IDebugElement context;
    protected String expression;
    protected IWatchExpressionListener listener;
    protected String[] errors = new String[0];

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        this.expression = expression;
        this.context = context;
        this.listener = listener;
        if (context instanceof PyStackFrame) {
            AbstractDebugTarget target = (AbstractDebugTarget)context.getDebugTarget();
            if (target == null) {
                return;
            }
            EvaluateExpressionCommand cmd = new EvaluateExpressionCommand(target, expression, ((PyStackFrame)context).getLocalsLocator().getPyDBLocation(), false);
            cmd.setCompletionListener(this);
            target.postCommand(cmd);
        } else {
            this.addError("unknown expression context");
            listener.watchEvaluationFinished((IWatchExpressionResult)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue getValue() {
        Object object = this.sync;
        synchronized (object) {
            return this.value;
        }
    }

    public boolean hasErrors() {
        return this.errors.length > 0;
    }

    public String[] getErrorMessages() {
        return this.errors;
    }

    public String getExpressionText() {
        return this.expression;
    }

    public DebugException getException() {
        return null;
    }

    public void addError(String message) {
        this.errors = Arrays.copyOf(this.errors, this.errors.length + 1);
        this.errors[this.errors.length - 1] = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commandComplete(AbstractDebuggerCommand cmd) {
        try {
            String payload = ((EvaluateExpressionCommand)cmd).getResponse();
            PyVariable[] variables = XMLUtils.XMLToVariables((AbstractDebugTarget)this.context.getDebugTarget(), ((PyStackFrame)this.context).getExpressionLocator(), payload);
            IValue value = this.newValue(variables);
            Object object = this.sync;
            synchronized (object) {
                this.value = value;
            }
        }
        catch (CoreException e) {
            this.addError("Evaluation of " + this.getExpressionText() + " failed: " + e.getMessage());
            PydevDebugPlugin.log(4, "Error fetching a variable", e);
        }
        this.listener.watchEvaluationFinished((IWatchExpressionResult)this);
    }

    private IValue newValue(PyVariable[] variables) {
        if (variables == null || variables.length == 0) {
            this.addError("Evaluation of " + this.getExpressionText() + " failed: no variables.");
            return null;
        }
        if (variables.length == 1) {
            return variables[0];
        }
        return new WatchExpressionValue(this.context, variables);
    }

    public static class WatchExpressionValue
    extends DebugElement
    implements IValue {
        private final IVariable[] variables;

        public WatchExpressionValue(IDebugElement context, IVariable[] variables) {
            super(context.getDebugTarget());
            this.variables = variables;
        }

        public String getModelIdentifier() {
            return this.getDebugTarget().getModelIdentifier();
        }

        public String getReferenceTypeName() throws DebugException {
            return null;
        }

        public String getValueString() throws DebugException {
            boolean first = true;
            StringBuilder sb = new StringBuilder().append("{");
            IVariable[] iVariableArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable variable = iVariableArray[n2];
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                IValue val = variable.getValue();
                sb.append(variable.getName()).append(": ").append(val == null ? "<error>" : val.getValueString());
                ++n2;
            }
            return sb.append("}").toString();
        }

        public boolean isAllocated() throws DebugException {
            return false;
        }

        public IVariable[] getVariables() throws DebugException {
            if (this.hasVariables()) {
                return Arrays.copyOf(this.variables, this.variables.length);
            }
            return PyVariable.EMPTY_IVARIABLE_ARRAY;
        }

        public boolean hasVariables() throws DebugException {
            return this.variables.length > 0;
        }
    }
}

