/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Hashtable;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.AbstractDebugTargetWithTransmission;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.HttpProtocolUtils;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.ui.dialogs.PyDialogHelpers;

public class DebuggerReader
implements Runnable {
    private static final boolean DEBUG = false;
    private Socket socket;
    private volatile boolean done = false;
    private Dictionary<Integer, AbstractDebuggerCommand> responseQueue = new Hashtable<Integer, AbstractDebuggerCommand>();
    private InputStream in;
    private AbstractDebugTarget remote;

    public DebuggerReader(Socket s, AbstractDebugTargetWithTransmission r) throws IOException {
        this.remote = (AbstractDebugTarget)r;
        this.socket = s;
        this.in = this.socket.getInputStream();
    }

    public void done() {
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToResponseQueue(AbstractDebuggerCommand cmd) {
        int sequence = cmd.getSequence();
        Dictionary<Integer, AbstractDebuggerCommand> dictionary = this.responseQueue;
        synchronized (dictionary) {
            this.responseQueue.put(sequence, cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommand(String cmdLine) {
        try {
            AbstractDebuggerCommand cmd;
            String[] cmdParsed = cmdLine.split("\t", 3);
            int cmdCode = Integer.parseInt(cmdParsed[0]);
            int seqCode = Integer.parseInt(cmdParsed[1]);
            String payload = cmdParsed[2];
            Dictionary<Integer, AbstractDebuggerCommand> dictionary = this.responseQueue;
            synchronized (dictionary) {
                cmd = this.responseQueue.remove(new Integer(seqCode));
            }
            if (cmd == null) {
                if (this.remote != null) {
                    this.remote.processCommand(cmdParsed[0], cmdParsed[1], payload);
                } else {
                    PydevDebugPlugin.log(4, "internal error, command received no target", null);
                }
            } else {
                cmd.processResponse(cmdCode, payload);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        HttpProtocolUtils httpProtocol = new HttpProtocolUtils();
        ICallback onUnexpectedMessage = unexpectedMessage -> {
            String msg = "It seems an old version of the PyDev Debugger is being used (please update the pydevd package being used).\n\nFound message:\n" + String.valueOf(unexpectedMessage);
            RunInUiThread.async(() -> PyDialogHelpers.openCritical((String)"Error", (String)msg));
            Log.log((String)msg);
            return null;
        };
        while (!this.done) {
            try {
                String contents = httpProtocol.readContents(this.in, onUnexpectedMessage);
                if (contents == null) {
                    this.done = true;
                } else if (contents.length() > 0) {
                    this.processCommand(contents.toString());
                }
            }
            catch (Exception e1) {
                this.done = true;
            }
            if (!this.done && this.socket != null && this.socket.isConnected()) continue;
            AbstractDebugTarget target = this.remote;
            if (target != null) {
                target.terminate();
            }
            this.done = true;
        }
    }
}

