/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.shared_core.string.StringUtils;

public class EvaluateExpressionCommand
extends AbstractDebuggerCommand {
    String locator;
    String expression;
    boolean isError = false;
    int responseCode;
    String payload;
    private boolean doExec;

    public EvaluateExpressionCommand(AbstractDebugTarget debugger, String expression, String locator, boolean doExec) {
        super(debugger);
        this.doExec = doExec;
        this.locator = locator;
        this.expression = StringUtils.removeNewLineChars((String)expression);
    }

    @Override
    public String getOutgoing() {
        int cmd = 113;
        if (this.doExec) {
            cmd = 115;
        }
        return EvaluateExpressionCommand.makeCommand(cmd, this.sequence, this.locator + "\t" + this.expression + "\t1");
    }

    @Override
    public boolean needResponse() {
        return true;
    }

    @Override
    public void processOKResponse(int cmdCode, String payload) {
        this.responseCode = cmdCode;
        if (cmdCode == 113 || cmdCode == 115) {
            this.payload = payload;
        } else {
            this.isError = true;
            PydevDebugPlugin.log(4, "Unexpected response to EvaluateExpressionCommand", null);
        }
    }

    @Override
    public void processErrorResponse(int cmdCode, String payload) {
        this.responseCode = cmdCode;
        this.payload = payload;
        this.isError = true;
    }

    public String getResponse() throws CoreException {
        if (this.isError) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "pydevd error:" + this.payload, null));
        }
        return this.payload;
    }
}

