/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;

public class GetCompletionsCommand
extends AbstractDebuggerCommand {
    private String actTok;
    private String locator;
    private boolean isError = false;
    private int responseCode;
    private String payload;

    public GetCompletionsCommand(AbstractDebugTarget debugger, String actTok, String locator) {
        super(debugger);
        this.locator = locator;
        this.actTok = actTok;
    }

    @Override
    public String getOutgoing() {
        int cmd = 120;
        return GetCompletionsCommand.makeCommand(cmd, this.sequence, this.locator + "\t" + this.actTok);
    }

    @Override
    public boolean needResponse() {
        return true;
    }

    @Override
    public void processOKResponse(int cmdCode, String payload) {
        this.responseCode = cmdCode;
        if (this.responseCode == 120) {
            this.payload = payload;
        } else {
            this.isError = true;
            PydevDebugPlugin.log(4, "Unexpected response to GetCompletionsCommand", null);
        }
    }

    @Override
    public void processErrorResponse(int cmdCode, String payload) {
        this.responseCode = cmdCode;
        this.payload = payload;
        this.isError = true;
    }

    public String getResponse() throws CoreException {
        if (this.isError) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "pydevd error:" + this.payload, null));
        }
        return this.payload;
    }
}

