/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.Color;
import org.python.pydev.debug.newconsole.prefs.ColorManager;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_interactive_console.console.ui.IConsoleStyleProvider;
import org.python.pydev.shared_interactive_console.console.ui.ScriptStyleRange;

public final class ConsoleStyleProvider
implements IConsoleStyleProvider {
    private final AnsiState err = new AnsiState();
    private final AnsiState out = new AnsiState();

    private ScriptStyleRange getIt(String content, int offset, TextAttribute attr, int scriptStyle) {
        Color background = attr.getBackground();
        return new ScriptStyleRange(offset, content.length(), attr.getForeground(), background, scriptStyle, attr.getStyle());
    }

    public Tuple<List<ScriptStyleRange>, String> createInterpreterStdStyle(String content, int offset, AnsiState ansiState, ColorManager colorManager, TextAttribute attr, int style) {
        Tuple ret = new Tuple(new ArrayList(), (Object)"");
        FastStringBuffer retBuf = new FastStringBuffer();
        if (ansiState.prevAttribute == null) {
            ansiState.prevAttribute = attr;
        }
        int len = content.length();
        int i = 0;
        while (i < len) {
            char c = content.charAt(i);
            if (ansiState.state == 1) {
                ansiState.escBuf.append(c);
                if (!Character.isDigit(c) && c != ';' && c != '[') {
                    String str = ansiState.escBuf.toString();
                    ansiState.prevAttribute = colorManager.getAnsiTextAttribute(str, ansiState.prevAttribute, attr);
                    ansiState.escBuf.clear();
                    ansiState.state = 0;
                }
            } else if (c == '\u001b') {
                int bufLen = ansiState.buf.length();
                if (bufLen > 0) {
                    ((List)ret.o1).add(this.getIt(ansiState.buf.toString(), offset, ansiState.prevAttribute, style));
                    retBuf.append(ansiState.buf);
                    offset += bufLen;
                    ansiState.buf.clear();
                }
                ansiState.state = 1;
            } else {
                ansiState.buf.append(c);
            }
            ++i;
        }
        int bufLen = ansiState.buf.length();
        if (bufLen > 0) {
            ((List)ret.o1).add(this.getIt(ansiState.buf.toString(), offset, ansiState.prevAttribute, style));
            retBuf.append(ansiState.buf);
            offset += bufLen;
            ansiState.buf.clear();
        }
        ret.o2 = retBuf.toString();
        return ret;
    }

    public Tuple<List<ScriptStyleRange>, String> createInterpreterErrorStyle(String content, int offset) {
        ColorManager colorManager = ColorManager.getDefault();
        TextAttribute attr = colorManager.getConsoleErrorTextAttribute();
        return this.createInterpreterStdStyle(content, offset, this.err, colorManager, attr, 3);
    }

    public Tuple<List<ScriptStyleRange>, String> createInterpreterOutputStyle(String content, int offset) {
        ColorManager colorManager = ColorManager.getDefault();
        TextAttribute attr = colorManager.getConsoleOutputTextAttribute();
        return this.createInterpreterStdStyle(content, offset, this.out, colorManager, attr, 2);
    }

    public ScriptStyleRange createPromptStyle(String content, int offset) {
        TextAttribute attr = ColorManager.getDefault().getConsolePromptTextAttribute();
        return this.getIt(content, offset, attr, 1);
    }

    public ScriptStyleRange createUserInputStyle(String content, int offset) {
        TextAttribute attr = ColorManager.getDefault().getConsoleInputTextAttribute();
        return this.getIt(content, offset, attr, 0);
    }

    private class AnsiState {
        private FastStringBuffer escBuf = new FastStringBuffer();
        private FastStringBuffer buf = new FastStringBuffer();
        private int state = 0;
        private static final int STATE_DEFAULT = 0;
        private static final int STATE_IN_ANSI = 1;
        private TextAttribute prevAttribute;

        private AnsiState() {
        }
    }
}

