/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsole;
import org.python.pydev.ast.codecompletion.PyCodeCompletionPreferences;
import org.python.pydev.core.autoedit.IHandleScriptAutoEditStrategy;
import org.python.pydev.core.autoedit.PyAutoIndentStrategy;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.newconsole.ConsoleStyleProvider;
import org.python.pydev.debug.newconsole.HandleBackspaceAction;
import org.python.pydev.debug.newconsole.PydevConsoleCompletionProcessor;
import org.python.pydev.debug.newconsole.PydevConsoleInterpreter;
import org.python.pydev.debug.newconsole.PydevConsoleQuickAssistProcessor;
import org.python.pydev.debug.newconsole.PydevScriptConsoleSourceViewerConfiguration;
import org.python.pydev.debug.newconsole.actions.LinkWithDebugSelectionAction;
import org.python.pydev.debug.newconsole.prefs.ColorManager;
import org.python.pydev.debug.newconsole.prefs.InteractiveConsolePrefs;
import org.python.pydev.debug.ui.PythonConsoleLineTracker;
import org.python.pydev.editor.codecompletion.PyContentAssistant;
import org.python.pydev.editor.correctionassist.PyCorrectionAssistant;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleInterpreter;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleShell;
import org.python.pydev.shared_interactive_console.console.ScriptConsolePrompt;
import org.python.pydev.shared_interactive_console.console.ui.DefaultScriptConsoleTextHover;
import org.python.pydev.shared_interactive_console.console.ui.IConsoleStyleProvider;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsole;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsoleMessages;
import org.python.pydev.shared_interactive_console.console.ui.internal.actions.AbstractHandleBackspaceAction;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class PydevConsole
extends ScriptConsole {
    public static final String CONSOLE_NAME = "PyDev Console";
    public static int nextId = -1;
    private String additionalInitialComands;
    private IProcess process = null;
    private LinkWithDebugSelectionAction linkWithDebugSelectionAction;

    private static String getNextId() {
        return String.valueOf(++nextId);
    }

    public PydevConsole(PydevConsoleInterpreter interpreter, String additionalInitialComands) {
        super("PyDev Console [" + PydevConsole.getNextId() + "]", "org.python.pydev.debug.newconsole.PydevConsole", (IScriptConsoleInterpreter)interpreter);
        this.additionalInitialComands = additionalInitialComands;
        boolean runNowIfInUiThread = true;
        RunInUiThread.async((Runnable)new Runnable(){

            @Override
            public void run() {
                PydevConsole.this.setPydevConsoleBackground(ColorManager.getDefault().getConsoleBackgroundColor());
            }
        }, (boolean)runNowIfInUiThread);
    }

    public IConsoleStyleProvider createStyleProvider() {
        return new ConsoleStyleProvider();
    }

    protected PydevConsoleCompletionProcessor createConsoleCompletionProcessor(ContentAssistant pyContentAssistant) {
        return new PydevConsoleCompletionProcessor((IScriptConsoleShell)this.interpreter, (PyContentAssistant)pyContentAssistant);
    }

    protected IQuickAssistProcessor createConsoleQuickAssistProcessor(QuickAssistAssistant quickAssist) {
        return new PydevConsoleQuickAssistProcessor((PyCorrectionAssistant)quickAssist);
    }

    public SourceViewerConfiguration createSourceViewerConfiguration() {
        PyContentAssistant contentAssist = new PyContentAssistant();
        PydevConsoleCompletionProcessor processor = this.createConsoleCompletionProcessor((ContentAssistant)contentAssist);
        contentAssist.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        contentAssist.enableAutoActivation(true);
        contentAssist.enableAutoInsert(false);
        contentAssist.setAutoActivationDelay(PyCodeCompletionPreferences.getAutocompleteDelay());
        PyCorrectionAssistant quickAssist = new PyCorrectionAssistant();
        IQuickAssistProcessor quickAssistProcessor = this.createConsoleQuickAssistProcessor((QuickAssistAssistant)quickAssist);
        quickAssist.setQuickAssistProcessor(quickAssistProcessor);
        PydevScriptConsoleSourceViewerConfiguration cfg = new PydevScriptConsoleSourceViewerConfiguration(this.createHover(), contentAssist, (IQuickAssistAssistant)quickAssist);
        return cfg;
    }

    protected ITextHover createHover() {
        return new DefaultScriptConsoleTextHover((IScriptConsoleShell)this.interpreter);
    }

    protected ScriptConsolePrompt createConsolePrompt() {
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        String newPrompt = store.getString("pydevconsole_new_invitation");
        String continuePrompt = store.getString("pydevconsole_continue_invitation");
        if (newPrompt == null || newPrompt.length() == 0) {
            newPrompt = ">>> ";
        }
        if (continuePrompt == null || continuePrompt.length() == 0) {
            continuePrompt = "... ";
        }
        return new ScriptConsolePrompt(newPrompt, continuePrompt);
    }

    public List<IConsoleLineTracker> createLineTrackers(TextConsole console) {
        return PydevConsole.staticCreateLineTrackers(console);
    }

    private static List<IConsoleLineTracker> staticCreateLineTrackers(final TextConsole console) {
        ArrayList<IConsoleLineTracker> lineTrackers = new ArrayList<IConsoleLineTracker>();
        PythonConsoleLineTracker lineTracker = new PythonConsoleLineTracker();
        lineTracker.init(new IConsole(){

            public void addLink(IConsoleHyperlink link, int offset, int length) {
                try {
                    console.addHyperlink((IHyperlink)link, offset, length);
                }
                catch (BadLocationException e) {
                    Log.log((Throwable)e);
                }
            }

            public void addLink(IHyperlink link, int offset, int length) {
                try {
                    console.addHyperlink(link, offset, length);
                }
                catch (BadLocationException e) {
                    Log.log((Throwable)e);
                }
            }

            public void addPatternMatchListener(IPatternMatchListener matchListener) {
                console.addPatternMatchListener(matchListener);
            }

            public IDocument getDocument() {
                return console.getDocument();
            }

            public IRegion getRegion(IConsoleHyperlink link) {
                return console.getRegion((IHyperlink)link);
            }

            public IRegion getRegion(IHyperlink link) {
                return console.getRegion(link);
            }

            public void removePatternMatchListener(IPatternMatchListener matchListener) {
                console.removePatternMatchListener(matchListener);
            }

            public void connect(IStreamsProxy streamsProxy) {
            }

            public void connect(IStreamMonitor streamMonitor, String streamIdentifer) {
            }

            public IProcess getProcess() {
                return null;
            }

            public IOConsoleOutputStream getStream(String streamIdentifier) {
                return null;
            }
        });
        lineTrackers.add(lineTracker);
        return lineTrackers;
    }

    public String getInitialCommands() {
        Object str = PydevDebugPlugin.getDefault().getPreferenceStore().getString("INITIAL_INTERPRETER_CMDS");
        try {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            str = manager.performStringSubstitution((String)str, false);
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        if (!((String)str).endsWith("\n")) {
            str = (String)str + "\n";
        }
        if (this.additionalInitialComands != null) {
            str = (String)str + this.additionalInitialComands;
        }
        return str;
    }

    public boolean getFocusOnStart() {
        return InteractiveConsolePrefs.getFocusConsoleOnStartup();
    }

    public boolean getTabCompletionEnabled() {
        return InteractiveConsolePrefs.getTabCompletionInInteractiveConsole();
    }

    public void addLink(IConsoleHyperlink link, int offset, int length) {
        this.addLink((IHyperlink)link, offset, length);
    }

    public void addLink(IHyperlink link, int offset, int length) {
        try {
            super.addHyperlink(link, offset, length);
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
    }

    public IProcess getProcess() {
        return this.process;
    }

    public void setProcess(IProcess process) {
        this.process = process;
    }

    public AbstractHandleBackspaceAction getBackspaceAction() {
        return new HandleBackspaceAction();
    }

    public void createActions(IToolBarManager toolbarManager) {
        if (this.getType().contains("PydevDebugConsole")) {
            this.linkWithDebugSelectionAction = new LinkWithDebugSelectionAction(this, ScriptConsoleMessages.LinkWithDebugAction, ScriptConsoleMessages.LinkWithDebugToolTip);
            toolbarManager.appendToGroup("scriptGroup", (IAction)this.linkWithDebugSelectionAction);
        }
    }

    public IHandleScriptAutoEditStrategy getAutoEditStrategy() {
        return new PyAutoIndentStrategy(new IAdaptable(){

            public <T> T getAdapter(Class<T> adapter) {
                return null;
            }
        });
    }
}

