/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcNoSuchHandlerException;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.webserver.WebServer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.ast.codecompletion.AbstractPyCodeCompletion;
import org.python.pydev.ast.codecompletion.PyCodeCompletionImages;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.concurrency.ConditionEvent;
import org.python.pydev.core.concurrency.ConditionEventWithValue;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.newconsole.IPydevConsoleDebugTarget;
import org.python.pydev.debug.newconsole.env.UserCanceledException;
import org.python.pydev.debug.newconsole.prefs.InteractiveConsolePrefs;
import org.python.pydev.editor.codefolding.PyCalltipsContextInformation;
import org.python.pydev.editorinput.PyOpenEditor;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.io.ThreadStreamReader;
import org.python.pydev.shared_core.process.ProcessUtils;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_interactive_console.console.IScriptConsoleCommunication;
import org.python.pydev.shared_interactive_console.console.IXmlRpcClient;
import org.python.pydev.shared_interactive_console.console.InterpreterResponse;
import org.python.pydev.shared_interactive_console.console.ScriptXmlRpcClient;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class PydevConsoleCommunication
implements IScriptConsoleCommunication,
XmlRpcHandler {
    private volatile IXmlRpcClient client;
    private WebServer webServer;
    private final String[] commandArray;
    private final String[] envp;
    private StdStreamsThread stdStreamsThread;
    private volatile boolean waitingForInput;
    private volatile String inputReceived;
    private volatile ConditionEventWithValue<InterpreterResponse> nextResponse = new ConditionEventWithValue(null, 20L);
    private volatile Object lock = new Object();
    private volatile boolean firstCommWorked = false;
    private final ConditionEvent finishedExecution;
    private IPydevConsoleDebugTarget debugTarget = null;
    private ICallback<Object, Tuple<String, String>> onContentsReceived;
    private volatile InterpreterResponse lastResponse = null;
    private final List<String> moreBuffer = new ArrayList<String>();

    public PydevConsoleCommunication(int port, final Process process, int clientPort, String[] commandArray, String[] envp, String encoding) throws Exception {
        this.commandArray = commandArray;
        this.envp = envp;
        this.finishedExecution = new ConditionEvent((ICallback0)new ICallback0<Boolean>(){

            public Boolean call() {
                try {
                    process.exitValue();
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }, 200L);
        this.webServer = new WebServer(clientPort);
        XmlRpcStreamServer serverToHandleRawInput = this.webServer.getXmlRpcServer();
        serverToHandleRawInput.setHandlerMapping(new XmlRpcHandlerMapping(){

            public XmlRpcHandler getHandler(String handlerName) throws XmlRpcNoSuchHandlerException, XmlRpcException {
                return PydevConsoleCommunication.this;
            }
        });
        this.webServer.start();
        this.stdStreamsThread = new StdStreamsThread(process, encoding);
        this.stdStreamsThread.start();
        ScriptXmlRpcClient client = new ScriptXmlRpcClient(process);
        client.setPort(port);
        this.client = client;
    }

    public void close() throws Exception {
        if (this.client != null) {
            Job job = new Job("Close console communication"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        PydevConsoleCommunication.this.client.execute("close", new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    PydevConsoleCommunication.this.client = null;
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        if (this.stdStreamsThread != null) {
            this.stdStreamsThread.stopLoop();
            this.stdStreamsThread = null;
        }
        if (this.webServer != null) {
            this.webServer.shutdown();
            this.webServer = null;
        }
    }

    public boolean isConnected() {
        return this.client != null;
    }

    public Object execute(XmlRpcRequest request) throws XmlRpcException {
        String methodName = request.getMethodName();
        if ("RequestInput".equals(methodName)) {
            return this.requestInput();
        }
        if ("IPythonEditor".equals(methodName)) {
            return this.openEditor(request);
        }
        if ("NotifyAboutMagic".equals(methodName)) {
            return "";
        }
        if ("NotifyFinished".equals(methodName)) {
            this.finishedExecution.set();
            return "";
        }
        Log.log((String)("Unexpected call to execute for method name: " + methodName));
        return "";
    }

    private Object openEditor(XmlRpcRequest request) {
        try {
            String filename = request.getParameter(0).toString();
            final int lineNumber = Integer.parseInt(request.getParameter(1).toString());
            final File fileToOpen = new File(filename);
            if (!fileToOpen.exists()) {
                FileOutputStream out = new FileOutputStream(fileToOpen);
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            RunInUiThread.async((Runnable)new Runnable(){

                @Override
                public void run() {
                    IEditorPart editor = PyOpenEditor.doOpenEditorOnFileStore((File)fileToOpen);
                    if (editor instanceof ITextEditor && lineNumber >= 0) {
                        EditorUtils.showInEditor((ITextEditor)((ITextEditor)editor), (int)lineNumber);
                    }
                }
            });
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object requestInput() {
        this.waitingForInput = true;
        this.inputReceived = null;
        boolean needInput = true;
        this.setNextResponse(new InterpreterResponse(false, needInput));
        while (this.inputReceived == null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(10L);
                }
                catch (InterruptedException e) {
                    Log.log((Throwable)e);
                }
            }
        }
        return this.inputReceived;
    }

    public void setOnContentsReceivedCallback(ICallback<Object, Tuple<String, String>> onContentsReceived) {
        this.onContentsReceived = onContentsReceived;
    }

    public void interrupt() {
        Job job = new Job("Interrupt console process"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PydevConsoleCommunication.this.lastResponse = null;
                    PydevConsoleCommunication.this.setNextResponse(new InterpreterResponse(false, false));
                    PydevConsoleCommunication.this.moreBuffer.clear();
                    PydevConsoleCommunication.this.client.execute("interrupt", new Object[0]);
                    if (PydevConsoleCommunication.this.waitingForInput) {
                        PydevConsoleCommunication.this.inputReceived = "";
                        PydevConsoleCommunication.this.waitingForInput = false;
                    }
                }
                catch (Exception e) {
                    Log.log((int)4, (String)"Problem interrupting python process", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void execInterpreter(String command, ICallback<Object, InterpreterResponse> onResponseReceived) {
        InterpreterResponse waitForSet;
        this.setNextResponse(null);
        if (this.waitingForInput) {
            this.inputReceived = command;
            this.waitingForInput = false;
        } else {
            Object executeCommand;
            if (this.lastResponse != null && !this.lastResponse.need_input && this.lastResponse.more && command.trim().length() > 0 && Character.isWhitespace(command.charAt(0))) {
                this.moreBuffer.add(command);
                onResponseReceived.call((Object)this.lastResponse);
                return;
            }
            if (this.moreBuffer.size() > 0) {
                executeCommand = StringUtils.join((String)"\n", this.moreBuffer) + "\n" + command;
                this.moreBuffer.clear();
            } else {
                executeCommand = command;
            }
            Job job = new Job("PyDev Console Communication", (String)executeCommand){
                private final /* synthetic */ String val$executeCommand;
                {
                    this.val$executeCommand = string;
                    super($anonymous0);
                }

                private boolean exec() throws XmlRpcException {
                    if (PydevConsoleCommunication.this.client == null) {
                        return false;
                    }
                    Object ret = PydevConsoleCommunication.this.client.execute(this.val$executeCommand.contains("\n") ? "execMultipleLines" : "execLine", new Object[]{this.val$executeCommand});
                    if (!(ret instanceof Boolean)) {
                        if (ret instanceof Object[]) {
                            Object[] objects = (Object[])ret;
                            ret = StringUtils.join((String)" ", (Object[])objects);
                        } else {
                            ret = String.valueOf(ret);
                        }
                        if (PydevConsoleCommunication.this.onContentsReceived != null) {
                            PydevConsoleCommunication.this.onContentsReceived.call((Object)new Tuple((Object)"", (Object)ret.toString()));
                        }
                        return false;
                    }
                    boolean more = (Boolean)ret;
                    return more;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    boolean needInput = false;
                    try {
                        if (!PydevConsoleCommunication.this.firstCommWorked) {
                            throw new Exception("hello must be called successfully before execInterpreter can be used.");
                        }
                        PydevConsoleCommunication.this.finishedExecution.unset();
                        boolean more = this.exec();
                        if (!more) {
                            PydevConsoleCommunication.this.finishedExecution.waitForSet();
                        }
                        PydevConsoleCommunication.this.setNextResponse(new InterpreterResponse(more, false));
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                        PydevConsoleCommunication.this.setNextResponse(new InterpreterResponse(false, false));
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        this.lastResponse = waitForSet = (InterpreterResponse)this.nextResponse.waitForSet();
        onResponseReceived.call((Object)waitForSet);
    }

    public ICompletionProposalHandle[] getCompletions(String text, String actTok, int offset, boolean showForTabCompletion) throws Exception {
        if (this.waitingForInput) {
            return new ICompletionProposalHandle[0];
        }
        Object fromServer = this.client.execute("getCompletions", new Object[]{text, actTok});
        ArrayList<ICompletionProposalHandle> ret = new ArrayList<ICompletionProposalHandle>();
        PydevConsoleCommunication.convertConsoleCompletionsToICompletions(text, actTok, offset, fromServer, ret, showForTabCompletion);
        ICompletionProposalHandle[] proposals = ret.toArray(new ICompletionProposalHandle[ret.size()]);
        return proposals;
    }

    public static void convertConsoleCompletionsToICompletions(String text, String actTok, int offset, Object fromServer, List<ICompletionProposalHandle> ret, boolean showForTabCompletion) {
        IFilterCompletion filter = null;
        if (actTok != null && actTok.indexOf("].") != -1) {
            filter = new IFilterCompletion(){

                @Override
                public boolean acceptCompletion(int type, ICompletionProposalHandle completion) {
                    return type != 11 || !completion.getDisplayString().startsWith(".");
                }
            };
        }
        PydevConsoleCommunication.convertToICompletions(text, actTok, offset, fromServer, ret, showForTabCompletion, filter);
    }

    private static void convertToICompletions(String text, String actTok, int offset, Object fromServer, List<ICompletionProposalHandle> ret, boolean showForTabCompletion, IFilterCompletion filter) {
        if (fromServer instanceof Object[]) {
            Object[] objects = (Object[])fromServer;
            fromServer = Arrays.asList(objects);
        }
        if (fromServer instanceof List) {
            int length = actTok.lastIndexOf(46);
            length = length == -1 ? actTok.length() : actTok.length() - length - 1;
            String trimmedText = text.trim();
            List<Object> comps = fromServer;
            for (Object o : comps) {
                if (!(o instanceof Object[])) continue;
                Object[] comp = (Object[])o;
                String name = (String)comp[0];
                String docStr = (String)comp[1];
                int type = PydevConsoleCommunication.extractInt(comp[3]);
                String args = AbstractPyCodeCompletion.getArgs((String)((String)comp[2]), (int)type, (ICompletionState.LookingFor)ICompletionState.LookingFor.LOOKING_FOR_INSTANCED_VARIABLE);
                String nameAndArgs = name + args;
                int priority = 10;
                if (type == 9) {
                    priority = -1;
                } else if (type == 5) {
                    priority = 0;
                } else if (type == 12) {
                    priority = 25;
                }
                int cursorPos = name.length();
                if (args.length() > 1) {
                    ++cursorPos;
                }
                int replacementOffset = offset - length;
                PyCalltipsContextInformation pyContextInformation = null;
                if (args.length() > 2) {
                    pyContextInformation = new PyCalltipsContextInformation(args, replacementOffset + name.length() + 1);
                } else if (name.length() > 0) {
                    if (name.charAt(0) == '%' && text.length() > 0 && text.charAt(0) == '%') {
                        --replacementOffset;
                    } else if (trimmedText.equals("cd") || trimmedText.startsWith("cd ") || trimmedText.equals("%cd") || trimmedText.startsWith("%cd ")) {
                        if (showForTabCompletion) {
                            replacementOffset = 0;
                            length = text.length();
                        } else if (name.charAt(0) == '/') {
                            char[] chars = text.toCharArray();
                            int i = 0;
                            while (i < chars.length) {
                                String sub;
                                char c = chars[i];
                                if (c == name.charAt(0) && name.startsWith(sub = text.substring(i, text.length()))) {
                                    replacementOffset -= sub.length() - FullRepIterable.getLastPart((String)actTok).length();
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                }
                ICompletionProposalHandle completion = CompletionProposalFactory.get().createPyLinkedModeCompletionProposal(nameAndArgs, replacementOffset, length, cursorPos, PyCodeCompletionImages.getImageForType((int)type), nameAndArgs, (Object)pyContextInformation, docStr, priority, 1, args, false, null);
                if (filter != null && !filter.acceptCompletion(type, completion)) continue;
                ret.add(completion);
            }
        }
    }

    private static int extractInt(Object objToGetInt) {
        if (objToGetInt instanceof Integer) {
            return (Integer)objToGetInt;
        }
        return Integer.parseInt(objToGetInt.toString());
    }

    public String getDescription(String text) throws Exception {
        if (this.waitingForInput) {
            return "Unable to get description: waiting for input.";
        }
        return this.client.execute("getDescription", new Object[]{text}).toString();
    }

    public void setDebugTarget(IPydevConsoleDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
    }

    public IPydevConsoleDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    private void setNextResponse(InterpreterResponse nextResponse) {
        this.nextResponse.set((Object)nextResponse);
        this.updateDebugTarget(nextResponse);
    }

    private void updateDebugTarget(InterpreterResponse nextResponse) {
        if (this.debugTarget != null) {
            if (nextResponse == null || nextResponse.need_input) {
                this.debugTarget.setSuspended(false);
            } else {
                this.debugTarget.setSuspended(true);
            }
        }
    }

    public void connectToDebugger(int localPort) throws Exception {
        Object[] resultarray;
        if (this.waitingForInput) {
            throw new Exception("Can't connect debugger now, waiting for input");
        }
        Object result = this.client.execute("connectToDebugger", new Object[]{localPort});
        Exception exception = null;
        if (result instanceof Object[] && (resultarray = (Object[])result).length == 1) {
            if ("connect complete".equals(resultarray[0])) {
                return;
            }
            if (resultarray[0] instanceof String) {
                exception = new Exception((String)resultarray[0]);
            }
            if (resultarray[0] instanceof Exception) {
                exception = (Exception)resultarray[0];
            }
        }
        throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "pydevconsole failed to execute connectToDebugger", exception));
    }

    public void hello(IProgressMonitor monitor) throws Exception, UserCanceledException {
        int maximumAttempts = InteractiveConsolePrefs.getMaximumAttempts();
        monitor.beginTask("Establishing Connection To Console Process", maximumAttempts);
        try {
            if (this.firstCommWorked) {
                return;
            }
            String result = null;
            int commAttempts = 0;
            while (commAttempts < maximumAttempts) {
                if (monitor.isCanceled()) {
                    throw new UserCanceledException("Canceled before hello was successful");
                }
                try {
                    Object resulta = this.client.execute("hello", new Object[]{"Hello pydevconsole"});
                    result = resulta instanceof String ? (String)resulta : StringUtils.join((String)"", (Object[])((Object[])resulta));
                }
                catch (XmlRpcException resulta) {
                    // empty catch block
                }
                if ("Hello eclipse".equals(result)) {
                    this.firstCommWorked = true;
                    break;
                }
                if (result.startsWith("Console already exited with value")) break;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException resulta) {
                    // empty catch block
                }
                monitor.worked(1);
                ++commAttempts;
            }
            if (!this.firstCommWorked) {
                String commandLine = this.commandArray != null ? ProcessUtils.getArgumentsAsStr((String[])this.commandArray, (String[])new String[0]) : "(unable to determine command line)";
                String environment = this.envp != null ? ProcessUtils.getEnvironmentAsStr((String[])this.envp) : "null";
                throw new Exception("Failed to recive suitable Hello response from pydevconsole. Last msg received: " + result + "\nCommand Line used: " + commandLine + "\n\nEnvironment:\n" + environment);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void linkWithDebugSelection(boolean isLinkedWithDebug) {
        throw new RuntimeException("Not implemented");
    }

    public void enableGui(String enableGuiName) throws Exception {
        if (this.waitingForInput) {
            throw new Exception("Can't connect debugger now, waiting for input");
        }
        this.client.execute("enableGui", new Object[]{enableGuiName});
    }

    public static interface IFilterCompletion {
        public boolean acceptCompletion(int var1, ICompletionProposalHandle var2);
    }

    private class StdStreamsThread
    extends Thread {
        private final ThreadStreamReader stdOutReader;
        private final ThreadStreamReader stdErrReader;
        private volatile boolean stopped = false;
        private final Object lock = new Object();

        public StdStreamsThread(Process process, String encoding) {
            this.setName("StdStreamsThread: " + String.valueOf(process));
            this.setDaemon(true);
            this.stdOutReader = new ThreadStreamReader(process.getInputStream(), true, encoding);
            this.stdErrReader = new ThreadStreamReader(process.getErrorStream(), true, encoding);
            this.stdOutReader.start();
            this.stdErrReader.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopped) {
                Object object = this.lock;
                synchronized (object) {
                    if (PydevConsoleCommunication.this.onContentsReceived != null) {
                        String stderrContents = this.stdErrReader.getAndClearContents();
                        String stdOutContents = this.stdOutReader.getAndClearContents();
                        if (stdOutContents.length() > 0 || stderrContents.length() > 0) {
                            PydevConsoleCommunication.this.onContentsReceived.call((Object)new Tuple((Object)stdOutContents, (Object)stderrContents));
                        }
                    }
                    try {
                        this.lock.wait(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopLoop() {
            this.stopped = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.stdOutReader.stopGettingOutput();
            this.stdErrReader.stopGettingOutput();
        }
    }
}

