/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.lang.ref.WeakReference;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.python.pydev.debug.pyunit.ClearTerminatedAction;
import org.python.pydev.debug.pyunit.ExportCurrentToClipboardAction;
import org.python.pydev.debug.pyunit.PyUnitTestRun;
import org.python.pydev.debug.pyunit.PyUnitView;
import org.python.pydev.debug.pyunit.PyUnitViewTestsHolder;
import org.python.pydev.debug.pyunit.RestoreFromClipboardAction;
import org.python.pydev.debug.pyunit.SetCurrentRunAction;
import org.python.pydev.shared_core.image.IImageDescriptor;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class HistoryAction
extends Action {
    private WeakReference<PyUnitView> view;

    public HistoryAction(PyUnitView view) {
        this.view = new WeakReference<PyUnitView>(view);
        this.setMenuCreator(new HistoryMenuCreator());
        this.setToolTipText("Test Run History");
        this.setImageDescriptor(ImageCache.asImageDescriptor((IImageDescriptor)SharedUiPlugin.getImageCache().getDescriptor("icons/history_list.gif")));
    }

    public class HistoryMenuCreator
    implements IMenuCreator {
        private Menu fMenu;

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            MenuManager manager = new MenuManager();
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(final IMenuManager manager2) {
                    HistoryMenuCreator.this.fillMenuManager(new IActionsMenu(){

                        @Override
                        public void add(IAction action) {
                            manager2.add(action);
                        }
                    });
                }
            });
            this.fMenu = manager.createContextMenu(parent);
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void fillMenuManager(IActionsMenu actionsMenu) {
            if (HistoryAction.this.view == null) {
                return;
            }
            PyUnitView pyUnitView = (PyUnitView)((Object)HistoryAction.this.view.get());
            if (pyUnitView == null) {
                return;
            }
            PyUnitTestRun currentTestRun = pyUnitView.getCurrentTestRun();
            List<PyUnitTestRun> allTestRuns = pyUnitView.getAllTestRuns();
            PyUnitTestRun lastPinned = PyUnitViewTestsHolder.getLastPinned();
            if (lastPinned != null) {
                SetCurrentRunAction runAction = new SetCurrentRunAction(HistoryAction.this.view, lastPinned);
                runAction.setChecked(false);
                runAction.setText("Last Pinned: " + lastPinned.getShortDescription());
                actionsMenu.add((IAction)runAction);
            }
            for (PyUnitTestRun pyUnitTestRun : allTestRuns) {
                SetCurrentRunAction runAction = new SetCurrentRunAction(HistoryAction.this.view, pyUnitTestRun);
                runAction.setChecked(pyUnitTestRun == currentTestRun);
                runAction.setText(pyUnitTestRun.getShortDescription());
                actionsMenu.add((IAction)runAction);
            }
            actionsMenu.add((IAction)new ClearTerminatedAction(HistoryAction.this.view));
            actionsMenu.add((IAction)new ExportCurrentToClipboardAction(HistoryAction.this.view));
            actionsMenu.add((IAction)new RestoreFromClipboardAction(HistoryAction.this.view));
        }
    }

    public static interface IActionsMenu {
        public void add(IAction var1);
    }
}

