/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IHyperlink;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.newconsole.prefs.ColorManager;
import org.python.pydev.debug.pyunit.CounterPanel;
import org.python.pydev.debug.pyunit.HistoryAction;
import org.python.pydev.debug.pyunit.IPyUnitLaunch;
import org.python.pydev.debug.pyunit.IPyUnitServer;
import org.python.pydev.debug.pyunit.InformationPresenterWithLineTracker;
import org.python.pydev.debug.pyunit.PinHistoryAction;
import org.python.pydev.debug.pyunit.PyUnitProgressBar;
import org.python.pydev.debug.pyunit.PyUnitSortListener;
import org.python.pydev.debug.pyunit.PyUnitTestResult;
import org.python.pydev.debug.pyunit.PyUnitTestRun;
import org.python.pydev.debug.pyunit.PyUnitTestStarted;
import org.python.pydev.debug.pyunit.PyUnitViewServerListener;
import org.python.pydev.debug.pyunit.PyUnitViewTestsHolder;
import org.python.pydev.debug.pyunit.RelaunchAction;
import org.python.pydev.debug.pyunit.RelaunchErrorsAction;
import org.python.pydev.debug.pyunit.RelaunchInBackgroundAction;
import org.python.pydev.debug.pyunit.RestorePinHistoryAction;
import org.python.pydev.debug.pyunit.ShowOnlyFailuresAction;
import org.python.pydev.debug.pyunit.ShowTestRunnerPreferencesAction;
import org.python.pydev.debug.pyunit.ShowViewOnTestRunAction;
import org.python.pydev.debug.pyunit.StopAction;
import org.python.pydev.debug.ui.ILinkContainer;
import org.python.pydev.debug.ui.PythonConsoleLineTracker;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.callbacks.ICallbackWithListeners;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_interactive_console.console.ui.internal.ClipboardHandler;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.tooltips.presenter.StyleRangeWithCustomData;
import org.python.pydev.shared_ui.tooltips.presenter.ToolTipPresenterHandler;
import org.python.pydev.shared_ui.utils.IViewWithControls;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.shared_ui.utils.UIUtils;
import org.python.pydev.ui.ColorAndStyleCache;
import org.python.pydev.ui.NotifyViewCreated;
import org.python.pydev.ui.ViewPartWithOrientation;

public class PyUnitView
extends ViewPartWithOrientation
implements IViewWithControls {
    public static final String PYUNIT_VIEW_ORIENTATION = "PYUNIT_VIEW_ORIENTATION";
    public static final String PY_UNIT_TEST_RESULT = "RESULT";
    private static final String PY_UNIT_VIEW_ID = "org.python.pydev.debug.pyunit.pyUnitView";
    public static final String PYUNIT_VIEW_SHOW_ONLY_ERRORS = "PYUNIT_VIEW_SHOW_ONLY_ERRORS";
    public static final boolean PYUNIT_VIEW_DEFAULT_SHOW_ONLY_ERRORS = true;
    public static final String PYUNIT_VIEW_SHOW_VIEW_ON_TEST_RUN = "PYUNIT_VIEW_SHOW_VIEW_ON_TEST_RUN";
    public static final boolean PYUNIT_VIEW_DEFAULT_SHOW_VIEW_ON_TEST_RUN = true;
    public static final String PYUNIT_VIEW_BACKGROUND_RELAUNCH_SHOW_ONLY_ERRORS = "PYUNIT_VIEW_BACKGROUND_RELAUNCH_SHOW_ONLY_ERRORS";
    public static final boolean PYUNIT_VIEW_DEFAULT_BACKGROUND_RELAUNCH_SHOW_ONLY_ERRORS = false;
    public static int MAX_RUNS_TO_KEEP = PyUnitViewTestsHolder.MAX_RUNS_TO_KEEP;
    private PyUnitTestRun currentRun;
    private final ActivateLinkmouseListener activateLinkmouseListener = new ActivateLinkmouseListener();
    private ILinkContainer iLinkContainer = new ILinkContainer(){

        @Override
        public void addLink(IHyperlink link, int offset, int length) {
            if (PyUnitView.this.testOutputText == null) {
                return;
            }
            StyleRangeWithCustomData range = new StyleRangeWithCustomData();
            range.underline = true;
            try {
                range.underlineStyle = 4;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            TextAttribute textAttribute = ColorManager.getDefault().getHyperlinkTextAttribute();
            range.foreground = textAttribute != null ? textAttribute.getForeground() : JFaceColors.getHyperlinkText((Display)Display.getDefault());
            range.start = offset;
            range.length = length + 1;
            range.customData = link;
            PyUnitView.this.testOutputText.setStyleRange((StyleRange)range);
        }

        @Override
        public String getContents(int lineOffset, int lineLength) throws BadLocationException {
            if (PyUnitView.this.testOutputText == null) {
                return "";
            }
            if (lineLength <= 0) {
                return "";
            }
            try {
                return PyUnitView.this.testOutputText.getText(lineOffset, lineOffset + lineLength);
            }
            catch (IllegalArgumentException e) {
                return "";
            }
        }
    };
    static final int COL_INDEX = 0;
    static final int COL_RESULT = 1;
    static final int COL_TEST = 2;
    static final int COL_FILENAME = 3;
    static final int COL_TIME = 4;
    static final int NUMBER_OF_COLUMNS = 5;
    private static final NumberFormatException NUMBER_FORMAT_EXCEPTION = new NumberFormatException();
    private ColorAndStyleCache colorAndStyleCache;
    private SashForm sash;
    private Tree tree;
    private StyledText testOutputText;
    private CounterPanel fCounterPanel;
    private PyUnitProgressBar fProgressBar;
    private Label fStatus;
    private Composite fCounterComposite;
    private IPropertyChangeListener prefListener;
    private PinHistoryAction fPinHistory = new PinHistoryAction(this);
    private boolean showOnlyErrors;
    TreeColumn colIndex;
    TreeColumn colResult;
    TreeColumn colTest;
    TreeColumn colFile;
    TreeColumn colTime;
    private boolean disposed = false;
    private final FastStringBuffer tempOnSelectResult = new FastStringBuffer();
    private final String ERRORS_HEADER = "============================= ERRORS =============================\n";
    private final String CAPTURED_OUTPUT_HEADER = "======================== CAPTURED OUTPUT =========================\n";
    private boolean onlyCreateLinksForExistingFiles = true;

    public String getOrientationPreferencesKey() {
        return PYUNIT_VIEW_ORIENTATION;
    }

    public PyUnitView() {
        this.currentRun = PyUnitViewTestsHolder.getCurrentTest();
        if (!SharedCorePlugin.inTestMode()) {
            PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
            IPreferenceStore preferenceStore = plugin.getPreferenceStore();
            this.showOnlyErrors = preferenceStore.getBoolean(PYUNIT_VIEW_SHOW_ONLY_ERRORS);
        }
        NotifyViewCreated.notifyViewCreated((IViewWithControls)this);
    }

    public PyUnitProgressBar getProgressBar() {
        return this.fProgressBar;
    }

    public CounterPanel getCounterPanel() {
        return this.fCounterPanel;
    }

    public Tree getTree() {
        return this.tree;
    }

    public void createPartControl(Composite parent) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        super.createPartControl(parent);
        InformationPresenterWithLineTracker presenter = new InformationPresenterWithLineTracker();
        ToolTipPresenterHandler tooltip = new ToolTipPresenterHandler(parent.getShell(), (DefaultInformationControl.IInformationPresenter)presenter);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        this.configureToolBar();
        this.fCounterComposite = new Composite(parent, 0);
        layout = new GridLayout();
        this.fCounterComposite.setLayout((Layout)layout);
        this.fCounterComposite.setLayoutData((Object)new GridData(768));
        this.fCounterPanel = new CounterPanel(this.fCounterComposite);
        this.fCounterPanel.setLayoutData(new GridData(768));
        this.fProgressBar = new PyUnitProgressBar(this.fCounterComposite);
        this.fProgressBar.setLayoutData(new GridData(768));
        this.fStatus = new Label(this.fCounterComposite, 0);
        GridData statusLayoutData = new GridData(768);
        statusLayoutData.grabExcessHorizontalSpace = true;
        this.fStatus.setLayoutData((Object)statusLayoutData);
        this.fStatus.setText("Status");
        this.sash = new SashForm(parent, 256);
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.sash.setLayoutData((Object)layoutData);
        this.tree = new Tree((Composite)this.sash, 65538);
        tooltip.install((Control)this.tree);
        this.tree.setHeaderVisible(true);
        PyUnitSortListener sortListener = new PyUnitSortListener(this);
        this.colIndex = this.createColumn(" ", 50, sortListener);
        this.colResult = this.createColumn("Result", 70, sortListener);
        this.colTest = this.createColumn("Test", 180, sortListener);
        this.colFile = this.createColumn("File", 180, sortListener);
        this.colTime = this.createColumn("Time (s)", 80, sortListener);
        this.onControlCreated.call((Object)this.tree);
        this.tree.setSortColumn(this.colIndex);
        this.tree.setSortDirection(1024);
        this.tree.addMouseListener((MouseListener)new DoubleClickTreeItemMouseListener());
        this.tree.addKeyListener((KeyListener)new EnterProssedTreeItemKeyListener());
        this.tree.addSelectionListener((SelectionListener)new SelectResultSelectionListener());
        Menu menu = new Menu((Decorations)this.tree.getShell(), 8);
        MenuItem runItem = new MenuItem(menu, 8);
        runItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PyUnitView.this.relaunchSelectedTests("run");
            }
        });
        runItem.setText("Run");
        MenuItem debugItem = new MenuItem(menu, 8);
        debugItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PyUnitView.this.relaunchSelectedTests("debug");
            }
        });
        debugItem.setText("Debug");
        this.tree.setMenu(menu);
        if (PydevPlugin.getDefault() != null) {
            this.colorAndStyleCache = new ColorAndStyleCache(PyDevUiPrefs.getChainedPrefStore());
            this.prefListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property;
                    if (PyUnitView.this.tree != null && ColorAndStyleCache.isColorOrStyleProperty((String)(property = event.getProperty()))) {
                        TreeItem[] items;
                        PyUnitView.this.colorAndStyleCache.reloadProperty(property);
                        Color errorColor = PyUnitView.this.getErrorColor();
                        TreeItem[] treeItemArray = items = PyUnitView.this.tree.getItems();
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            PyUnitTestResult result = (PyUnitTestResult)item.getData(PyUnitView.PY_UNIT_TEST_RESULT);
                            if (result != null && !result.isOk() && !result.isSkip()) {
                                item.setForeground(errorColor);
                            }
                            ++n2;
                        }
                        if (PyUnitView.this.fProgressBar != null) {
                            PyUnitView.this.fProgressBar.updateErrorColor(true);
                        }
                    }
                }
            };
            PyDevUiPrefs.getChainedPrefStore().addPropertyChangeListener(this.prefListener);
        }
        StyledText text = new StyledText((Composite)this.sash, 778);
        text.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
        this.setTextComponent(text);
        this.onTestRunAdded();
    }

    private void configureToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        IMenuManager menuManager = actionBars.getMenuManager();
        ShowViewOnTestRunAction showViewOnTestRunAction = new ShowViewOnTestRunAction(this);
        menuManager.add((IAction)showViewOnTestRunAction);
        ShowTestRunnerPreferencesAction showTestRunnerPreferencesAction = new ShowTestRunnerPreferencesAction(this);
        menuManager.add((IAction)showTestRunnerPreferencesAction);
        ShowOnlyFailuresAction action = new ShowOnlyFailuresAction(this);
        toolBar.add((IAction)action);
        action.setChecked(this.showOnlyErrors);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)new RelaunchAction(this));
        toolBar.add((IAction)new RelaunchErrorsAction(this));
        toolBar.add((IAction)new StopAction(this));
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)new RelaunchInBackgroundAction(this));
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)new HistoryAction(this));
        toolBar.add((IAction)this.fPinHistory);
        toolBar.add((IAction)new RestorePinHistoryAction(this));
        this.addOrientationPreferences(menuManager);
    }

    protected void setNewOrientation(int orientation) {
        if (this.sash != null && !this.sash.isDisposed() && this.fCounterComposite != null && !this.fCounterComposite.isDisposed()) {
            GridLayout layout = (GridLayout)this.fCounterComposite.getLayout();
            if (orientation == 1) {
                this.sash.setOrientation(256);
                layout.numColumns = 2;
            } else {
                this.sash.setOrientation(512);
                layout.numColumns = 1;
            }
            this.fParent.layout();
        }
    }

    private TreeColumn createColumn(String text, int width, Listener sortListener) {
        TreeColumn col = new TreeColumn(this.tree, 16384);
        col.setText(text);
        col.setWidth(width);
        col.setMoveable(true);
        col.addListener(13, sortListener);
        return col;
    }

    public void setFocus() {
        this.tree.setFocus();
    }

    public void dispose() {
        Tree t;
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.tree != null) {
            t = this.tree;
            this.tree = null;
            this.onControlDisposed.call((Object)t);
            t.dispose();
        }
        if (this.testOutputText != null) {
            t = this.testOutputText;
            this.testOutputText = null;
            this.onControlDisposed.call((Object)t);
            t.dispose();
        }
        if (this.fCounterPanel != null) {
            this.fCounterPanel.dispose();
            this.fCounterPanel = null;
        }
        if (this.prefListener != null) {
            PyDevUiPrefs.getChainedPrefStore().removePropertyChangeListener(this.prefListener);
            this.prefListener = null;
        }
        super.dispose();
    }

    public static PyUnitViewServerListener registerPyUnitServer(IPyUnitServer pyUnitServer) {
        return PyUnitView.registerPyUnitServer(pyUnitServer, true);
    }

    public static PyUnitViewServerListener registerPyUnitServer(IPyUnitServer pyUnitServer, boolean async) {
        PyUnitViewServerListener serverListener = new PyUnitViewServerListener(pyUnitServer, pyUnitServer.getPyUnitLaunch());
        PyUnitViewTestsHolder.addServerListener(serverListener);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    PyUnitView view = PyUnitView.getView();
                    if (view != null) {
                        view.onTestRunAdded();
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        };
        if (async) {
            Display.getDefault().asyncExec(r);
        } else {
            Display.getDefault().syncExec(r);
        }
        return serverListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTestRunAdded() {
        Object object = PyUnitViewTestsHolder.lockServerListeners;
        synchronized (object) {
            for (PyUnitViewServerListener listener : PyUnitViewTestsHolder.serverListeners) {
                listener.setView(this);
            }
            if (PyUnitViewTestsHolder.serverListeners.size() > 0) {
                this.setCurrentRun(PyUnitViewTestsHolder.serverListeners.getLast().getTestRun());
            }
        }
    }

    public static PyUnitView getView() {
        return (PyUnitView)UIUtils.getView((String)PY_UNIT_VIEW_ID, (boolean)ShowViewOnTestRunAction.getShowViewOnTestRun());
    }

    void notifyFinished(PyUnitTestRun testRun) {
        if (this.disposed) {
            return;
        }
        if (testRun.savedDiskIndex == null) {
            PyUnitViewTestsHolder.saveDiskIndexJob.schedule(20L);
        }
        if (testRun != this.currentRun) {
            return;
        }
        this.asyncUpdateCountersAndBar();
    }

    void notifyTest(PyUnitTestResult result) {
        if (this.disposed) {
            return;
        }
        this.notifyTest(result, true);
    }

    void notifyTestStarted(PyUnitTestStarted result) {
        if (this.disposed) {
            return;
        }
        if (result.getTestRun() != this.currentRun) {
            return;
        }
        this.asyncUpdateCountersAndBar();
    }

    void notifyTestsCollected(PyUnitTestRun testRun) {
        if (this.disposed) {
            return;
        }
        if (testRun != this.currentRun) {
            return;
        }
        this.asyncUpdateCountersAndBar();
    }

    public void asyncUpdateCountersAndBar() {
        RunInUiThread.async((Runnable)new Runnable(){

            @Override
            public void run() {
                PyUnitView.this.updateCountersAndBar();
            }
        });
    }

    private void notifyTest(PyUnitTestResult result, boolean updateBar) {
        if (this.disposed) {
            return;
        }
        if (result.getTestRun() != this.currentRun) {
            return;
        }
        if (!this.showOnlyErrors || this.showOnlyErrors && !result.isOk() && !result.isSkip()) {
            TreeItem treeItem = new TreeItem(this.tree, 0);
            File file = new File(result.location);
            treeItem.setText(new String[]{result.index, result.status, result.test, file.getName(), result.time});
            if (!result.isOk() && !result.isSkip()) {
                Color errorColor = this.getErrorColor();
                treeItem.setForeground(errorColor);
            }
            treeItem.setData("TIP_DATA", (Object)result);
            treeItem.setData(PY_UNIT_TEST_RESULT, (Object)result);
            int selectionCount = this.tree.getSelectionCount();
            if (selectionCount == 0) {
                this.tree.setSelection(treeItem);
                this.onSelectResult(result);
            }
        }
        if (updateBar) {
            this.updateCountersAndBar();
        }
    }

    public Color getErrorColor() {
        TextAttribute attribute = ColorManager.getDefault().getConsoleErrorTextAttribute();
        if (attribute == null) {
            return null;
        }
        Color errorColor = attribute.getForeground();
        return errorColor;
    }

    public Color getForegroundColor() {
        TextAttribute attribute = ColorManager.getDefault().getForegroundTextAttribute();
        if (attribute == null) {
            return null;
        }
        Color errorColor = attribute.getForeground();
        return errorColor;
    }

    private void updateCountersAndBar() {
        if (this.fCounterPanel == null) {
            return;
        }
        if (this.currentRun != null) {
            String totalNumberOfRuns = this.currentRun.getTotalNumberOfRuns();
            int numberOfRuns = this.currentRun.getNumberOfRuns();
            int numberOfErrors = this.currentRun.getNumberOfErrors();
            int numberOfFailures = this.currentRun.getNumberOfFailures();
            try {
                int totalAsInt = this.currentRun.getFinished() ? numberOfRuns : Integer.parseInt(totalNumberOfRuns);
                if (totalAsInt == 0 && numberOfRuns > 0) {
                    totalNumberOfRuns = "?";
                    throw NUMBER_FORMAT_EXCEPTION;
                }
                this.fProgressBar.reset(numberOfErrors + numberOfFailures > 0, false, numberOfRuns, totalAsInt);
            }
            catch (NumberFormatException e) {
                this.setShowBarWithError(numberOfErrors + numberOfFailures > 0, numberOfRuns > 0, this.currentRun.getFinished());
            }
            this.fCounterPanel.setRunValue(numberOfRuns, totalNumberOfRuns);
            this.fCounterPanel.setErrorValue(numberOfErrors);
            this.fCounterPanel.setFailureValue(numberOfFailures);
            String totalTime = this.currentRun.getTotalTime();
            if (totalTime == null) {
                Collection<PyUnitTestStarted> testsRunning = this.currentRun.getTestsRunning();
                FastStringBuffer bufStatus = new FastStringBuffer("Current: ", 200);
                FastStringBuffer bufTooltip = new FastStringBuffer("Current: ", 200);
                int i = 0;
                for (PyUnitTestStarted pyUnitTestStarted : testsRunning) {
                    if (i > 0) {
                        bufTooltip.append('\n');
                    }
                    bufTooltip.append(pyUnitTestStarted.test);
                    bufTooltip.append("  ");
                    bufTooltip.append('(');
                    bufTooltip.append(pyUnitTestStarted.location);
                    bufTooltip.append(')');
                    if (i > 0) {
                        bufStatus.append(", ");
                    }
                    bufStatus.append(pyUnitTestStarted.test);
                    ++i;
                }
                this.fStatus.setText(bufStatus.toString());
                this.fStatus.setToolTipText(bufTooltip.toString());
            } else {
                this.fStatus.setText(totalTime);
                this.fStatus.setToolTipText(totalTime);
            }
        } else {
            this.fStatus.setText("");
            this.fStatus.setToolTipText("");
            this.fCounterPanel.setRunValue(0, "0");
            this.fCounterPanel.setErrorValue(0);
            this.fCounterPanel.setFailureValue(0);
            this.setShowBarWithError(false, false, false);
        }
    }

    private void setShowBarWithError(boolean hasError, boolean hasRuns, boolean finished) {
        this.fProgressBar.reset(hasError, false, hasRuns ? 1 : 0, finished ? 1 : 2);
    }

    void onSelectResult(PyUnitTestResult result) {
        IPyUnitLaunch pyUnitLaunch;
        this.tempOnSelectResult.clear();
        boolean addedErrors = false;
        if (result != null) {
            if (result.errorContents != null && result.errorContents.length() > 0) {
                addedErrors = true;
                this.tempOnSelectResult.append("============================= ERRORS =============================\n");
                this.tempOnSelectResult.append(result.errorContents);
            }
            if (result.capturedOutput != null && result.capturedOutput.length() > 0) {
                if (this.tempOnSelectResult.length() > 0) {
                    this.tempOnSelectResult.append("\n");
                }
                this.tempOnSelectResult.append("======================== CAPTURED OUTPUT =========================\n");
                this.tempOnSelectResult.append(result.capturedOutput);
            }
        }
        String string = this.tempOnSelectResult.toString();
        this.testOutputText.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
        this.testOutputText.setText(string + "\n\n\n");
        this.testOutputText.setStyleRange(new StyleRange());
        if (addedErrors) {
            StyleRange range = new StyleRange();
            TextAttribute errorTextAttribute = ColorManager.getDefault().getConsoleErrorTextAttribute();
            if (errorTextAttribute != null) {
                range.foreground = errorTextAttribute.getForeground();
            }
            range.start = "============================= ERRORS =============================\n".length();
            range.length = result.errorContents.length();
            this.testOutputText.setStyleRange(range);
        }
        PythonConsoleLineTracker lineTracker = new PythonConsoleLineTracker();
        ILaunchConfiguration launchConfiguration = null;
        PyUnitTestRun testRun = result.getTestRun();
        if (testRun != null && (pyUnitLaunch = testRun.getPyUnitLaunch()) != null) {
            launchConfiguration = pyUnitLaunch.getLaunchConfiguration();
        }
        lineTracker.init(launchConfiguration, this.iLinkContainer);
        lineTracker.setOnlyCreateLinksForExistingFiles(this.onlyCreateLinksForExistingFiles);
        lineTracker.splitInLinesAndAppendToLineTracker(string);
    }

    public void onTriggerGoToTest() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection.length >= 1) {
            PyUnitTestResult result = (PyUnitTestResult)selection[0].getData(PY_UNIT_TEST_RESULT);
            result.open();
        }
    }

    public void relaunchSelectedTests(String mode) {
        TreeItem[] selection = this.tree.getSelection();
        ArrayList<PyUnitTestResult> resultsToRelaunch = new ArrayList<PyUnitTestResult>();
        PyUnitTestRun testRun = null;
        TreeItem[] treeItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                PyUnitTestResult result;
                block6: {
                    block5: {
                        TreeItem item = treeItemArray[n2];
                        result = (PyUnitTestResult)item.getData(PY_UNIT_TEST_RESULT);
                        if (testRun != null) break block5;
                        testRun = result.getTestRun();
                        break block6;
                    }
                    if (result.getTestRun() != testRun) break block7;
                }
                resultsToRelaunch.add(result);
            }
            ++n2;
        }
        if (resultsToRelaunch.size() > 0 && testRun != null) {
            testRun.relaunch(resultsToRelaunch, mode);
        }
    }

    public PyUnitTestRun getCurrentTestRun() {
        return this.currentRun;
    }

    public void setCurrentRun(PyUnitTestRun testRun) {
        this.currentRun = testRun;
        PyUnitViewTestsHolder.setCurrentTest(testRun);
        this.tree.setRedraw(false);
        try {
            this.tree.removeAll();
            this.testOutputText.setText("");
            if (testRun != null) {
                List<PyUnitTestResult> sharedResultsList = testRun.getSharedResultsList();
                for (PyUnitTestResult result : sharedResultsList) {
                    this.notifyTest(result, false);
                }
            }
            this.updateCountersAndBar();
        }
        finally {
            this.tree.setRedraw(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PyUnitTestRun> getAllTestRuns() {
        Object object = PyUnitViewTestsHolder.lockServerListeners;
        synchronized (object) {
            ArrayList<PyUnitTestRun> ret = new ArrayList<PyUnitTestRun>();
            for (PyUnitViewServerListener listener : PyUnitViewTestsHolder.serverListeners) {
                ret.add(listener.getTestRun());
            }
            return ret;
        }
    }

    public void setShowOnlyErrors(boolean b) {
        this.showOnlyErrors = b;
        PydevDebugPlugin.getDefault().getPreferenceStore().setValue(PYUNIT_VIEW_SHOW_ONLY_ERRORS, b);
        this.setCurrentRun(this.currentRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllTerminated() {
        Object object = PyUnitViewTestsHolder.lockServerListeners;
        synchronized (object) {
            boolean removedCurrent = false;
            Iterator it = PyUnitViewTestsHolder.serverListeners.iterator();
            while (it.hasNext()) {
                PyUnitTestRun next = ((PyUnitViewServerListener)it.next()).getTestRun();
                if (!next.getFinished()) continue;
                if (next == this.currentRun) {
                    removedCurrent = true;
                }
                it.remove();
            }
            if (removedCurrent) {
                if (PyUnitViewTestsHolder.serverListeners.size() > 0) {
                    this.setCurrentRun(PyUnitViewTestsHolder.serverListeners.getFirst().getTestRun());
                } else {
                    this.setCurrentRun(null);
                }
            }
        }
    }

    void setTextComponent(StyledText text) {
        this.testOutputText = text;
        this.onControlCreated.call((Object)text);
        text.addMouseListener((MouseListener)this.activateLinkmouseListener);
    }

    public ICallbackWithListeners getOnControlCreated() {
        return this.onControlCreated;
    }

    public ICallbackWithListeners getOnControlDisposed() {
        return this.onControlDisposed;
    }

    public void exportCurrentToClipboard() {
        PyUnitTestRun curr = this.currentRun;
        if (curr == null) {
            return;
        }
        String str = curr.toXML();
        if (str.length() > 0) {
            new ClipboardHandler().putIntoClipboard(1, Display.getCurrent(), str);
        }
    }

    public void restoreFromClipboard() {
        try {
            String clipboardContents = ClipboardHandler.getClipboardContents();
            PyUnitTestRun testRunRestored = PyUnitTestRun.fromXML(clipboardContents);
            PyUnitViewTestsHolder.DummyPyUnitServer pyUnitServer = new PyUnitViewTestsHolder.DummyPyUnitServer(testRunRestored.getPyUnitLaunch());
            PyUnitViewServerListener serverListener = new PyUnitViewServerListener((IPyUnitServer)pyUnitServer, testRunRestored);
            PyUnitViewTestsHolder.addServerListener(serverListener);
            this.setCurrentRun(testRunRestored);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            Status status = SharedCorePlugin.makeStatus((int)4, (String)e.getMessage(), (Throwable)e);
            ErrorDialog.openError((Shell)EditorUtils.getShell(), (String)"Error restoring tests from clipboard", (String)"Error restoring tests from clipboard", (IStatus)status);
        }
    }

    public void setOnlyCreateLinksForExistingFiles(boolean b) {
        this.onlyCreateLinksForExistingFiles = b;
    }

    private static final class ActivateLinkmouseListener
    extends MouseAdapter {
        private ActivateLinkmouseListener() {
        }

        public void mouseUp(MouseEvent e) {
            StyleRange styleRangeAtOffset;
            StyledText styledText;
            int offset;
            Widget w = e.widget;
            if (w instanceof StyledText && (offset = (styledText = (StyledText)w).getCaretOffset()) >= 0 && offset < styledText.getCharCount() && (styleRangeAtOffset = styledText.getStyleRangeAtOffset(offset)) instanceof StyleRangeWithCustomData) {
                StyleRangeWithCustomData styleRangeWithCustomData = (StyleRangeWithCustomData)styleRangeAtOffset;
                Object l = styleRangeWithCustomData.customData;
                if (l instanceof IHyperlink) {
                    ((IHyperlink)l).linkActivated();
                }
            }
        }
    }

    private final class DoubleClickTreeItemMouseListener
    extends MouseAdapter {
        private DoubleClickTreeItemMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (e.widget == PyUnitView.this.tree) {
                PyUnitView.this.onTriggerGoToTest();
            }
        }
    }

    private final class EnterProssedTreeItemKeyListener
    extends KeyAdapter {
        private EnterProssedTreeItemKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.widget == PyUnitView.this.tree && (e.keyCode == 10 || e.keyCode == 13 || e.keyCode == 0x1000050)) {
                PyUnitView.this.onTriggerGoToTest();
            }
        }
    }

    private final class SelectResultSelectionListener
    extends SelectionAdapter {
        private SelectResultSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.item != null) {
                PyUnitTestResult result = (PyUnitTestResult)e.item.getData(PyUnitView.PY_UNIT_TEST_RESULT);
                PyUnitView.this.onSelectResult(result);
            }
        }
    }
}

