/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.actions.AbstractBreakpointRulerAction;

public class EnableDisableBreakpointRulerAction
extends AbstractBreakpointRulerAction {
    public EnableDisableBreakpointRulerAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        this.fInfo = rulerInfo;
        this.fTextEditor = editor;
    }

    public void update() {
        IBreakpoint breakpoint = this.getBreakpointFromLastLineOfActivityInCurrentEditor();
        this.setBreakpoint(breakpoint);
        if (breakpoint == null) {
            this.setEnabled(false);
            this.setText("&Disable Breakpoint");
        } else {
            this.setEnabled(true);
            try {
                boolean enabled = breakpoint.isEnabled();
                this.setText(enabled ? "&Disable Breakpoint" : "&Enable Breakpoint");
            }
            catch (CoreException ce) {
                PydevDebugPlugin.log(4, ce.getLocalizedMessage(), ce);
            }
        }
    }

    public void run() {
        final IBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint != null) {
            new Job("Enabling / Disabling Breakpoint"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        breakpoint.setEnabled(!breakpoint.isEnabled());
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ErrorDialog.openError((Shell)EnableDisableBreakpointRulerAction.this.getTextEditor().getEditorSite().getShell(), (String)"Enabling/disabling breakpoints", (String)"Exceptions occurred enabling disabling the breakpoint", (IStatus)e.getStatus());
                            }
                        });
                        return Status.CANCEL_STATUS;
                    }
                }
            }.schedule();
        }
    }
}

