/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.actions;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.DebugPopup;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;

public class EvalExpressionAction
extends AbstractHandler
implements IHandler,
IEditorActionDelegate {
    public static final String ACTION_DEFINITION_ID = "org.python.pydev.debug.command.Display";
    private ITextSelection fSelection;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void run(IAction action) {
        if (this.fSelection == null) {
            return;
        }
        String text = this.fSelection.getText();
        this.eval(text);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = null;
        if (selection instanceof ITextSelection) {
            this.fSelection = (ITextSelection)selection;
        }
    }

    private void eval(final String expr) {
        final IWatchExpression expression = EvalExpressionAction.createWatchExpression(expr);
        final Shell shell = PydevDebugPlugin.getActiveWorkbenchWindow().getShell();
        Display display = PydevDebugPlugin.getDefault().getWorkbench().getDisplay();
        final Point point = display.getCursorLocation();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                expression.evaluate();
                EvalExpressionAction.waitForExpressionEvaluation(expression);
                try {
                    IValue value = expression.getValue();
                    String result = null;
                    if (value != null) {
                        result = expr + "\n" + value.getValueString();
                        DisplayPopup popup = new DisplayPopup(shell, point, result);
                        popup.open();
                    }
                }
                catch (DebugException e) {
                    DebugPlugin.log((Throwable)e);
                    return;
                }
                catch (Throwable t) {
                    DebugPlugin.log((Throwable)t);
                }
            }
        });
    }

    public static void waitForExpressionEvaluation(IWatchExpression expression) {
        while (expression.isPending()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static IWatchExpression createWatchExpression(String expr) {
        IWatchExpression expression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(expr);
        IAdaptable object = DebugUITools.getDebugContext();
        IDebugElement context = null;
        if (object instanceof IDebugElement) {
            context = (IDebugElement)object;
        } else if (object instanceof ILaunch) {
            context = ((ILaunch)object).getDebugTarget();
        }
        expression.setExpressionContext(context);
        return expression;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object applicationContext = event.getApplicationContext();
        if (applicationContext instanceof IEvaluationContext) {
            String expr;
            Object sel;
            Set set;
            IEvaluationContext evalCtx = (IEvaluationContext)applicationContext;
            Object obj = evalCtx.getDefaultVariable();
            if (obj instanceof Set && (set = (Set)obj).size() > 0 && (sel = set.iterator().next()) instanceof TextSelection && (expr = ((TextSelection)sel).getText()) != null && expr.trim().length() > 0) {
                this.eval(expr);
            }
        } else {
            Log.log((String)("Expected IEvaluationContext. Received: " + String.valueOf(applicationContext.getClass())));
        }
        return null;
    }

    private class DisplayPopup
    extends DebugPopup {
        private String text;

        public DisplayPopup(Shell shell, Point point, String text) {
            super(shell, point, "org.python.pydev.debug.command.Display2");
            this.text = text;
        }

        protected String getActionText() {
            return "Move to Display view";
        }

        protected void persist() {
            super.persist();
        }

        protected Control createDialogArea(Composite parent) {
            GridData gd = new GridData(1808);
            StyledText text = new StyledText(parent, 842);
            text.setLayoutData((Object)gd);
            text.setForeground(parent.getDisplay().getSystemColor(28));
            text.setBackground(parent.getDisplay().getSystemColor(29));
            text.setText(this.text);
            return text;
        }
    }
}

