/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.PyVariablesPreferences;

public abstract class AbstractShowReferencesActionDelegate
extends ViewerFilter
implements IPropertyChangeListener,
IActionDelegate2,
IViewActionDelegate {
    private IAction fAction;
    private IViewPart fView;

    protected StructuredViewer getStructuredViewer() {
        Viewer viewer;
        if (this.fView == null) {
            return null;
        }
        IDebugView view = (IDebugView)this.fView.getAdapter(IDebugView.class);
        if (view != null && (viewer = view.getViewer()) instanceof StructuredViewer) {
            return (StructuredViewer)viewer;
        }
        return null;
    }

    public void run(IAction action) {
        boolean checked = action.isChecked();
        this.setShowReferences(checked);
        StructuredViewer structuredViewer = this.getStructuredViewer();
        if (structuredViewer != null) {
            ViewerFilter[] filters = structuredViewer.getFilters();
            boolean alreadyAdded = false;
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (filter == this) {
                    alreadyAdded = true;
                    break;
                }
                ++n2;
            }
            if (!alreadyAdded) {
                structuredViewer.addFilter((ViewerFilter)this);
            } else {
                structuredViewer.refresh();
            }
        }
    }

    public void init(IAction action) {
        this.fAction = action;
        action.setChecked(this.isShowReference());
        PyVariablesPreferences.addPropertyChangeListener(this);
        this.run(this.fAction);
    }

    public void init(IViewPart view) {
        this.fView = view;
        this.run(this.fAction);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
        PyVariablesPreferences.removePropertyChangeListener(this);
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (this.isShowReferenceProperty(property) && this.fAction != null) {
            this.fAction.setChecked(this.isShowReference());
            this.run(this.fAction);
        }
    }

    protected abstract boolean isShowReferenceProperty(String var1);

    protected abstract boolean isShowReference();

    protected abstract void setShowReferences(boolean var1);

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.isShowReference()) {
            return true;
        }
        if (element instanceof PyVariable) {
            PyVariable variable = (PyVariable)element;
            try {
                String name = variable.getName();
                return this.select(viewer, parentElement, variable, name);
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return true;
    }

    protected boolean select(Viewer viewer, Object parentElement, PyVariable variable, String variableName) {
        return true;
    }
}

