/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.indexview;

import com.python.pydev.analysis.indexview.ElementWithChildren;
import com.python.pydev.analysis.indexview.ITreeElement;
import com.python.pydev.analysis.indexview.LeafElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.python.pydev.ast.codecompletion.revisited.SystemModulesManager;
import org.python.pydev.ast.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.ast.interpreter_managers.InterpreterInfo;
import org.python.pydev.core.BaseModuleRequest;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IToken;
import org.python.pydev.core.IterTokenEntry;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.TokensList;

public class ForcedLibGroup
extends ElementWithChildren {
    private InterpreterInfo interpreterInfo;
    private String forcedLib;

    public ForcedLibGroup(ITreeElement parent, InterpreterInfo interpreterInfo, String forcedLib) {
        super(parent);
        this.interpreterInfo = interpreterInfo;
        this.forcedLib = forcedLib;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    protected void calculateChildren() throws MisconfigurationException {
        SystemModulesManager m = (SystemModulesManager)this.interpreterInfo.getModulesManager();
        AbstractModule builtinModule = m.getBuiltinModule(this.forcedLib, true, (IModuleRequestState)new BaseModuleRequest(true));
        TokensList globalTokens = builtinModule.getGlobalTokens();
        ArrayList<LeafElement> lst = new ArrayList<LeafElement>();
        for (IterTokenEntry entry : globalTokens) {
            IToken iToken = entry.getToken();
            lst.add(new LeafElement(this, iToken.getRepresentation()));
        }
        Collections.sort(lst, new Comparator<LeafElement>(){

            @Override
            public int compare(LeafElement o1, LeafElement o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (LeafElement leafElement : lst) {
            this.addChild(leafElement);
        }
    }

    public String toString() {
        return "Forced builtin: " + this.forcedLib;
    }
}

