/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.search_index;

import com.python.pydev.analysis.AnalysisUiPlugin;
import com.python.pydev.analysis.search_index.PySearchIndexQuery;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_ui.search.AbstractSearchIndexPage;
import org.python.pydev.shared_ui.search.ScopeAndData;
import org.python.pydev.shared_ui.search.SearchIndexData;

public class PySearchIndexPage
extends AbstractSearchIndexPage {
    public PySearchIndexPage() {
        super(AnalysisUiPlugin.getDialogSettings());
    }

    public boolean performAction() {
        ScopeAndData scopeAndData = this.getScopeAndData();
        SearchIndexData data = new SearchIndexData(this.fPattern.getText(), this.fIsCaseSensitiveCheckbox.getSelection(), this.fIsWholeWordCheckbox.getSelection(), scopeAndData.scope, scopeAndData.scopeData, "*");
        PySearchIndexQuery query = new PySearchIndexQuery(data);
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        this.searchIndexDataHistory.add(data);
        this.searchIndexDataHistory.writeConfiguration();
        return true;
    }

    protected void checkSelectedResource(Collection<String> projectNames, Collection<String> moduleNames, IResource resource) {
        if (resource != null && resource.isAccessible()) {
            String moduleName;
            IProject project = resource.getProject();
            projectNames.add(project.getName());
            PythonNature nature = PythonNature.getPythonNature((IProject)project);
            if (nature == null) {
                return;
            }
            try {
                moduleName = nature.resolveModule(resource);
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
                return;
            }
            if (moduleName != null) {
                for (String s : moduleNames) {
                    if (!s.endsWith(".*") || !moduleName.startsWith(s.substring(0, s.length() - 1))) continue;
                    return;
                }
                if (resource instanceof IContainer) {
                    moduleNames.add(moduleName + ".*");
                } else {
                    moduleNames.add(moduleName);
                }
            }
        }
    }
}

