/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.ui;

import com.python.pydev.analysis.AnalysisUiPlugin;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;
import org.python.pydev.shared_ui.field_editors.LinkFieldEditor;
import org.python.pydev.shared_ui.field_editors.RadioGroupFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;

public class AnalysisPreferencesPage
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public AnalysisPreferencesPage() {
        super(0);
        this.setDescription("PyDev Analysis");
        this.setPreferenceStore(null);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return AnalysisUiPlugin.getPreferenceStore();
    }

    public void createFieldEditors() {
        Composite initialParent;
        Composite p = initialParent = this.getFieldEditorParent();
        this.addField((FieldEditor)new LabelFieldEditor("Analysis_pref_note", "NOTE: Any file with the comment below will not be analyzed.\n\n#@PydevCodeAnalysisIgnore\n\n", p));
        BooleanFieldEditor field = new BooleanFieldEditor("DO_CODE_ANALYSIS", "Do code analysis?", 0, p);
        this.addField((FieldEditor)field);
        TabFolder tabFolder = new TabFolder(p, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        String[][] values = new String[][]{{"Error", String.valueOf(2)}, {"Warning", String.valueOf(1)}, {"Info", String.valueOf(0)}, {"Ignore", String.valueOf(-1)}};
        p = this.createTab(tabFolder, "Unused");
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_UNUSED_IMPORT", "Unused import", 4, values, p, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_UNUSED_WILD_IMPORT", "Unused wild import", 4, values, p, true));
        this.addField((FieldEditor)new StringFieldEditor("NAMES_TO_IGNORE_UNUSED_IMPORT", "Don't report unused imports in modules named: (comma separated)", p));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_UNUSED_PARAMETER", "Unused parameter", 4, values, p, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_UNUSED_VARIABLE", "Unused variable", 4, values, p, true));
        this.addField((FieldEditor)new StringFieldEditor("NAMES_TO_IGNORE_UNUSED_VARIABLE", "Don't report unused variable if name starts with: (comma separated)", p){

            public int getNumberOfControls() {
                return 1;
            }
        });
        p = this.createTab(tabFolder, "Undefined");
        this.addField((FieldEditor)new StringFieldEditor("NAMES_TO_CONSIDER_GLOBALS", "Consider the following names as globals: (comma separated)", p));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_UNDEFINED_VARIABLE", "Undefined variable", 4, values, p, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_UNDEFINED_IMPORT_VARIABLE", "Undefined variable from import", 4, values, p, true));
        p = this.createTab(tabFolder, "Imports");
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_REIMPORT", "Import redefinition", 4, values, p, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_UNRESOLVED_IMPORT", "Import not found", 4, values, p, true));
        p = this.createTab(tabFolder, "Others");
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_DUPLICATED_SIGNATURE", "Duplicated signature", 4, values, p, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_NO_SELF", "'self' not specified in class method", 4, values, p, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_NO_EFFECT_STMT", "Statement has no effect", 4, values, p, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_INDENTATION_PROBLEM", "Indentation problems and mixing of tabs/spaces", 4, values, p, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_ASSIGNMENT_TO_BUILT_IN_SYMBOL", "Redefinition of builtin symbols", 4, values, p, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_INVALID_ENCODING", "Unsupported encoding", 4, values, p, true));
        p = this.createTab(tabFolder, "pycodestyle.py (pep8)");
        String[][] pep8values = new String[][]{{"Error", String.valueOf(2)}, {"Warning", String.valueOf(1)}, {"Info", String.valueOf(0)}, {"Don't run", String.valueOf(-1)}};
        this.addField((FieldEditor)new RadioGroupFieldEditor("SEVERITY_PEP8", "Pep8", 4, pep8values, p, true){

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, 4);
                this.adjustForNumColumns(4);
            }
        });
        this.addField((FieldEditor)new BooleanFieldEditor("PEP8_USE_SYSTEM", "Use system interpreter (may be faster than internal Jython)", p){

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, 4);
                this.adjustForNumColumns(4);
            }
        });
        this.addField((FieldEditor)new LinkFieldEditor("PEP8_IGNORE_WARNINGS", "Additional command line arguments (i.e.: --ignore=E5,W391). See <a>pycodestyle docs</a> for details.", p, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"https://pycodestyle.readthedocs.io/");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }){

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                numColumns = 4;
                Link linkControl = this.getLinkControl(parent);
                Object layoutData = linkControl.getLayoutData();
                if (layoutData == null) {
                    layoutData = new GridData();
                    linkControl.setLayoutData(layoutData);
                }
                ((GridData)layoutData).horizontalSpan = numColumns;
                this.adjustForNumColumns(4);
            }
        });
        this.addField((FieldEditor)new StringFieldEditor("PEP8_IGNORE_WARNINGS", "Arguments: ", p){

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, 4);
                this.adjustForNumColumns(4);
            }
        });
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(initialParent, "org.python.pydev", (ScopedFieldEditorPreferencePage)this));
    }

    private Composite createTab(TabFolder tabFolder, String tabText) {
        TabItem item1 = new TabItem(tabFolder, 0);
        item1.setText(tabText);
        Composite p1 = new Composite((Composite)tabFolder, 0);
        p1.setLayoutData((Object)new GridData(1808));
        item1.setControl((Control)p1);
        return p1;
    }

    public void init(IWorkbench workbench) {
    }
}

