/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.codecompletion.ui;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.ast.codecompletion.PyCodeCompletionPreferences;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;

public class CodeCompletionPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public CodeCompletionPreferencesPage() {
        super(0);
        this.setDescription("PyDev Code Completion");
        this.setPreferenceStore(null);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PyDevUiPrefs.getPreferenceStore();
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new IntegerFieldEditor("CHARS_FOR_CTX_INSENSITIVE_MODULES_COMPLETION", "Number of chars for showing modules in context-insensitive completions?", p));
        this.addField((FieldEditor)new IntegerFieldEditor("CHARS_FOR_CTX_INSENSITIVE_TOKENS_COMPLETION", "Number of chars for showing global tokens in context-insensitive completions?", p));
        this.addField((FieldEditor)new BooleanFieldEditor("USE_KEYWORDS_CODE_COMPLETION", "Use common tokens auto code completion?", p));
        this.addField((FieldEditor)new LabelFieldEditor("LabelFieldEditor", "", p));
        this.addField((FieldEditor)new BooleanFieldEditor("ADD_SPACE_WHEN_NEEDED", "Add <SPACE> for common cases (e.g.: \"and \", \"assert \", etc.)?", p));
        this.addField((FieldEditor)new LabelFieldEditor("LabelFieldEditor", "", p));
        this.addField((FieldEditor)new BooleanFieldEditor("ADD_SPACE_AND_COLON_WHEN_NEEDED", "Add <SPACE><COLON> for common cases (e.g.: \"class :\", \"if :\", etc.)?", p));
        this.addField((FieldEditor)new LabelFieldEditor("LabelFieldEditor", "", p));
        this.addField((FieldEditor)new ListEditor("KEYWORDS_CODE_COMPLETION", "Tokens to use:", p){

            protected String createList(String[] items) {
                return PyCodeCompletionPreferences.wordsAsString((String[])items);
            }

            protected String getNewInputObject() {
                InputDialog d = new InputDialog(this.getShell(), "New word", "Add the word you wish.", "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.indexOf(32) != -1) {
                            return "The input cannot have spaces";
                        }
                        return null;
                    }
                });
                int retCode = d.open();
                if (retCode == 0) {
                    return d.getValue();
                }
                return null;
            }

            protected String[] parseString(String stringList) {
                return PyCodeCompletionPreferences.stringAsWords((String)stringList);
            }

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, numColumns);
                List listControl = this.getListControl(parent);
                GridData layoutData = (GridData)listControl.getLayoutData();
                layoutData.heightHint = 300;
            }
        });
    }

    public void init(IWorkbench workbench) {
    }
}

