/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.flake8;

import com.python.pydev.analysis.flake8.Flake8CodesConfigHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.json.eclipsesource.JsonValue;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.WrapAndCaseUtils;
import org.python.pydev.shared_ui.field_editors.ArgsStringFieldEditor;
import org.python.pydev.shared_ui.field_editors.JsonFieldEditor;
import org.python.pydev.shared_ui.field_editors.RadioGroupFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;

public class Flake8PrefPage
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite parent;
    private RadioGroupFieldEditor searchFlake8Location;
    private FileFieldEditor fileField;
    private List<FieldEditor> fields = new ArrayList<FieldEditor>(5);
    private JsonFieldEditor jsonFieldEditor;
    public static final int COLS = 4;
    public static final String[][] SEARCH_FLAKE8_LOCATION_OPTIONS = new String[][]{{"Search in interpreter", "SEARCH"}, {"Specify Location", "SPECIFY"}};

    public Flake8PrefPage() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Flake8");
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.updateSelectFileEnablement(this.parent);
    }

    protected void createFieldEditors() {
        this.parent = this.getFieldEditorParent();
        this.parent.setLayout((Layout)new GridLayout(1, false));
        this.addField((FieldEditor)new BooleanFieldEditor("USE_FLAKE8", "Use Flake8?", this.parent));
        this.addField((FieldEditor)new BooleanFieldEditor("FLAKE8_USE_CONSOLE", "Redirect Flake8 output to console?", this.parent));
        this.searchFlake8Location = new RadioGroupFieldEditor("SEARCH_FLAKE8_LOCATION", "Flake8 to use", 2, SEARCH_FLAKE8_LOCATION_OPTIONS, this.parent);
        Button[] buttonArray = this.searchFlake8Location.getRadioButtons();
        int n = buttonArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Flake8PrefPage.this.updateSelectFileEnablement(Flake8PrefPage.this.parent);
                }
            });
            ++n2;
        }
        this.addField((FieldEditor)this.searchFlake8Location);
        this.fileField = new FileFieldEditor("FLAKE8_FILE_LOCATION", "Location of the flake8 executable:", true, this.parent);
        this.addField((FieldEditor)this.fileField);
        this.jsonFieldEditor = new JsonFieldEditor("FLAKE8_CODES_CONFIG", WrapAndCaseUtils.wrap((String)"Flake 8 severity map (unmatched entries will be marked as \"warning\")", (int)90), this.parent);
        this.jsonFieldEditor.setAdditionalJsonValidation(json -> Flake8CodesConfigHandler.checkJsonFormat((JsonValue)json));
        this.addField((FieldEditor)this.jsonFieldEditor);
        ArgsStringFieldEditor stringFieldEditor = new ArgsStringFieldEditor("FLAKE8_ARGS", "Arguments to pass to the flake8 command.", this.parent);
        this.addField((FieldEditor)stringFieldEditor);
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(this.parent, "org.python.pydev", (ScopedFieldEditorPreferencePage)this));
    }

    protected void addField(FieldEditor editor) {
        super.addField(editor);
        this.fields.add(editor);
    }

    protected void adjustGridLayout() {
        this.parent = this.getFieldEditorParent();
        this.parent.setLayout((Layout)new GridLayout(1, false));
    }

    protected void updateSelectFileEnablement(Composite p) {
        this.fileField.setEnabled("SPECIFY".equals(this.searchFlake8Location.getRadioValue()), p);
    }
}

