/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.mypy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_ui.field_editors.ArgsStringFieldEditor;
import org.python.pydev.shared_ui.field_editors.LinkFieldEditor;
import org.python.pydev.shared_ui.field_editors.RadioGroupFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;

public class MypyPrefPage
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite parent;
    private RadioGroupFieldEditor searchMypyLocation;
    private FileFieldEditor fileField;
    private List<FieldEditor> fields = new ArrayList<FieldEditor>(5);
    public static final String[][] SEARCH_MYPY_LOCATION_OPTIONS = new String[][]{{"Search in interpreter", "SEARCH"}, {"Specify Location", "SPECIFY"}};

    public MypyPrefPage() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Mypy");
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.updateSelectFileEnablement(this.parent);
    }

    protected void createFieldEditors() {
        this.parent = this.getFieldEditorParent();
        this.parent.setLayout((Layout)new GridLayout(1, false));
        this.addField((FieldEditor)new BooleanFieldEditor("USE_MYPY", "Use Mypy?", this.parent));
        this.addField((FieldEditor)new BooleanFieldEditor("MYPY_ADD_PROJECT_FOLDERS_TO_MYPYPATH", "Add project source folders to MYPYPATH?", this.parent));
        this.addField((FieldEditor)new BooleanFieldEditor("MYPY_USE_CONSOLE", "Redirect Mypy output to console?", this.parent));
        this.searchMypyLocation = new RadioGroupFieldEditor("SEARCH_MYPY_LOCATION", "Mypy to use", 2, SEARCH_MYPY_LOCATION_OPTIONS, this.parent);
        Button[] buttonArray = this.searchMypyLocation.getRadioButtons();
        int n = buttonArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MypyPrefPage.this.updateSelectFileEnablement(MypyPrefPage.this.parent);
                }
            });
            ++n2;
        }
        this.addField((FieldEditor)this.searchMypyLocation);
        this.fileField = new FileFieldEditor("MYPY_FILE_LOCATION", "Location of the mypy executable:", true, this.parent);
        this.addField((FieldEditor)this.fileField);
        ArgsStringFieldEditor stringFieldEditor = new ArgsStringFieldEditor("MYPY_ARGS", "Arguments to pass to the mypy command.", this.parent);
        this.addField((FieldEditor)stringFieldEditor);
        this.addField((FieldEditor)new LinkFieldEditor("MYPY_HELP", "View <a>http://www.pydev.org/manual_adv_mypy.html</a> for help.", this.parent, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"http://www.pydev.org/manual_adv_mypy.html");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }));
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(this.parent, "org.python.pydev", (ScopedFieldEditorPreferencePage)this));
    }

    protected void addField(FieldEditor editor) {
        super.addField(editor);
        this.fields.add(editor);
    }

    protected void adjustGridLayout() {
        this.parent = this.getFieldEditorParent();
        this.parent.setLayout((Layout)new GridLayout(1, false));
    }

    protected void updateSelectFileEnablement(Composite p) {
        this.fileField.setEnabled("SPECIFY".equals(this.searchMypyLocation.getRadioValue()), p);
    }
}

