/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.syntaxchecker;

import java.util.ListResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.logging.DebugSettings;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.preferences.PyDevBuilderPreferences;
import org.python.pydev.shared_core.log.ToLogFile;
import org.python.pydev.shared_ui.editor.BaseEditor;
import org.python.pydev.shared_ui.editor.IPyEditListener;
import org.python.pydev.shared_ui.editor.IPyEditListener3;

public class ClearSyntaxMarkersPyeditListener
implements IPyEditListener,
IPyEditListener3 {
    public void onCreateActions(ListResourceBundle resources, BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onDispose(BaseEditor baseEditor, IProgressMonitor monitor) {
        PyEdit edit = (PyEdit)baseEditor;
        IEditorInput input = edit.getEditorInput();
        this.removeMarkersFromInput(input);
    }

    public void onSave(BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onSetDocument(IDocument document, BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onInputChanged(BaseEditor baseEditor, IEditorInput oldInput, IEditorInput input, IProgressMonitor monitor) {
        this.removeMarkersFromInput(oldInput);
    }

    private void removeMarkersFromInput(IEditorInput input) {
        if (input != null && PyDevBuilderPreferences.getAnalyzeOnlyActiveEditor()) {
            IFile relatedFile;
            if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                ToLogFile.toLogFile((Object)this, (String)"removing syntax error markers from editor.");
            }
            if ((relatedFile = (IFile)input.getAdapter(IFile.class)) != null && relatedFile.exists()) {
                try {
                    PyParser.deleteErrorMarkers((IResource)relatedFile);
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
        }
    }
}

