/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.syntaxchecker;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.builder.PyDevBuilderVisitor;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.logging.DebugSettings;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.preferences.PyDevBuilderPreferences;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.log.ToLogFile;

public class PySyntaxChecker
extends PyDevBuilderVisitor {
    public void visitChangedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        SourceModule mod;
        IDocument doc;
        PythonNature nature = this.getPythonNature(resource);
        if (nature == null) {
            return;
        }
        if (PyDevBuilderPreferences.getAnalyzeOnlyActiveEditor()) {
            if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                ToLogFile.toLogFile((Object)((Object)this), (String)"PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor()");
            }
            return;
        }
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            ToLogFile.toLogFile((Object)((Object)this), (String)"Checking!");
        }
        if ((doc = (IDocument)document.call()) == null) {
            return;
        }
        try {
            mod = this.getSourceModule(resource, doc, (IPythonNature)nature);
        }
        catch (MisconfigurationException e1) {
            Log.log((Throwable)e1);
            return;
        }
        Throwable parseError = mod.parseError;
        try {
            PyParser.deleteErrorMarkers((IResource)resource);
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        if (parseError != null) {
            PyParser.createParserErrorMarkers((Throwable)parseError, (IAdaptable)resource, (IDocument)doc);
        }
    }

    public void visitRemovedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
    }
}

