/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.todo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.builder.PyDevBuilderVisitor;
import org.python.pydev.builder.todo.PyTodoPrefPage;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.logging.DebugSettings;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.log.ToLogFile;
import org.python.pydev.shared_core.markers.PyMarkerUtils;

public class PyTodoVisitor
extends PyDevBuilderVisitor {
    public void visitChangedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        if (document != null) {
            List<String> todoTags = PyTodoPrefPage.getTodoTags();
            try {
                if (!this.isResourceInPythonpathProjectSources(resource, (IPythonNature)this.getPythonNature(resource), false)) {
                    PyMarkerUtils.removeMarkers((IResource)resource, (String)"org.eclipse.core.resources.taskmarker");
                    return;
                }
            }
            catch (Exception e1) {
                Log.log((Throwable)e1);
                return;
            }
            try {
                PyMarkerUtils.replaceMarkers(this.computeTodoMarkers((IDocument)document.call(), todoTags), (IResource)resource, (String)"org.eclipse.core.resources.taskmarker", (boolean)false, (IProgressMonitor)monitor);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    List<PyMarkerUtils.MarkerInfo> computeTodoMarkers(IDocument document, List<String> todoTags) throws BadLocationException {
        ArrayList<PyMarkerUtils.MarkerInfo> lst = new ArrayList<PyMarkerUtils.MarkerInfo>();
        if (todoTags.size() > 0 && document != null) {
            String str = document.get();
            ParsingUtils utils = ParsingUtils.create((Object)str);
            int len = utils.len();
            try {
                int i = 0;
                while (i < len) {
                    char c = str.charAt(i);
                    switch (c) {
                        case '\"': 
                        case '\'': {
                            int j = utils.eatLiterals(null, i);
                            this.check(i, j, document, lst, todoTags);
                            i = j;
                            break;
                        }
                        case '#': {
                            int j = utils.eatComments(null, i);
                            this.check(i, j, document, lst, todoTags);
                            i = j;
                        }
                    }
                    ++i;
                }
            }
            catch (BadLocationException i) {
            }
            catch (SyntaxErrorException e) {
                Log.log((Throwable)e);
            }
            if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                ToLogFile.toLogFile((Object)((Object)this), (String)"Adding todo markers");
            }
        }
        return lst;
    }

    private void check(int i, int j, IDocument document, List<PyMarkerUtils.MarkerInfo> lst, List<String> todoTags) throws BadLocationException {
        String tok = document.get(i, j - i);
        HashSet<Integer> lines = new HashSet<Integer>();
        for (String element : todoTags) {
            int index;
            if (element.length() == 0) continue;
            int start = 0;
            while ((index = tok.indexOf(element, start)) != -1) {
                start = index + element.length();
                int absoluteStart = i + index;
                int line = document.getLineOfOffset(absoluteStart);
                if (lines.contains(line)) continue;
                lines.add(line);
                Object message = tok.substring(index).trim();
                if (((String)message).length() > 1024) {
                    message = ((String)message).substring(0, 1024) + " ...";
                }
                String markerType = "org.eclipse.core.resources.taskmarker";
                int severity = 1;
                boolean userEditable = false;
                boolean isTransient = false;
                int absoluteEnd = absoluteStart + ((String)message).length();
                Map additionalInfo = null;
                PyMarkerUtils.MarkerInfo markerInfo = new PyMarkerUtils.MarkerInfo(document, (String)message, markerType, severity, userEditable, isTransient, line, absoluteStart, absoluteEnd, additionalInfo);
                lst.add(markerInfo);
            }
        }
    }

    public void visitRemovedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
    }
}

