/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.consoles;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.python.pydev.shared_core.image.IImageDescriptor;
import org.python.pydev.shared_ui.ConsoleColorCache;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class MessageConsoles {
    private static Map<String, MessageConsole> consoles = new HashMap<String, MessageConsole>();
    private static Map<String, IOConsoleOutputStream> consoleOutputs = new HashMap<String, IOConsoleOutputStream>();
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOConsoleOutputStream getConsoleOutputStream(String name, String iconPath) {
        Object object = lock;
        synchronized (object) {
            IOConsoleOutputStream outputStream = consoleOutputs.get(name);
            if (outputStream == null) {
                MessageConsole console = MessageConsoles.getConsole(name, iconPath);
                HashMap<IOConsoleOutputStream, String> themeConsoleStreamToColor = new HashMap<IOConsoleOutputStream, String>();
                outputStream = console.newOutputStream();
                themeConsoleStreamToColor.put(outputStream, "console.output");
                console.setAttribute("themeConsoleStreamToColor", themeConsoleStreamToColor);
                ConsoleColorCache.getDefault().keepConsoleColorsSynched((IOConsole)console);
                consoles.put(name, console);
                consoleOutputs.put(name, outputStream);
            }
            return outputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageConsole getConsole(String name, String iconPath) {
        Object object = lock;
        synchronized (object) {
            MessageConsole console = consoles.get(name);
            if (console == null) {
                console = new MessageConsole(name, ImageCache.asImageDescriptor((IImageDescriptor)SharedUiPlugin.getImageCache().getDescriptor(iconPath)));
                ConsoleColorCache.getDefault().keepConsoleColorsSynched((IOConsole)console);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
                consoles.put(name, console);
            }
            return console;
        }
    }
}

